/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.dialog;

import jadx.gui.logs.LogOptions;
import jadx.gui.logs.LogPanel;
import jadx.gui.settings.JadxSettings;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class LogViewerDialog
extends JFrame {
    private static final long serialVersionUID = -2188700277429054641L;
    private static LogViewerDialog openLogDialog;
    private final transient JadxSettings settings;
    private final transient LogPanel logPanel;

    public static void open(MainWindow mainWindow, LogOptions logOptions) {
        LogViewerDialog logDialog;
        if (openLogDialog != null) {
            logDialog = openLogDialog;
        } else {
            openLogDialog = logDialog = new LogViewerDialog(mainWindow, logOptions);
        }
        logDialog.setVisible(true);
        logDialog.toFront();
    }

    private LogViewerDialog(MainWindow mainWindow, LogOptions logOptions) {
        this.settings = mainWindow.getSettings();
        UiUtils.setWindowIcons(this);
        Runnable dock = () -> {
            mainWindow.getSettings().saveDockLogViewer(true);
            this.dispose();
            mainWindow.showLogViewer(LogOptions.current());
        };
        this.logPanel = new LogPanel(mainWindow, logOptions, dock, this::dispose);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.logPanel, "Center");
        this.setTitle(NLS.str("log_viewer.title"));
        this.pack();
        this.setSize(800, 600);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
        this.settings.loadWindowPos(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                openLogDialog = null;
            }
        });
    }

    @Override
    public void dispose() {
        this.logPanel.dispose();
        this.settings.saveWindowPos(this);
        super.dispose();
    }
}

