/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea.theme;

import jadx.gui.ui.codearea.theme.IEditorTheme;
import java.io.InputStream;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSTABundledTheme
implements IEditorTheme {
    private static final Logger LOG = LoggerFactory.getLogger(RSTABundledTheme.class);
    private static final String RSTA_THEME_PATH = "/org/fife/ui/rsyntaxtextarea/themes/";
    private final String name;
    private Theme loadedTheme;

    public RSTABundledTheme(String name) {
        this.name = name;
    }

    @Override
    public String getId() {
        return "RSTA:" + this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void load() {
        String path = RSTA_THEME_PATH + this.name + ".xml";
        try (InputStream is = RSTABundledTheme.class.getResourceAsStream(path);){
            this.loadedTheme = Theme.load((InputStream)is);
        }
        catch (Throwable t) {
            LOG.error("Failed to load editor theme: {}", (Object)path, (Object)t);
            this.loadedTheme = new Theme(new RSyntaxTextArea());
        }
    }

    @Override
    public void apply(RSyntaxTextArea textArea) {
        this.loadedTheme.apply(textArea);
    }

    @Override
    public void unload() {
        this.loadedTheme = null;
    }
}

