/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.core.utils.StringUtils;
import jadx.gui.utils.Icons;
import jadx.gui.utils.NLS;
import jadx.gui.utils.TextStandardActions;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchBar
extends JToolBar {
    private static final long serialVersionUID = 1836871286618633003L;
    private static final Logger LOG = LoggerFactory.getLogger(SearchBar.class);
    private static final int MAX_RESULT_COUNT = 999;
    private final RSyntaxTextArea rTextArea;
    private final JTextField searchField;
    private final JLabel resultCountLabel;
    private final JToggleButton markAllCB;
    private final JToggleButton regexCB;
    private final JToggleButton wholeWordCB;
    private final JToggleButton matchCaseCB;
    private boolean notFound;

    public SearchBar(RSyntaxTextArea textArea) {
        this.rTextArea = textArea;
        JLabel findLabel = new JLabel(NLS.str("search.find") + ":");
        this.add(findLabel);
        this.searchField = new JTextField(30);
        this.searchField.putClientProperty("JTextField.showClearButton", true);
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: {
                        break;
                    }
                    case 27: {
                        SearchBar.this.toggle();
                        break;
                    }
                    default: {
                        SearchBar.this.search(0);
                    }
                }
            }
        });
        this.searchField.addActionListener(e -> this.search(1));
        TextStandardActions.attach(this.searchField);
        this.add(this.searchField);
        ActionListener forwardListener = e -> this.search(1);
        this.resultCountLabel = new JLabel();
        this.resultCountLabel.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.resultCountLabel.setForeground(Color.GRAY);
        this.add(this.resultCountLabel);
        this.setResultCount(0);
        this.matchCaseCB = new JToggleButton();
        this.matchCaseCB.setIcon(Icons.ICON_MATCH);
        this.matchCaseCB.setSelectedIcon(Icons.ICON_MATCH_SELECTED);
        this.matchCaseCB.setToolTipText(NLS.str("search.match_case"));
        this.matchCaseCB.addActionListener(forwardListener);
        this.add(this.matchCaseCB);
        this.wholeWordCB = new JToggleButton();
        this.wholeWordCB.setIcon(Icons.ICON_WORDS);
        this.wholeWordCB.setSelectedIcon(Icons.ICON_WORDS_SELECTED);
        this.wholeWordCB.setToolTipText(NLS.str("search.whole_word"));
        this.wholeWordCB.addActionListener(forwardListener);
        this.add(this.wholeWordCB);
        this.regexCB = new JToggleButton();
        this.regexCB.setIcon(Icons.ICON_REGEX);
        this.regexCB.setSelectedIcon(Icons.ICON_REGEX_SELECTED);
        this.regexCB.setToolTipText(NLS.str("search.regex"));
        this.regexCB.addActionListener(forwardListener);
        this.add(this.regexCB);
        JButton prevButton = new JButton();
        prevButton.setIcon(Icons.ICON_UP);
        prevButton.setToolTipText(NLS.str("search.previous"));
        prevButton.addActionListener(e -> this.search(-1));
        prevButton.setBorderPainted(false);
        this.add(prevButton);
        JButton nextButton = new JButton();
        nextButton.setIcon(Icons.ICON_DOWN);
        nextButton.setToolTipText(NLS.str("search.next"));
        nextButton.addActionListener(e -> this.search(1));
        nextButton.setBorderPainted(false);
        this.add(nextButton);
        this.markAllCB = new JToggleButton();
        this.markAllCB.setIcon(Icons.ICON_MARK);
        this.markAllCB.setSelectedIcon(Icons.ICON_MARK_SELECTED);
        this.markAllCB.setToolTipText(NLS.str("search.mark_all"));
        this.markAllCB.addActionListener(forwardListener);
        this.add(this.markAllCB);
        JButton closeButton = new JButton();
        closeButton.setIcon(Icons.ICON_CLOSE);
        closeButton.addActionListener(e -> this.toggle());
        closeButton.setBorderPainted(false);
        this.add(closeButton);
        this.setFloatable(false);
        this.setVisible(false);
    }

    public void showAndFocus() {
        this.setVisible(true);
        String selectedText = this.rTextArea.getSelectedText();
        if (!StringUtils.isEmpty((String)selectedText)) {
            this.searchField.setText(selectedText);
        }
        this.searchField.selectAll();
        this.searchField.requestFocus();
    }

    public void toggle() {
        boolean visible = !this.isVisible();
        this.setVisible(visible);
        if (visible) {
            String preferText = this.rTextArea.getSelectedText();
            if (!StringUtils.isEmpty((String)preferText)) {
                this.searchField.setText(preferText);
            }
            this.searchField.selectAll();
            this.searchField.requestFocus();
        } else {
            this.rTextArea.requestFocus();
        }
    }

    private void search(int direction) {
        String searchText = this.searchField.getText();
        if (searchText == null || searchText.isEmpty() || this.rTextArea.getText() == null) {
            this.setResultCount(0);
            return;
        }
        boolean forward = direction >= 0;
        boolean matchCase = this.matchCaseCB.isSelected();
        boolean regex = this.regexCB.isSelected();
        boolean wholeWord = this.wholeWordCB.isSelected();
        SearchContext context = new SearchContext();
        context.setSearchFor(searchText);
        context.setMatchCase(matchCase);
        context.setRegularExpression(regex);
        context.setSearchForward(forward);
        context.setWholeWord(wholeWord);
        context.setSearchWrap(true);
        context.setMarkAll(true);
        if (direction == 0 && !this.notFound) {
            try {
                int caretPos = this.rTextArea.getCaretPosition();
                int lineNum = this.rTextArea.getLineOfOffset(caretPos) - 1;
                if (lineNum > 1) {
                    this.rTextArea.setCaretPosition(this.rTextArea.getLineStartOffset(lineNum));
                }
            }
            catch (BadLocationException e) {
                LOG.error("Caret move error", (Throwable)e);
            }
        }
        SearchResult result = SearchEngine.find((JTextArea)this.rTextArea, (SearchContext)context);
        this.setResultCount(result.getMarkedCount());
        if (!this.markAllCB.isSelected()) {
            context.setMarkAll(false);
            SearchEngine.markAll((RTextArea)this.rTextArea, (SearchContext)context);
        }
        boolean bl = this.notFound = !result.wasFound();
        if (this.notFound) {
            this.searchField.putClientProperty("JComponent.outline", "error");
        } else {
            this.searchField.putClientProperty("JComponent.outline", "");
        }
        this.searchField.repaint();
    }

    private void setResultCount(int count) {
        boolean exceedsLimit = count > 999;
        String plusSign = exceedsLimit ? "+" : "";
        count = exceedsLimit ? 999 : count;
        this.resultCountLabel.setText(NLS.str("search.results", plusSign, count));
    }
}

