/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.action;

import jadx.gui.ui.action.ActionModel;
import jadx.gui.ui.action.IShortcutAction;
import jadx.gui.ui.menu.JadxMenu;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.shortcut.Shortcut;
import jadx.gui.utils.ui.ActionHandler;
import java.awt.event.ActionEvent;
import java.util.function.Consumer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.Nullable;

public class JadxGuiAction
extends ActionHandler
implements IShortcutAction {
    private static final String COMMAND_PREFIX = "JadxGuiAction.Command.";
    private final ActionModel actionModel;
    private final String id;
    private JComponent shortcutComponent = null;
    private KeyStroke addedKeyStroke = null;
    private Shortcut shortcut;

    public JadxGuiAction(ActionModel actionModel) {
        this.actionModel = actionModel;
        this.id = actionModel.name();
        this.updateProperties();
    }

    public JadxGuiAction(ActionModel actionModel, Runnable action) {
        super(action);
        this.actionModel = actionModel;
        this.id = actionModel.name();
        this.updateProperties();
    }

    public JadxGuiAction(ActionModel actionModel, Consumer<ActionEvent> consumer) {
        super(consumer);
        this.actionModel = actionModel;
        this.id = actionModel.name();
        this.updateProperties();
    }

    public JadxGuiAction(String id) {
        this.actionModel = null;
        this.id = id;
        this.updateProperties();
    }

    private void updateProperties() {
        if (this.actionModel == null) {
            return;
        }
        String name = this.actionModel.getName();
        String description = this.actionModel.getDescription();
        ImageIcon icon = this.actionModel.getIcon();
        if (name != null) {
            this.setName(name);
        }
        if (description != null) {
            this.setShortDescription(description);
        }
        if (icon != null) {
            this.setIcon(icon);
        }
    }

    @Override
    @Nullable
    public ActionModel getActionModel() {
        return this.actionModel;
    }

    @Override
    public void setShortcut(Shortcut shortcut) {
        this.shortcut = shortcut;
        if (shortcut != null) {
            this.setKeyBinding(shortcut.toKeyStroke());
        } else {
            this.setKeyBinding(null);
        }
    }

    public void setShortcutComponent(JComponent component) {
        this.shortcutComponent = component;
    }

    @Override
    public JComponent getShortcutComponent() {
        return this.shortcutComponent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
    }

    @Override
    public void performAction() {
        if (this.shortcutComponent != null && this.shortcutComponent != JadxMenu.JADX_MENU_COMPONENT && !this.shortcutComponent.isShowing()) {
            return;
        }
        String shortcutType = this.shortcut != null ? this.shortcut.getTypeString() : "null";
        this.actionPerformed(new ActionEvent(this, 1001, COMMAND_PREFIX + shortcutType));
    }

    public static boolean isSource(ActionEvent event) {
        String command = event.getActionCommand();
        return command != null && command.startsWith(COMMAND_PREFIX);
    }

    @Override
    public void setKeyBinding(KeyStroke keyStroke) {
        if (this.shortcutComponent == null) {
            super.setKeyBinding(keyStroke);
        } else {
            super.setKeyBinding(keyStroke);
            if (this.addedKeyStroke != null) {
                UiUtils.removeKeyBinding(this.shortcutComponent, this.addedKeyStroke, this.id);
            }
            UiUtils.addKeyBinding(this.shortcutComponent, keyStroke, this.id, this::performAction);
            this.addedKeyStroke = keyStroke;
        }
    }

    public String toString() {
        return "JadxGuiAction{" + this.id + ", component: " + String.valueOf(this.shortcutComponent) + "}";
    }
}

