/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.JavaNode;
import jadx.api.JavaPackage;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.popupmenu.JPackagePopupMenu;
import jadx.gui.utils.Icons;
import jadx.gui.utils.UiUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPopupMenu;

public class JPackage
extends JNode {
    private static final long serialVersionUID = -4120718634156839804L;
    public static final String PACKAGE_DEFAULT_HTML_STR = UiUtils.wrapHtml(UiUtils.fadeHtml(UiUtils.escapeHtml("<empty>")));
    private final JavaPackage pkg;
    private final boolean enabled;
    private final List<JClass> classes;
    private final List<JPackage> subPackages;
    private final boolean synthetic;
    private String name;

    public JPackage(JavaPackage pkg, boolean enabled, List<JClass> classes, List<JPackage> subPackages, boolean synthetic) {
        this.pkg = pkg;
        this.enabled = enabled;
        this.classes = classes;
        this.subPackages = subPackages;
        this.synthetic = synthetic;
    }

    public static JPackage makeTmpRoot() {
        return new JPackage(null, true, Collections.emptyList(), new ArrayList<JPackage>(), true);
    }

    public void update() {
        this.removeAllChildren();
        if (this.isEnabled()) {
            for (JPackage pkg : this.subPackages) {
                pkg.update();
                this.add(pkg);
            }
            for (JClass cls : this.classes) {
                cls.update();
                this.add(cls);
            }
        }
    }

    @Override
    public JPopupMenu onTreePopupMenu(MainWindow mainWindow) {
        return new JPackagePopupMenu(mainWindow, this);
    }

    public JavaPackage getPkg() {
        return this.pkg;
    }

    @Override
    public JavaNode getJavaNode() {
        return this.pkg;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<JPackage> getSubPackages() {
        return this.subPackages;
    }

    public List<JClass> getClasses() {
        return this.classes;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public Icon getIcon() {
        return Icons.PACKAGE;
    }

    @Override
    public JClass getJParent() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.pkg.equals((Object)((JPackage)o).pkg);
    }

    public int hashCode() {
        return this.pkg.hashCode();
    }

    @Override
    public String makeString() {
        return this.name;
    }

    @Override
    public String makeStringHtml() {
        if (this.name.isEmpty()) {
            return PACKAGE_DEFAULT_HTML_STR;
        }
        return this.name;
    }

    @Override
    public boolean disableHtml() {
        return !this.name.isEmpty();
    }

    @Override
    public String makeLongString() {
        return this.pkg.getFullName();
    }

    @Override
    public String toString() {
        return this.name;
    }
}

