/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.ICodeInfo;
import jadx.api.impl.SimpleCodeInfo;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.utils.files.FileUtils;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JEditableNode;
import jadx.gui.treemodel.JInputFile;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.CodeContentPanel;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.ui.tab.TabbedPane;
import jadx.gui.utils.Icons;
import java.nio.file.Path;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JInputSmaliFile
extends JEditableNode {
    private static final Logger LOG = LoggerFactory.getLogger(JInputSmaliFile.class);
    private final Path filePath;

    public JInputSmaliFile(Path filePath) {
        this.filePath = Objects.requireNonNull(filePath);
    }

    @Override
    public JPopupMenu onTreePopupMenu(MainWindow mainWindow) {
        return JInputFile.buildInputFilePopupMenu(mainWindow, this.filePath);
    }

    @Override
    public boolean hasContent() {
        return true;
    }

    @Override
    @Nullable
    public ContentPanel getContentPanel(TabbedPane tabbedPane) {
        return new CodeContentPanel(tabbedPane, this);
    }

    @Override
    public String getSyntaxName() {
        return "text/smali";
    }

    @Override
    public ICodeInfo getCodeInfo() {
        try {
            return new SimpleCodeInfo(FileUtils.readFile((Path)this.filePath));
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to read file: " + String.valueOf(this.filePath.toAbsolutePath()), (Throwable)e);
        }
    }

    @Override
    public void save(String newContent) {
        try {
            FileUtils.writeFile((Path)this.filePath, (String)newContent);
            LOG.debug("File saved: {}", (Object)this.filePath.toAbsolutePath());
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to write file: " + String.valueOf(this.filePath.toAbsolutePath()), (Throwable)e);
        }
    }

    @Override
    public JClass getJParent() {
        return null;
    }

    public Icon getIcon() {
        return Icons.FILE;
    }

    @Override
    public String makeString() {
        return this.filePath.getFileName().toString();
    }

    @Override
    public String getTooltip() {
        return this.filePath.normalize().toAbsolutePath().toString();
    }

    public int hashCode() {
        return this.filePath.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return ((JInputSmaliFile)o).filePath.equals(this.filePath);
    }
}

