/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.settings.ui.font;

import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.ui.font.FontChooserHack;
import jadx.gui.utils.FontUtils;
import jadx.gui.utils.NLS;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.drjekyll.fontchooser.FontChooser;
import org.jetbrains.annotations.Nullable;

public class JadxFontDialog
extends JDialog {
    private static final long serialVersionUID = 7609857698785777587L;
    private final FontChooser fontChooser = new FontChooser();
    private final JadxSettings settings;
    private boolean selected = false;

    public JadxFontDialog(Dialog parent, JadxSettings settings, String title) {
        super(parent, title, true);
        this.settings = settings;
        this.initComponents();
        this.setDefaultCloseOperation(2);
        if (!settings.loadWindowPos(this)) {
            this.pack();
        }
    }

    @Nullable
    public Font select(Font currentFont, boolean onlyMonospace) {
        this.fontChooser.setSelectedFont(currentFont);
        if (onlyMonospace) {
            FontChooserHack.setOnlyMonospace(this.fontChooser);
        }
        this.setVisible(true);
        Font selectedFont = this.fontChooser.getSelectedFont();
        if (this.selected && !selectedFont.equals(currentFont)) {
            return FontUtils.getCompositeFont(selectedFont.getFamily(), selectedFont.getStyle(), selectedFont.getSize());
        }
        return null;
    }

    private void initComponents() {
        JPanel chooserPanel = new JPanel();
        chooserPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        chooserPanel.setLayout(new BorderLayout(0, 10));
        chooserPanel.add((Component)this.fontChooser);
        JPanel controlPanel = new JPanel();
        controlPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        controlPanel.setLayout(new FlowLayout(4));
        JButton okBtn = new JButton();
        okBtn.setText(NLS.str("common_dialog.ok"));
        okBtn.setMnemonic('o');
        okBtn.addActionListener(event -> {
            this.selected = true;
            this.dispose();
        });
        JButton cancelBtn = new JButton();
        cancelBtn.setText(NLS.str("common_dialog.cancel"));
        cancelBtn.setMnemonic('c');
        cancelBtn.addActionListener(event -> this.dispose());
        controlPanel.add(okBtn);
        controlPanel.add(cancelBtn);
        this.add(chooserPanel);
        this.add((Component)controlPanel, "Last");
        this.getRootPane().setDefaultButton(okBtn);
    }

    @Override
    public void dispose() {
        this.settings.saveWindowPos(this);
        super.dispose();
    }
}

