/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.settings.font;

import jadx.core.utils.Utils;
import jadx.gui.utils.FontUtils;
import jadx.gui.utils.UiUtils;
import java.awt.Font;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(FontAdapter.class);
    private Font defaultFont;
    private Font font;
    private Font effectiveFont;
    private Consumer<String> fontSetter;
    private float uiZoom;

    public FontAdapter(Font defaultFont) {
        Objects.requireNonNull(defaultFont);
        this.defaultFont = defaultFont;
        this.font = defaultFont;
    }

    public void bindData(String fontStr, Consumer<String> fontStrSetter) {
        this.font = this.loadFromStr(fontStr);
        this.fontSetter = fontStrSetter;
    }

    public void setDefaultFont(Font newDefaultFont) {
        Objects.requireNonNull(newDefaultFont);
        Font prevDefaultFont = this.defaultFont;
        this.defaultFont = newDefaultFont;
        if (this.font == prevDefaultFont) {
            this.setFont(newDefaultFont);
        }
    }

    public Font getFont() {
        return this.font;
    }

    public Font getEffectiveFont() {
        return this.effectiveFont;
    }

    public void setFont(@Nullable Font newFont) {
        this.font = (Font)Utils.getOrElse((Object)newFont, (Object)this.defaultFont);
        this.fontSetter.accept(this.getFontStr());
        this.applyFontZoom();
    }

    public void setUiZoom(float uiZoom) {
        this.uiZoom = uiZoom;
        this.applyFontZoom();
    }

    private Font loadFromStr(String fontStr) {
        if (fontStr != null && !fontStr.isEmpty()) {
            try {
                return FontUtils.loadByStr(fontStr);
            }
            catch (Exception e) {
                LOG.warn("Failed to load font: {}, reset to default", (Object)fontStr, (Object)e);
            }
        }
        return this.defaultFont;
    }

    private String getFontStr() {
        if (this.font == this.defaultFont) {
            return "";
        }
        return FontUtils.convertToStr(this.font);
    }

    private void applyFontZoom() {
        this.effectiveFont = UiUtils.nearlyEqual(this.uiZoom, 1.0f) ? this.font : this.font.deriveFont(this.font.getSize2D() * this.uiZoom);
    }
}

