/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.settings;

import com.google.gson.Gson;
import jadx.api.JadxArgs;
import jadx.api.data.ICodeComment;
import jadx.api.data.ICodeData;
import jadx.api.data.ICodeRename;
import jadx.api.data.IJavaCodeRef;
import jadx.api.data.IJavaNodeRef;
import jadx.api.data.impl.JadxCodeComment;
import jadx.api.data.impl.JadxCodeData;
import jadx.api.data.impl.JadxCodeRef;
import jadx.api.data.impl.JadxCodeRename;
import jadx.api.data.impl.JadxNodeRef;
import jadx.api.plugins.utils.CommonFileUtils;
import jadx.core.utils.GsonUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.utils.files.FileUtils;
import jadx.gui.cache.manager.CacheManager;
import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.TabStateViewAdapter;
import jadx.gui.settings.data.ProjectData;
import jadx.gui.settings.data.SaveOptionEnum;
import jadx.gui.settings.data.TabViewState;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.EditorViewState;
import jadx.gui.utils.RelativePathTypeAdapter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxProject {
    private static final Logger LOG = LoggerFactory.getLogger(JadxProject.class);
    public static final String PROJECT_EXTENSION = "jadx";
    private static final int SEARCH_HISTORY_LIMIT = 30;
    private final transient MainWindow mainWindow;
    private final transient TabStateViewAdapter tabStateViewAdapter = new TabStateViewAdapter();
    private transient String name = "New Project";
    @Nullable
    private transient Path projectPath;
    private transient boolean initial = true;
    private transient boolean saved;
    private ProjectData data = new ProjectData();
    private Path cacheDir;

    public JadxProject(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }

    public void fillJadxArgs(JadxArgs jadxArgs) {
        jadxArgs.setInputFiles(FileUtils.toFiles(this.getFilePaths()));
        if (jadxArgs.getUserRenamesMappingsPath() == null) {
            jadxArgs.setUserRenamesMappingsPath(this.getMappingsPath());
        }
        jadxArgs.setCodeData((ICodeData)this.getCodeData());
        jadxArgs.getPluginOptions().putAll(this.data.getPluginOptions());
    }

    @Nullable
    public Path getWorkingDir() {
        if (this.projectPath != null) {
            return this.projectPath.toAbsolutePath().getParent();
        }
        List<Path> files = this.data.getFiles();
        if (!files.isEmpty()) {
            Path path = files.get(0);
            return path.toAbsolutePath().getParent();
        }
        return null;
    }

    @Nullable
    public Path getProjectPath() {
        return this.projectPath;
    }

    private void setProjectPath(@NotNull Path projectPath) {
        this.projectPath = projectPath;
        this.name = CommonFileUtils.removeFileExtension((String)projectPath.getFileName().toString());
        this.changed();
    }

    public List<Path> getFilePaths() {
        return this.data.getFiles();
    }

    public void setFilePaths(List<Path> files) {
        if (files.equals(this.getFilePaths())) {
            return;
        }
        if (files.isEmpty()) {
            this.data.setFiles(files);
            this.name = "";
        } else {
            Collections.sort(files);
            this.data.setFiles(files);
            StringJoiner joiner = new StringJoiner("_");
            for (Path p : files) {
                Path fileNamePart = p.getFileName();
                if (fileNamePart == null) {
                    joiner.add(p.toString());
                    continue;
                }
                String fileName = fileNamePart.toString();
                if (fileName.endsWith(".jadx.kts")) continue;
                joiner.add(CommonFileUtils.removeFileExtension((String)fileName));
            }
            String joinedName = joiner.toString();
            this.name = StringUtils.abbreviate((String)joinedName, (int)100);
        }
        this.changed();
    }

    public void setTreeExpansions(List<String> list) {
        if (list.equals(this.data.getTreeExpansionsV2())) {
            return;
        }
        this.data.setTreeExpansionsV2(list);
        this.changed();
    }

    public List<String> getTreeExpansions() {
        return this.data.getTreeExpansionsV2();
    }

    public JadxCodeData getCodeData() {
        return this.data.getCodeData();
    }

    public void setCodeData(JadxCodeData codeData) {
        this.data.setCodeData(codeData);
        this.changed();
    }

    public void saveOpenTabs(List<EditorViewState> tabs) {
        List<TabViewState> tabStateList = tabs.stream().map(this.tabStateViewAdapter::build).filter(Objects::nonNull).collect(Collectors.toList());
        if (this.data.setOpenTabs(tabStateList)) {
            this.changed();
        }
    }

    public List<EditorViewState> getOpenTabs(MainWindow mw) {
        this.tabStateViewAdapter.setCustomAdapters(mw.getWrapper().getGuiPluginsContext().getTabStatePersistAdapters());
        return this.data.getOpenTabs().stream().map(s -> this.tabStateViewAdapter.load(mw, (TabViewState)s)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Path getMappingsPath() {
        return this.data.getMappingsPath();
    }

    public void setMappingsPath(Path mappingsPath) {
        this.data.setMappingsPath(mappingsPath);
        this.changed();
    }

    public void updatePluginOptions(Consumer<Map<String, String>> update) {
        update.accept(this.data.getPluginOptions());
        this.changed();
    }

    @Nullable
    public String getPluginOption(String key) {
        return this.data.getPluginOptions().get(key);
    }

    public Path getCacheDir() {
        if (this.cacheDir == null) {
            this.cacheDir = this.resolveCachePath(this.data.getCacheDir());
        }
        return this.cacheDir;
    }

    public void resetCacheDir() {
        this.cacheDir = this.resolveCachePath(null);
    }

    private Path resolveCachePath(@Nullable String cacheDirStr) {
        Path newCacheDir;
        CacheManager cacheManager = this.mainWindow.getCacheManager();
        String newCacheStr = cacheManager.buildCacheDirStr(newCacheDir = cacheManager.getCacheDir(this, cacheDirStr));
        if (!newCacheStr.equals(cacheDirStr)) {
            this.data.setCacheDir(newCacheStr);
            this.changed();
        }
        return newCacheDir;
    }

    public boolean isEnableLiveReload() {
        return this.data.isEnableLiveReload();
    }

    public void setEnableLiveReload(boolean newValue) {
        if (newValue != this.data.isEnableLiveReload()) {
            this.data.setEnableLiveReload(newValue);
            this.changed();
        }
    }

    public List<String> getSearchHistory() {
        return this.data.getSearchHistory();
    }

    public void addToSearchHistory(String str) {
        if (str == null || str.isEmpty()) {
            return;
        }
        List<String> list = this.data.getSearchHistory();
        if (!list.isEmpty() && list.get(0).equals(str)) {
            return;
        }
        list.remove(str);
        list.add(0, str);
        if (list.size() > 30) {
            list.remove(list.size() - 1);
        }
        this.data.setSearchHistory(list);
        this.changed();
    }

    public void setSearchResourcesFilter(String searchResourcesFilter) {
        this.data.setSearchResourcesFilter(searchResourcesFilter);
    }

    public String getSearchResourcesFilter() {
        return this.data.getSearchResourcesFilter();
    }

    public void setSearchResourcesSizeLimit(int searchResourcesSizeLimit) {
        this.data.setSearchResourcesSizeLimit(searchResourcesSizeLimit);
    }

    public int getSearchResourcesSizeLimit() {
        return this.data.getSearchResourcesSizeLimit();
    }

    private void changed() {
        JadxSettings settings = this.mainWindow.getSettings();
        if (settings != null && settings.getSaveOption() == SaveOptionEnum.ALWAYS) {
            this.save();
        } else {
            this.saved = false;
        }
        this.initial = false;
        this.mainWindow.updateProject(this);
    }

    public String getName() {
        return this.name;
    }

    public boolean isSaveFileSelected() {
        return this.projectPath != null;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public boolean isInitial() {
        return this.initial;
    }

    public void saveAs(Path path) {
        this.mainWindow.getCacheManager().projectPathUpdate(this, path);
        this.setProjectPath(path);
        this.save();
    }

    public void save() {
        Path savePath = this.getProjectPath();
        if (savePath != null) {
            Path basePath = savePath.toAbsolutePath().getParent();
            try (BufferedWriter writer = Files.newBufferedWriter(savePath, StandardCharsets.UTF_8, new OpenOption[0]);){
                JadxProject.buildGson(basePath).toJson((Object)this.data, (Appendable)writer);
                this.saved = true;
            }
            catch (Exception e) {
                throw new RuntimeException("Error saving project", e);
            }
        }
    }

    public static JadxProject load(MainWindow mainWindow, Path path) {
        try {
            JadxProject project = new JadxProject(mainWindow);
            project.data = JadxProject.loadProjectData(path);
            project.saved = true;
            project.setProjectPath(path);
            return project;
        }
        catch (Exception e) {
            LOG.error("Error loading project", (Throwable)e);
            return null;
        }
    }

    public static ProjectData loadProjectData(Path path) {
        ProjectData projectData;
        block8: {
            Path basePath = path.toAbsolutePath().getParent();
            BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);
            try {
                projectData = (ProjectData)JadxProject.buildGson(basePath).fromJson((Reader)reader, ProjectData.class);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new JadxRuntimeException("Failed to load project file: " + String.valueOf(path), (Throwable)e);
                }
            }
            ((Reader)reader).close();
        }
        return projectData;
    }

    private static Gson buildGson(Path basePath) {
        return GsonUtils.defaultGsonBuilder().registerTypeHierarchyAdapter(Path.class, (Object)new RelativePathTypeAdapter(basePath)).registerTypeAdapter(ICodeComment.class, (Object)GsonUtils.interfaceReplace(JadxCodeComment.class)).registerTypeAdapter(ICodeRename.class, (Object)GsonUtils.interfaceReplace(JadxCodeRename.class)).registerTypeAdapter(IJavaNodeRef.class, (Object)GsonUtils.interfaceReplace(JadxNodeRef.class)).registerTypeAdapter(IJavaCodeRef.class, (Object)GsonUtils.interfaceReplace(JadxCodeRef.class)).create();
    }
}

