/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.report;

import jadx.gui.report.ExceptionData;
import jadx.gui.report.ExceptionDialog;
import jadx.gui.ui.MainWindow;
import jadx.plugins.tools.JadxPluginsTools;
import jadx.plugins.tools.data.JadxPluginMetadata;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(JadxExceptionHandler.class);
    public static final String MAIN_PROJECT_STRING = "skylot/jadx";
    private final MainWindow mainWindow;

    public static void register(MainWindow mainWindow) {
        Thread.setDefaultUncaughtExceptionHandler(new JadxExceptionHandler(mainWindow));
    }

    private JadxExceptionHandler(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        LOG.error("Exception was thrown", ex);
        new ExceptionDialog(this.mainWindow, this.buildExceptionData(ex));
    }

    private ExceptionData buildExceptionData(Throwable ex) {
        for (StackTraceElement stackTraceElement : ex.getStackTrace()) {
            String classLoaderName = stackTraceElement.getClassLoaderName();
            if (classLoaderName == null || !classLoaderName.startsWith("jadx-plugin:")) continue;
            String jarName = classLoaderName.substring("jadx-plugin:".length());
            String pluginProject = this.resolvePluginByJarName(jarName);
            LOG.debug("Report exception in plugin: {}", (Object)pluginProject);
            return new ExceptionData(ex, pluginProject);
        }
        return new ExceptionData(ex, MAIN_PROJECT_STRING);
    }

    private String resolvePluginByJarName(String jarName) {
        for (JadxPluginMetadata jadxPluginMetadata : JadxPluginsTools.getInstance().getInstalled()) {
            if (!jadxPluginMetadata.getJar().equals(jarName)) continue;
            String githubProject = JadxExceptionHandler.getGithubProject(jadxPluginMetadata.getLocationId());
            return githubProject != null ? githubProject : "";
        }
        return "";
    }

    @Nullable
    private static String getGithubProject(String locationId) {
        if (locationId.startsWith("github:")) {
            return locationId.substring("github:".length()).replace(':', '/');
        }
        return null;
    }
}

