/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.jobs;

import jadx.api.utils.tasks.ITaskExecutor;
import jadx.gui.jobs.IBackgroundTask;
import jadx.gui.jobs.ITaskInfo;
import jadx.gui.jobs.ITaskProgress;
import jadx.gui.jobs.TaskStatus;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class TaskWithExtraOnFinish
implements IBackgroundTask {
    private final IBackgroundTask task;
    private final Consumer<TaskStatus> extraOnFinish;

    public TaskWithExtraOnFinish(IBackgroundTask task, Runnable extraOnFinish) {
        this(task, (TaskStatus s) -> extraOnFinish.run());
    }

    public TaskWithExtraOnFinish(IBackgroundTask task, Consumer<TaskStatus> extraOnFinish) {
        this.task = Objects.requireNonNull(task);
        this.extraOnFinish = Objects.requireNonNull(extraOnFinish);
    }

    @Override
    public void onFinish(ITaskInfo taskInfo) {
        this.task.onFinish(taskInfo);
        this.extraOnFinish.accept(taskInfo.getStatus());
    }

    @Override
    public String getTitle() {
        return this.task.getTitle();
    }

    @Override
    public ITaskExecutor scheduleTasks() {
        return this.task.scheduleTasks();
    }

    @Override
    public void onDone(ITaskInfo taskInfo) {
        this.task.onDone(taskInfo);
    }

    @Override
    @Nullable
    public Consumer<ITaskProgress> getProgressListener() {
        return this.task.getProgressListener();
    }

    @Override
    @Nullable
    public ITaskProgress getTaskProgress() {
        return this.task.getTaskProgress();
    }

    @Override
    public boolean canBeCanceled() {
        return this.task.canBeCanceled();
    }

    @Override
    public boolean isCanceled() {
        return this.task.isCanceled();
    }

    @Override
    public void cancel() {
        this.task.cancel();
    }

    @Override
    public int timeLimit() {
        return this.task.timeLimit();
    }

    @Override
    public boolean checkMemoryUsage() {
        return this.task.checkMemoryUsage();
    }

    @Override
    public int getCancelTimeoutMS() {
        return this.task.getCancelTimeoutMS();
    }

    @Override
    public int getShutdownTimeoutMS() {
        return this.task.getShutdownTimeoutMS();
    }
}

