/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.jobs;

import jadx.core.utils.Utils;
import jadx.gui.jobs.IBackgroundTask;
import jadx.gui.jobs.ITaskProgress;
import jadx.gui.jobs.InternalTask;
import jadx.gui.jobs.TaskProgress;
import jadx.gui.jobs.TaskStatus;
import jadx.gui.ui.panel.ProgressPanel;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(ProgressUpdater.class);
    private static final int UPDATE_INTERVAL_MS = 1000;
    private final ProgressPanel progressPane;
    private final Consumer<InternalTask> cancelCallback;
    private final ExecutorService bgExecutor = Executors.newSingleThreadExecutor(Utils.simpleThreadFactory((String)"jadx-progress"));
    private final BlockingQueue<InternalTask> tasks = new DelayQueue<InternalTask>();

    public ProgressUpdater(ProgressPanel progressPane, Consumer<InternalTask> cancelCallback) {
        this.progressPane = progressPane;
        this.cancelCallback = cancelCallback;
        this.bgExecutor.execute(this::updateLoop);
    }

    public void addTask(InternalTask task) {
        if (task.getBgTask().isSilent()) {
            return;
        }
        this.scheduleNextUpdate(task);
    }

    public void taskComplete(InternalTask task) {
        task.setNextUpdate(0L);
        this.updateProgress(task);
    }

    private void scheduleNextUpdate(InternalTask task) {
        task.setNextUpdate(System.currentTimeMillis() + 1000L);
        this.tasks.add(task);
    }

    private void updateLoop() {
        while (true) {
            try {
                while (true) {
                    InternalTask task;
                    if (!(task = this.tasks.take()).isRunning()) {
                        continue;
                    }
                    this.updateProgress(task);
                    this.cancelCheck(task);
                    this.scheduleNextUpdate(task);
                }
            }
            catch (Exception e) {
                LOG.warn("Error in ProgressUpdater loop", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void updateProgress(InternalTask internalTask) {
        UiUtils.uiRun(() -> {
            IBackgroundTask bgTask = internalTask.getBgTask();
            if (internalTask.isRunning()) {
                ITaskProgress taskProgress;
                if (internalTask.checkForFirstUpdate()) {
                    this.progressPane.setLabel(bgTask.getTitle() + "\u2026 ");
                    this.progressPane.setCancelButtonVisible(bgTask.canBeCanceled());
                    this.progressPane.setVisible(true);
                }
                if ((taskProgress = bgTask.getTaskProgress()) == null) {
                    int progress = internalTask.getTaskExecutor().getProgress();
                    taskProgress = new TaskProgress((long)progress, internalTask.getJobsCount());
                }
                this.progressPane.setProgress(taskProgress);
                Consumer<ITaskProgress> onProgressListener = bgTask.getProgressListener();
                if (onProgressListener != null) {
                    onProgressListener.accept(taskProgress);
                }
            } else {
                this.progressPane.reset();
                this.progressPane.setVisible(false);
            }
        });
    }

    private void cancelCheck(InternalTask task) {
        TaskStatus taskStatus = task.getCancelCheck().get();
        if (taskStatus == null) {
            return;
        }
        task.setStatus(taskStatus);
        UiUtils.uiRun(() -> {
            IBackgroundTask bgTask = task.getBgTask();
            this.progressPane.setLabel(bgTask.getTitle() + " (" + NLS.str("progress.canceling") + ")\u2026 ");
            this.progressPane.setCancelButtonVisible(false);
            this.progressPane.setIndeterminate(true);
        });
        this.cancelCallback.accept(task);
    }
}

