/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.device.protocol;

import jadx.core.utils.log.LogUtils;
import jadx.gui.device.protocol.ADBDevice;
import jadx.gui.device.protocol.ADBDeviceInfo;
import jadx.gui.utils.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ADB {
    private static final Logger LOG = LoggerFactory.getLogger(ADB.class);
    private static final int DEFAULT_PORT = 5037;
    private static final String DEFAULT_ADDR = "localhost";
    private static final String CMD_FEATURES = "000dhost:features";
    private static final String CMD_TRACK_DEVICES = "0014host:track-devices-l";
    private static final byte[] OKAY = "OKAY".getBytes();
    private static final byte[] FAIL = "FAIL".getBytes();

    static boolean isOkay(InputStream stream) throws IOException {
        byte[] buf = IOUtils.readNBytes(stream, 4);
        if (Arrays.equals(buf, OKAY)) {
            return true;
        }
        if (Arrays.equals(buf, FAIL)) {
            LOG.error("isOkay failed");
            return false;
        }
        if (buf == null) {
            throw new IOException("isOkay failed - steam ended");
        }
        throw new IOException("isOkay failed - unexpected response " + new String(buf));
    }

    public static byte[] exec(String cmd, OutputStream outputStream, InputStream inputStream) throws IOException {
        return ADB.execCommandSync(outputStream, inputStream, cmd);
    }

    public static byte[] exec(String cmd) throws IOException {
        try (Socket socket = ADB.connect();){
            byte[] byArray = ADB.exec(cmd, socket.getOutputStream(), socket.getInputStream());
            return byArray;
        }
    }

    public static Socket connect() throws IOException {
        return ADB.connect(DEFAULT_ADDR, 5037);
    }

    public static Socket connect(String host, int port) throws IOException {
        return new Socket(host, port);
    }

    static boolean execCommandAsync(OutputStream outputStream, InputStream inputStream, String cmd) throws IOException {
        outputStream.write(cmd.getBytes());
        return ADB.isOkay(inputStream);
    }

    private static byte[] execCommandSync(OutputStream outputStream, InputStream inputStream, String cmd) throws IOException {
        outputStream.write(cmd.getBytes());
        if (ADB.isOkay(inputStream)) {
            return ADB.readServiceProtocol(inputStream);
        }
        return null;
    }

    static byte[] readServiceProtocol(InputStream stream) {
        try {
            byte[] buf = IOUtils.readNBytes(stream, 4);
            if (buf == null) {
                return null;
            }
            int len = ADB.unhex(buf);
            byte[] result = len == 0 ? new byte[]{} : IOUtils.readNBytes(stream, len);
            if (LOG.isTraceEnabled()) {
                LOG.trace("readServiceProtocol result: {}", (Object)LogUtils.escape((byte[])result));
            }
            return result;
        }
        catch (SocketException e) {
            LOG.warn("Aborting readServiceProtocol: {}", (Object)e.toString());
        }
        catch (IOException e) {
            LOG.error("Failed to read readServiceProtocol", (Throwable)e);
        }
        return null;
    }

    static boolean setSerial(String serial, OutputStream outputStream, InputStream inputStream) throws IOException {
        String setSerialCmd = String.format("host:tport:serial:%s", serial);
        setSerialCmd = String.format("%04x%s", setSerialCmd.length(), setSerialCmd);
        outputStream.write(setSerialCmd.getBytes());
        boolean ok = ADB.isOkay(inputStream);
        if (ok) {
            IOUtils.readNBytes(inputStream, 8);
        } else {
            LOG.error("setSerial command {} failed", (Object)LogUtils.escape((String)setSerialCmd));
        }
        return ok;
    }

    private static byte[] execShellCommandRaw(String cmd, OutputStream outputStream, InputStream inputStream) throws IOException {
        cmd = String.format("shell,v2,TERM=xterm-256color,raw:%s", cmd);
        cmd = String.format("%04x%s", cmd.length(), cmd);
        outputStream.write(cmd.getBytes());
        if (ADB.isOkay(inputStream)) {
            return ShellProtocol.readStdout(inputStream);
        }
        return null;
    }

    static byte[] execShellCommandRaw(String serial, String cmd, OutputStream outputStream, InputStream inputStream) throws IOException {
        if (ADB.setSerial(serial, outputStream, inputStream)) {
            return ADB.execShellCommandRaw(cmd, outputStream, inputStream);
        }
        return null;
    }

    public static List<String> getFeatures() throws IOException {
        byte[] rst = ADB.exec(CMD_FEATURES);
        if (rst != null) {
            return Arrays.asList(new String(rst).trim().split(","));
        }
        return Collections.emptyList();
    }

    public static boolean startServer(String adbPath, int port) throws IOException {
        String tcpPort = String.format("tcp:%d", port);
        List<String> command = Arrays.asList(adbPath, "-L", tcpPort, "start-server");
        java.lang.Process proc = new ProcessBuilder(command).redirectErrorStream(true).start();
        try {
            proc.waitFor(10L, TimeUnit.SECONDS);
            proc.exitValue();
        }
        catch (Exception e) {
            LOG.error("ADB start server failed with command: {}", (Object)String.join((CharSequence)" ", command), (Object)e);
            proc.destroyForcibly();
            return false;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (InputStream in = proc.getInputStream();){
            int read;
            byte[] buf = new byte[1024];
            while ((read = in.read(buf)) >= 0) {
                out.write(buf, 0, read);
            }
        }
        return out.toString().contains(tcpPort);
    }

    public static boolean isServerRunning(String host, int port) {
        boolean bl;
        Socket sock = new Socket(host, port);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    sock.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        sock.close();
        return bl;
    }

    public static Socket listenForDeviceState(DeviceStateListener listener, String host, int port) throws IOException {
        Socket socket = ADB.connect(host, port);
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        if (!ADB.execCommandAsync(outputStream, inputStream, CMD_TRACK_DEVICES)) {
            socket.close();
            return null;
        }
        ExecutorService listenThread = Executors.newFixedThreadPool(1);
        listenThread.execute(() -> {
            byte[] res;
            while ((res = ADB.readServiceProtocol(inputStream)) != null) {
                if (listener == null) continue;
                String payload = new String(res);
                String[] deviceLines = payload.split("\n");
                ArrayList<ADBDeviceInfo> deviceInfoList = new ArrayList<ADBDeviceInfo>(deviceLines.length);
                for (String deviceLine : deviceLines) {
                    if (deviceLine.trim().isEmpty()) continue;
                    deviceInfoList.add(new ADBDeviceInfo(deviceLine, host, port));
                }
                listener.onDeviceStatusChange(deviceInfoList);
            }
            if (listener != null) {
                listener.adbDisconnected();
            }
        });
        return socket;
    }

    public static List<String> listForward(String host, int port) throws IOException {
        try (Socket socket = ADB.connect(host, port);){
            byte[] bytes;
            String cmd = "0011host:list-forward";
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(cmd.getBytes());
            if (ADB.isOkay(inputStream) && (bytes = ADB.readServiceProtocol(inputStream)) != null) {
                String[] forwards = new String(bytes).split("\n");
                List<String> list = Stream.of(forwards).map(String::trim).collect(Collectors.toList());
                return list;
            }
        }
        return Collections.emptyList();
    }

    public static boolean removeForward(String host, int port, String serial, String localPort) throws IOException {
        try (Socket socket = ADB.connect(host, port);){
            String cmd = String.format("host:killforward:tcp:%s", localPort);
            cmd = String.format("%04x%s", cmd.length(), cmd);
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            if (ADB.setSerial(serial, outputStream, inputStream)) {
                outputStream.write(cmd.getBytes());
                boolean bl = ADB.isOkay(inputStream) && ADB.isOkay(inputStream);
                return bl;
            }
        }
        return false;
    }

    private static int readInt(byte[] bytes, int start) {
        int result = bytes[start] & 0xFF;
        result += (bytes[start + 1] & 0xFF) << 8;
        result += (bytes[start + 2] & 0xFF) << 16;
        return result += (bytes[start + 3] & 0xFF) << 24;
    }

    private static byte[] appendBytes(byte[] dest, byte[] src, int realSrcSize) {
        byte[] rst = new byte[dest.length + realSrcSize];
        System.arraycopy(dest, 0, rst, 0, dest.length);
        System.arraycopy(src, 0, rst, dest.length, realSrcSize);
        return rst;
    }

    private static int unhex(byte[] hex) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            byte b = hex[i];
            switch (b) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    b = (byte)(b - 48);
                    break;
                }
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    b = (byte)(b - 97 + 10);
                    break;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    b = (byte)(b - 65 + 10);
                    break;
                }
                default: {
                    return -1;
                }
            }
            n = n << 4 | b & 0xFF;
        }
        return n;
    }

    private static class ShellProtocol {
        private static final int ID_STD_IN = 0;
        private static final int ID_STD_OUT = 1;
        private static final int ID_STD_ERR = 2;
        private static final int ID_EXIT = 3;
        private static final int ID_CLOSE_STDIN = 4;
        private static final int ID_WINDOW_SIZE_CHANGE = 5;
        private static final int ID_INVALID = 255;

        private ShellProtocol() {
        }

        public static byte[] readStdout(InputStream inputStream) throws IOException {
            byte[] header = new byte[5];
            ByteArrayOutputStream payload = new ByteArrayOutputStream();
            byte[] tempBuf = new byte[1024];
            boolean exit = false;
            while (!exit) {
                int readSize;
                IOUtils.read(inputStream, header);
                exit = header[0] == 3;
                int payloadSize = ADB.readInt(header, 1);
                if (tempBuf.length < payloadSize) {
                    tempBuf = new byte[payloadSize];
                }
                if ((readSize = IOUtils.read(inputStream, tempBuf, 0, payloadSize)) != payloadSize) {
                    LOG.error("Failed to read ShellProtocol data");
                    return null;
                }
                payload.write(tempBuf, 0, readSize);
            }
            return payload.toByteArray();
        }
    }

    public static class Process {
        public String user;
        public String pid;
        public String ppid;
        public String name;

        public static Process make(String processLine) {
            String[] fields = processLine.split("\\s+");
            if (fields.length >= 4) {
                Process proc = new Process();
                proc.user = fields[0];
                proc.pid = fields[1];
                proc.ppid = fields[2];
                proc.name = fields[fields.length - 1];
                return proc;
            }
            return null;
        }
    }

    public static interface DeviceStateListener {
        public void onDeviceStatusChange(List<ADBDeviceInfo> var1);

        public void adbDisconnected();
    }

    public static interface JDWPProcessListener {
        public void jdwpProcessOccurred(ADBDevice var1, Set<String> var2);

        public void jdwpListenerClosed(ADBDevice var1);
    }
}

