/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.device.debugger;

import jadx.core.utils.StringUtils;
import jadx.gui.device.protocol.ADB;
import jadx.gui.device.protocol.ADBDevice;
import jadx.gui.utils.NLS;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugSettings {
    private static final Logger LOG = LoggerFactory.getLogger(DebugSettings.class);
    private static final int FORWARD_TCP_PORT = 33233;
    public static final DebugSettings INSTANCE = new DebugSettings();
    private int ver;
    private String pid;
    private String name;
    private ADBDevice device;
    private int forwardTcpPort = 33233;
    private String expectPkg = "";
    private boolean autoAttachPkg = false;

    private DebugSettings() {
    }

    public void set(ADBDevice device, int ver, String pid, String name) {
        this.ver = ver;
        this.pid = pid;
        this.name = name;
        this.device = device;
        this.autoAttachPkg = false;
        this.expectPkg = "";
    }

    public DebugSettings setPid(String pid) {
        this.pid = pid;
        return this;
    }

    public DebugSettings setName(String name) {
        this.name = name;
        return this;
    }

    public String forwardJDWP() {
        int localPort = this.forwardTcpPort;
        String resultDesc = "";
        try {
            ADBDevice.ForwardResult rst;
            while (true) {
                rst = this.device.forwardJDWP("" + localPort, this.pid);
                if (rst.state == 0) {
                    this.forwardTcpPort = localPort;
                    return "";
                }
                if (rst.state != 1 || !rst.desc.contains("Only one usage of each socket address") || localPort >= 65536) break;
                ++localPort;
            }
            resultDesc = rst.desc;
        }
        catch (Exception e) {
            LOG.error("JDWP forward error", (Throwable)e);
        }
        if (StringUtils.isEmpty((String)resultDesc)) {
            resultDesc = NLS.str("adb_dialog.forward_fail");
        }
        return resultDesc;
    }

    public void clearForward() {
        String jdwpPid = " jdwp:" + this.pid;
        String tcpPort = " tcp:" + this.forwardTcpPort;
        try {
            List<String> list = ADB.listForward(this.device.getDeviceInfo().getAdbHost(), this.device.getDeviceInfo().getAdbPort());
            for (String s : list) {
                String[] fields;
                if (!s.startsWith(this.device.getSerial()) || !s.endsWith(jdwpPid) || s.contains(tcpPort)) continue;
                for (String field : fields = s.split("\\s+")) {
                    if (!field.startsWith("tcp:")) continue;
                    try {
                        this.device.removeForward(field.substring("tcp:".length()));
                    }
                    catch (Exception e) {
                        LOG.error("JDWP remove forward error", (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error("JDWP clear forward error", (Throwable)e);
        }
    }

    public boolean isBeingDebugged() {
        String jdwpPid = " jdwp:" + this.pid;
        String tcpPort = " tcp:" + this.forwardTcpPort;
        try {
            List<String> list = ADB.listForward(this.device.getDeviceInfo().getAdbHost(), this.device.getDeviceInfo().getAdbPort());
            for (String s : list) {
                if (!s.startsWith(this.device.getSerial()) || !s.endsWith(jdwpPid)) continue;
                return !s.contains(tcpPort);
            }
        }
        catch (Exception e) {
            LOG.error("ADB list forward error", (Throwable)e);
        }
        return false;
    }

    public int getVer() {
        return this.ver;
    }

    public String getPid() {
        return this.pid;
    }

    public String getName() {
        return this.name;
    }

    public ADBDevice getDevice() {
        return this.device;
    }

    public int getForwardTcpPort() {
        return this.forwardTcpPort;
    }

    public String getExpectPkg() {
        return this.expectPkg;
    }

    public void setExpectPkg(String expectPkg) {
        this.expectPkg = expectPkg;
    }

    public boolean isAutoAttachPkg() {
        return this.autoAttachPkg;
    }

    public void setAutoAttachPkg(boolean autoAttachPkg) {
        this.autoAttachPkg = autoAttachPkg;
    }
}

