/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.cache.usage;

import jadx.api.usage.IUsageInfoCache;
import jadx.api.usage.IUsageInfoData;
import jadx.api.usage.impl.InMemoryUsageInfoCache;
import jadx.core.dex.nodes.RootNode;
import jadx.gui.cache.usage.RawUsageData;
import jadx.gui.cache.usage.UsageData;
import jadx.gui.cache.usage.UsageFileAdapter;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UsageInfoCache
implements IUsageInfoCache {
    private static final Object LOAD_DATA_SYNC = new Object();
    private final Path usageFile;
    private final List<File> inputs;
    private final InMemoryUsageInfoCache memCache = new InMemoryUsageInfoCache();
    @Nullable
    private RawUsageData rawUsageData;

    public UsageInfoCache(Path cacheDir, List<File> inputFiles) {
        this.usageFile = cacheDir.resolve("usage");
        this.inputs = inputFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IUsageInfoData get(RootNode root) {
        IUsageInfoData memData = this.memCache.get(root);
        if (memData != null) {
            return memData;
        }
        Object object = LOAD_DATA_SYNC;
        synchronized (object) {
            if (this.rawUsageData == null) {
                this.rawUsageData = UsageFileAdapter.load(this.usageFile, this.inputs);
            }
            if (this.rawUsageData != null) {
                UsageData data = new UsageData(root, this.rawUsageData);
                this.memCache.set(root, (IUsageInfoData)data);
                return data;
            }
        }
        return null;
    }

    public void set(RootNode root, IUsageInfoData data) {
        this.memCache.set(root, data);
        UsageFileAdapter.save(data, this.usageFile, this.inputs);
    }

    public void close() {
        this.rawUsageData = null;
        this.memCache.close();
    }
}

