/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui;

import jadx.api.ICodeCache;
import jadx.api.ICodeInfo;
import jadx.api.JadxArgs;
import jadx.api.JadxDecompiler;
import jadx.api.JavaClass;
import jadx.api.JavaNode;
import jadx.api.JavaPackage;
import jadx.api.ResourceFile;
import jadx.api.impl.InMemoryCodeCache;
import jadx.api.metadata.ICodeNodeRef;
import jadx.api.plugins.events.IJadxEvents;
import jadx.api.plugins.gui.JadxGuiContext;
import jadx.api.plugins.loader.JadxPluginLoader;
import jadx.api.plugins.pass.JadxPass;
import jadx.api.plugins.pass.JadxPassInfo;
import jadx.api.plugins.pass.impl.SimpleJadxPassInfo;
import jadx.api.plugins.pass.types.JadxPreparePass;
import jadx.api.usage.IUsageInfoCache;
import jadx.api.usage.impl.EmptyUsageInfoCache;
import jadx.api.usage.impl.InMemoryUsageInfoCache;
import jadx.cli.JadxAppCommon;
import jadx.cli.plugins.JadxFilesGetter;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.ProcessState;
import jadx.core.dex.nodes.RootNode;
import jadx.core.plugins.AppContext;
import jadx.core.plugins.PluginContext;
import jadx.core.plugins.files.IJadxFilesGetter;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.cache.code.CodeCacheMode;
import jadx.gui.cache.code.CodeStringCache;
import jadx.gui.cache.code.disk.BufferCodeCache;
import jadx.gui.cache.code.disk.DiskCodeCache;
import jadx.gui.cache.usage.UsageInfoCache;
import jadx.gui.plugins.context.CommonGuiPluginsContext;
import jadx.gui.settings.JadxProject;
import jadx.gui.settings.JadxSettings;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.CacheObject;
import jadx.plugins.tools.JadxExternalPluginsLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(JadxWrapper.class);
    private static final Object DECOMPILER_UPDATE_SYNC = new Object();
    private final MainWindow mainWindow;
    @Nullable
    private volatile JadxDecompiler decompiler;
    private CommonGuiPluginsContext guiPluginsContext;

    public JadxWrapper(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        this.close();
        try {
            Object object = DECOMPILER_UPDATE_SYNC;
            synchronized (object) {
                JadxProject project = this.getProject();
                JadxArgs jadxArgs = this.getSettings().toJadxArgs();
                jadxArgs.setPluginLoader((JadxPluginLoader)new JadxExternalPluginsLoader());
                jadxArgs.setFilesGetter((IJadxFilesGetter)JadxFilesGetter.INSTANCE);
                project.fillJadxArgs(jadxArgs);
                JadxAppCommon.applyEnvVars((JadxArgs)jadxArgs);
                this.decompiler = new JadxDecompiler(jadxArgs);
                this.guiPluginsContext = JadxWrapper.initGuiPluginsContext(this.decompiler, this.mainWindow);
                this.initUsageCache(jadxArgs);
                this.registerCodeCache(this.decompiler);
                this.decompiler.setEventsImpl((IJadxEvents)this.mainWindow.events());
                this.decompiler.load();
            }
        }
        catch (Exception e) {
            LOG.error("Jadx decompiler wrapper init error", (Throwable)e);
            this.close();
        }
    }

    public void unloadClasses() {
        this.getCurrentDecompiler().ifPresent(decompiler -> {
            for (ClassNode cls : decompiler.getRoot().getClasses()) {
                ProcessState clsState = cls.getState();
                cls.unload();
                cls.setState(clsState == ProcessState.PROCESS_COMPLETE ? ProcessState.GENERATED_AND_UNLOADED : ProcessState.NOT_LOADED);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            Object object = DECOMPILER_UPDATE_SYNC;
            synchronized (object) {
                if (this.decompiler != null) {
                    this.decompiler.close();
                    this.decompiler = null;
                }
                if (this.guiPluginsContext != null) {
                    this.resetGuiPluginsContext();
                    this.guiPluginsContext = null;
                }
            }
        }
        catch (Exception e) {
            LOG.error("Jadx decompiler close error", (Throwable)e);
        }
        finally {
            this.mainWindow.getCacheObject().reset();
        }
    }

    private void registerCodeCache(JadxDecompiler jadxDecompiler) {
        CodeCacheMode codeCacheMode = this.getSettings().getCodeCacheMode();
        if (codeCacheMode == CodeCacheMode.MEMORY) {
            jadxDecompiler.getArgs().setCodeCache((ICodeCache)new InMemoryCodeCache());
            return;
        }
        jadxDecompiler.addCustomPass((JadxPass)new JadxPreparePass(){

            public JadxPassInfo getInfo() {
                return new SimpleJadxPassInfo("CacheInit");
            }

            public void init(RootNode root) {
                switch (JadxWrapper.this.getSettings().getCodeCacheMode()) {
                    case DISK_WITH_CACHE: {
                        root.getArgs().setCodeCache((ICodeCache)new CodeStringCache(JadxWrapper.this.buildBufferedDiskCache(root)));
                        break;
                    }
                    case DISK: {
                        root.getArgs().setCodeCache((ICodeCache)JadxWrapper.this.buildBufferedDiskCache(root));
                    }
                }
            }
        });
    }

    private BufferCodeCache buildBufferedDiskCache(RootNode root) {
        DiskCodeCache diskCache = new DiskCodeCache(root, this.getProject().getCacheDir());
        return new BufferCodeCache(diskCache);
    }

    private void initUsageCache(JadxArgs jadxArgs) {
        switch (this.getSettings().getUsageCacheMode()) {
            case NONE: {
                jadxArgs.setUsageInfoCache((IUsageInfoCache)new EmptyUsageInfoCache());
                break;
            }
            case MEMORY: {
                jadxArgs.setUsageInfoCache((IUsageInfoCache)new InMemoryUsageInfoCache());
                break;
            }
            case DISK: {
                jadxArgs.setUsageInfoCache((IUsageInfoCache)new UsageInfoCache(this.getProject().getCacheDir(), jadxArgs.getInputFiles()));
            }
        }
    }

    public static CommonGuiPluginsContext initGuiPluginsContext(JadxDecompiler decompiler, MainWindow mainWindow) {
        CommonGuiPluginsContext guiPluginsContext = new CommonGuiPluginsContext(mainWindow);
        decompiler.getPluginManager().registerAddPluginListener(pluginContext -> {
            AppContext appContext = new AppContext();
            appContext.setGuiContext((JadxGuiContext)guiPluginsContext.buildForPlugin((PluginContext)pluginContext));
            appContext.setFilesGetter(decompiler.getArgs().getFilesGetter());
            pluginContext.setAppContext(appContext);
        });
        return guiPluginsContext;
    }

    public CommonGuiPluginsContext getGuiPluginsContext() {
        return this.guiPluginsContext;
    }

    public void resetGuiPluginsContext() {
        this.guiPluginsContext.reset();
    }

    public void reloadPasses() {
        this.resetGuiPluginsContext();
        this.decompiler.reloadPasses();
    }

    public List<JavaClass> getClasses() {
        return this.getDecompiler().getClasses();
    }

    public List<JavaClass> getIncludedClasses() {
        List classList = this.getDecompiler().getClasses();
        List<String> excludedPackages = this.getExcludedPackages();
        if (excludedPackages.isEmpty()) {
            return classList;
        }
        return classList.stream().filter(cls -> JadxWrapper.isClassIncluded(excludedPackages, cls)).collect(Collectors.toList());
    }

    public List<JavaClass> getIncludedClassesWithInners() {
        List classes = this.getDecompiler().getClassesWithInners();
        List<String> excludedPackages = this.getExcludedPackages();
        if (excludedPackages.isEmpty()) {
            return classes;
        }
        return classes.stream().filter(cls -> JadxWrapper.isClassIncluded(excludedPackages, cls)).collect(Collectors.toList());
    }

    private static boolean isClassIncluded(List<String> excludedPackages, JavaClass cls) {
        for (String exclude : excludedPackages) {
            String clsFullName = cls.getFullName();
            if (!clsFullName.equals(exclude) && !clsFullName.startsWith(exclude + ".")) continue;
            return false;
        }
        return true;
    }

    public List<List<JavaClass>> buildDecompileBatches(List<JavaClass> classes) {
        return this.getDecompiler().getDecompileScheduler().buildBatches(classes);
    }

    public List<String> getExcludedPackages() {
        String excludedPackages = this.getSettings().getExcludedPackages().trim();
        if (excludedPackages.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(excludedPackages.split(" +"));
    }

    public void setExcludedPackages(List<String> packagesToExclude) {
        this.getSettings().setExcludedPackages(String.join((CharSequence)" ", packagesToExclude).trim());
        this.getSettings().sync();
    }

    public void addExcludedPackage(String packageToExclude) {
        String newExclusion = this.getSettings().getExcludedPackages() + " " + packageToExclude;
        this.getSettings().setExcludedPackages(newExclusion.trim());
        this.getSettings().sync();
    }

    public void removeExcludedPackage(String packageToRemoveFromExclusion) {
        ArrayList<String> list = new ArrayList<String>(this.getExcludedPackages());
        list.remove(packageToRemoveFromExclusion);
        this.getSettings().setExcludedPackages(String.join((CharSequence)" ", list));
        this.getSettings().sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<JadxDecompiler> getCurrentDecompiler() {
        Object object = DECOMPILER_UPDATE_SYNC;
        synchronized (object) {
            return Optional.ofNullable(this.decompiler);
        }
    }

    @NotNull
    public JadxDecompiler getDecompiler() {
        if (this.decompiler == null || this.decompiler.getRoot() == null) {
            throw new JadxRuntimeException("Decompiler not yet loaded");
        }
        return this.decompiler;
    }

    public RootNode getRootNode() {
        return this.getDecompiler().getRoot();
    }

    public void reloadCodeData() {
        this.getDecompiler().reloadCodeData();
    }

    public JavaNode getJavaNodeByRef(ICodeNodeRef nodeRef) {
        return this.getDecompiler().getJavaNodeByRef(nodeRef);
    }

    @Nullable
    public JavaNode getEnclosingNode(ICodeInfo codeInfo, int pos) {
        return this.getDecompiler().getEnclosingNode(codeInfo, pos);
    }

    public List<JavaPackage> getPackages() {
        return this.getDecompiler().getPackages();
    }

    public List<ResourceFile> getResources() {
        return this.getDecompiler().getResources();
    }

    public JadxArgs getArgs() {
        return this.getDecompiler().getArgs();
    }

    public JadxProject getProject() {
        return this.mainWindow.getProject();
    }

    public JadxSettings getSettings() {
        return this.mainWindow.getSettings();
    }

    public CacheObject getCache() {
        return this.mainWindow.getCacheObject();
    }

    @Nullable
    public JavaClass searchJavaClassByFullAlias(String fullName) {
        return this.getDecompiler().getClasses().stream().filter(cls -> cls.getFullName().equals(fullName)).findFirst().orElse(null);
    }

    @Nullable
    public JavaClass searchJavaClassByOrigClassName(String fullName) {
        return this.getDecompiler().searchJavaClassByOrigFullName(fullName);
    }

    @Nullable
    public JavaClass searchJavaClassByRawName(String rawName) {
        return this.getDecompiler().getClasses().stream().filter(cls -> cls.getRawName().equals(rawName)).findFirst().orElse(null);
    }
}

