/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.JavaField;
import jadx.api.JavaNode;
import jadx.api.data.ICodeRename;
import jadx.api.data.IJavaNodeRef;
import jadx.api.data.impl.JadxCodeRename;
import jadx.api.data.impl.JadxNodeRef;
import jadx.api.metadata.ICodeNodeRef;
import jadx.core.deobf.NameMapper;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.info.AccessInfo;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JRenameNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.dialog.RenameDialog;
import jadx.gui.utils.Icons;
import jadx.gui.utils.UiUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import org.jetbrains.annotations.NotNull;

public class JField
extends JNode
implements JRenameNode {
    private static final long serialVersionUID = 1712572192106793359L;
    private static final ImageIcon ICON_FLD_PRI = UiUtils.openSvgIcon("nodes/privateField");
    private static final ImageIcon ICON_FLD_PRO = UiUtils.openSvgIcon("nodes/protectedField");
    private static final ImageIcon ICON_FLD_PUB = UiUtils.openSvgIcon("nodes/publicField");
    private final transient JavaField field;
    private final transient JClass jParent;
    private static final Comparator<JField> COMPARATOR = Comparator.comparing(JField::getJParent).thenComparing(JNode::getName).thenComparingInt(JNode::getPos);

    public JField(JavaField javaField, JClass jClass) {
        this.field = javaField;
        this.jParent = jClass;
    }

    public JavaField getJavaField() {
        return (JavaField)this.getJavaNode();
    }

    @Override
    public JavaNode getJavaNode() {
        return this.field;
    }

    @Override
    public ICodeNodeRef getCodeNodeRef() {
        return this.field.getFieldNode();
    }

    @Override
    public JClass getJParent() {
        return this.jParent;
    }

    @Override
    public JClass getRootClass() {
        return this.jParent.getRootClass();
    }

    @Override
    public boolean canRename() {
        return !this.field.getFieldNode().contains(AFlag.DONT_RENAME);
    }

    @Override
    public JPopupMenu onTreePopupMenu(MainWindow mainWindow) {
        return RenameDialog.buildRenamePopup(mainWindow, this);
    }

    @Override
    public String getTitle() {
        return this.makeLongStringHtml();
    }

    @Override
    public ICodeRename buildCodeRename(String newName, Set<ICodeRename> renames) {
        return new JadxCodeRename((IJavaNodeRef)JadxNodeRef.forFld((JavaField)this.field), newName);
    }

    @Override
    public boolean isValidName(String newName) {
        return NameMapper.isValidIdentifier((String)newName);
    }

    @Override
    public void removeAlias() {
        this.field.removeAlias();
    }

    @Override
    public void addUpdateNodes(List<JavaNode> toUpdate) {
        toUpdate.add((JavaNode)this.field);
        toUpdate.addAll(this.field.getUseIn());
    }

    @Override
    public void reload(MainWindow mainWindow) {
        mainWindow.reloadTreePreservingState();
    }

    @Override
    public Icon getIcon() {
        AccessInfo af = this.field.getAccessFlags();
        return UiUtils.makeIcon(af, ICON_FLD_PUB, ICON_FLD_PRI, ICON_FLD_PRO, Icons.FIELD);
    }

    @Override
    public String getSyntaxName() {
        return "text/java";
    }

    @Override
    public String makeString() {
        return UiUtils.typeFormat(this.field.getName(), this.field.getType());
    }

    @Override
    public String makeStringHtml() {
        return UiUtils.typeFormatHtml(this.field.getName(), this.field.getType());
    }

    @Override
    public String makeLongString() {
        return UiUtils.typeFormat(this.field.getFullName(), this.field.getType());
    }

    @Override
    public String makeLongStringHtml() {
        return UiUtils.typeFormatHtml(this.field.getFullName(), this.field.getType());
    }

    @Override
    public String getTooltip() {
        String fullType = UiUtils.escapeHtml(this.field.getType().toString());
        return UiUtils.wrapHtml(fullType + " " + UiUtils.escapeHtml(this.field.getName()));
    }

    @Override
    public String makeDescString() {
        return UiUtils.typeStr(this.field.getType()) + " " + this.field.getName();
    }

    @Override
    public boolean disableHtml() {
        return false;
    }

    @Override
    public boolean hasDescString() {
        return false;
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof JField && this.field.equals((Object)((JField)o).field);
    }

    public int compareToFld(@NotNull JField other) {
        return COMPARATOR.compare(this, other);
    }

    @Override
    public int compareTo(@NotNull JNode other) {
        if (other instanceof JField) {
            return this.compareToFld((JField)other);
        }
        return super.compareTo(other);
    }
}

