/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.settings.ui.shortcut;

import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.ui.JadxSettingsWindow;
import jadx.gui.ui.action.ActionModel;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.shortcut.Shortcut;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class ShortcutEdit
extends JPanel {
    private static final Icon CLEAR_ICON = UiUtils.openSvgIcon("ui/close");
    private final ActionModel actionModel;
    private final JadxSettingsWindow settingsWindow;
    private final JadxSettings settings;
    private final TextField textField;
    public Shortcut shortcut;

    public ShortcutEdit(ActionModel actionModel, JadxSettingsWindow settingsWindow, JadxSettings settings) {
        this.actionModel = actionModel;
        this.settings = settings;
        this.settingsWindow = settingsWindow;
        this.textField = new TextField();
        JButton clearButton = new JButton(CLEAR_ICON);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.textField);
        this.add(clearButton);
        clearButton.addActionListener(e -> {
            this.setShortcut(Shortcut.none());
            this.saveShortcut();
        });
    }

    public void setShortcut(Shortcut shortcut) {
        this.shortcut = shortcut;
        this.textField.reload();
    }

    private void saveShortcut() {
        this.settings.getShortcuts().put(this.actionModel, this.shortcut);
        this.settingsWindow.needReload();
    }

    private boolean verifyShortcut(Shortcut shortcut) {
        int dialogResult;
        ActionModel otherAction = null;
        for (ActionModel a : ActionModel.values()) {
            if (this.actionModel == a || !shortcut.equals(this.settings.getShortcuts().get(a))) continue;
            otherAction = a;
            break;
        }
        return otherAction == null || (dialogResult = JOptionPane.showConfirmDialog(this, NLS.str("msg.duplicate_shortcut", shortcut, otherAction.getName(), otherAction.getCategory().getName()), NLS.str("msg.warning_title"), 0)) == 0;
    }

    private class TextField
    extends JTextField {
        private Shortcut tempShortcut;

        public TextField() {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(ev -> {
                if (!this.isListening()) {
                    return false;
                }
                if (ev.getID() == 401) {
                    Shortcut pressedShortcut = Shortcut.keyboard(ev.getKeyCode(), ev.getModifiersEx());
                    if (pressedShortcut.isValidKeyboard()) {
                        this.tempShortcut = pressedShortcut;
                        this.refresh(this.tempShortcut);
                    } else {
                        this.tempShortcut = null;
                    }
                } else if (ev.getID() == 402) {
                    this.removeFocus();
                }
                ev.consume();
                return true;
            });
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent ev) {
                }

                @Override
                public void focusLost(FocusEvent ev) {
                    if (TextField.this.tempShortcut != null) {
                        if (ShortcutEdit.this.verifyShortcut(TextField.this.tempShortcut)) {
                            ShortcutEdit.this.shortcut = TextField.this.tempShortcut;
                            ShortcutEdit.this.saveShortcut();
                        } else {
                            TextField.this.reload();
                        }
                        TextField.this.tempShortcut = null;
                    }
                }
            });
            Toolkit.getDefaultToolkit().addAWTEventListener(event -> {
                MouseEvent mouseEvent;
                if (!this.isListening()) {
                    return;
                }
                if (event instanceof MouseEvent && (mouseEvent = (MouseEvent)event).getID() == 501) {
                    int dialogResult;
                    int mouseButton = mouseEvent.getButton();
                    if (mouseButton <= 1) {
                        return;
                    }
                    if (mouseButton <= 3 && (dialogResult = JOptionPane.showConfirmDialog(this, NLS.str("msg.common_mouse_shortcut"), NLS.str("msg.warning_title"), 0)) != 0) {
                        ((MouseEvent)event).consume();
                        this.tempShortcut = null;
                        this.removeFocus();
                        return;
                    }
                    ((MouseEvent)event).consume();
                    this.tempShortcut = Shortcut.mouse(mouseButton);
                    this.refresh(this.tempShortcut);
                    this.removeFocus();
                }
            }, 16L);
        }

        public void reload() {
            this.refresh(ShortcutEdit.this.shortcut);
        }

        private void refresh(Shortcut displayedShortcut) {
            if (displayedShortcut == null || displayedShortcut.isNone()) {
                this.setText("None");
                this.setForeground(UIManager.getColor("TextArea.inactiveForeground"));
                return;
            }
            this.setText(displayedShortcut.toString());
            this.setForeground(UIManager.getColor("TextArea.foreground"));
        }

        private void removeFocus() {
            this.getRootPane().requestFocus();
        }

        private boolean isListening() {
            return this.isFocusOwner();
        }
    }
}

