/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils;

import com.formdev.flatlaf.FlatDarculaLaf;
import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatIntelliJLaf;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.extras.FlatAnimatedLafChange;
import com.formdev.flatlaf.intellijthemes.FlatAllIJThemes;
import com.formdev.flatlaf.themes.FlatMacDarkLaf;
import com.formdev.flatlaf.themes.FlatMacLightLaf;
import jadx.gui.settings.JadxSettings;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LafManager {
    private static final Logger LOG = LoggerFactory.getLogger(LafManager.class);
    public static final String SYSTEM_THEME_NAME = "default";
    public static final String INITIAL_THEME_NAME = "FlatLaf Light";
    private static final Map<String, String> THEMES_MAP = LafManager.initThemesMap();

    public static void init(JadxSettings settings) {
        if (LafManager.setupLaf(LafManager.getThemeClass(settings))) {
            return;
        }
        LafManager.setupLaf(SYSTEM_THEME_NAME);
        settings.setLafTheme(SYSTEM_THEME_NAME);
        settings.sync();
    }

    public static void updateLaf(JadxSettings settings) {
        if (LafManager.setupLaf(LafManager.getThemeClass(settings))) {
            FlatAnimatedLafChange.hideSnapshotWithAnimation();
            FlatLaf.updateUI();
        }
    }

    public static String[] getThemes() {
        return THEMES_MAP.keySet().toArray(new String[0]);
    }

    private static String getThemeClass(JadxSettings settings) {
        return THEMES_MAP.get(settings.getLafTheme());
    }

    private static boolean setupLaf(String themeClass) {
        if (SYSTEM_THEME_NAME.equals(themeClass)) {
            return LafManager.applyLaf(UIManager.getSystemLookAndFeelClassName());
        }
        if (themeClass != null && !themeClass.isEmpty()) {
            return LafManager.applyLaf(themeClass);
        }
        return false;
    }

    private static Map<String, String> initThemesMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(SYSTEM_THEME_NAME, SYSTEM_THEME_NAME);
        map.put(INITIAL_THEME_NAME, FlatLightLaf.class.getName());
        map.put("FlatLaf Dark", FlatDarkLaf.class.getName());
        map.put("FlatLaf macOS Light", FlatMacLightLaf.class.getName());
        map.put("FlatLaf macOS Dark", FlatMacDarkLaf.class.getName());
        map.put("FlatLaf IntelliJ", FlatIntelliJLaf.class.getName());
        map.put("FlatLaf Darcula", FlatDarculaLaf.class.getName());
        for (FlatAllIJThemes.FlatIJLookAndFeelInfo themeInfo : FlatAllIJThemes.INFOS) {
            map.put(themeInfo.getName(), themeInfo.getClassName());
        }
        return map;
    }

    private static boolean applyLaf(String theme) {
        try {
            FlatAnimatedLafChange.showSnapshot();
            UIManager.setLookAndFeel(theme);
            return true;
        }
        catch (Exception e) {
            LOG.error("Failed to set laf to {}", (Object)theme, (Object)e);
            return false;
        }
    }
}

