/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.tab.dnd;

import jadx.gui.ui.tab.dnd.TabDndController;
import jadx.gui.ui.tab.dnd.TabDndGhostPane;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;

class TabDndTargetListener
implements DropTargetListener {
    private static final Point HIDDEN_POINT = new Point(0, -1000);
    private final transient TabDndController dnd;

    public TabDndTargetListener(TabDndController dnd) {
        this.dnd = dnd;
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        DataFlavor[] f;
        TabDndGhostPane pane = this.dnd.getDndGhostPane();
        if (pane == null || e.getDropTargetContext().getComponent() != pane) {
            return;
        }
        Transferable t = e.getTransferable();
        if (t.isDataFlavorSupported((f = e.getCurrentDataFlavors())[0])) {
            e.acceptDrag(e.getDropAction());
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        TabDndGhostPane pane = this.dnd.getDndGhostPane();
        if (pane == null || e.getDropTargetContext().getComponent() != pane) {
            return;
        }
        pane.setPoint(HIDDEN_POINT);
        pane.setTargetRect(0, 0, 0, 0);
        pane.repaint();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        TabDndGhostPane pane = this.dnd.getDndGhostPane();
        if (pane == null || e.getDropTargetContext().getComponent() != pane) {
            return;
        }
        Point glassPt = e.getLocation();
        this.dnd.updateTargetMark(this.dnd.getTargetTabIndex(glassPt));
        this.dnd.scrollIfNeeded(glassPt);
        pane.setPoint(glassPt);
        pane.repaint();
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        TabDndGhostPane pane = this.dnd.getDndGhostPane();
        if (pane == null || e.getDropTargetContext().getComponent() != pane) {
            return;
        }
        Transferable t = e.getTransferable();
        DataFlavor[] f = t.getTransferDataFlavors();
        int oldIdx = this.dnd.dragTabIndex;
        int newIdx = this.dnd.getTargetTabIndex(e.getLocation());
        if (t.isDataFlavorSupported(f[0]) && oldIdx != newIdx) {
            this.dnd.swapTabs(oldIdx, newIdx);
            e.dropComplete(true);
        } else {
            e.dropComplete(false);
        }
        pane.setVisible(false);
    }
}

