/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.tab;

import jadx.gui.ui.MainWindow;
import jadx.gui.ui.tab.ITabStatesListener;
import jadx.gui.ui.tab.TabBlueprint;
import jadx.gui.utils.JumpManager;
import jadx.gui.utils.JumpPosition;
import org.jetbrains.annotations.Nullable;

public class NavigationController
implements ITabStatesListener {
    private final transient MainWindow mainWindow;
    private final transient JumpManager jumps = new JumpManager();

    public NavigationController(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        mainWindow.getTabsController().addListener(this);
    }

    public void navBack() {
        this.jump(this.jumps.getPrev());
    }

    public void navForward() {
        this.jump(this.jumps.getNext());
    }

    private void jump(@Nullable JumpPosition pos) {
        if (pos != null) {
            this.mainWindow.getTabsController().codeJump(pos);
        }
    }

    @Override
    public void onTabCodeJump(TabBlueprint blueprint, @Nullable JumpPosition prevPos, JumpPosition newPos) {
        if (newPos.equals(this.jumps.getCurrent())) {
            return;
        }
        this.jumps.addPosition(prevPos);
        this.jumps.addPosition(newPos);
    }

    @Override
    public void onTabSmaliJump(TabBlueprint blueprint, int pos, boolean debugMode) {
    }

    public void reset() {
        this.jumps.reset();
    }

    public void dispose() {
        this.reset();
        this.mainWindow.getTabsController().removeListener(this);
    }
}

