/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.hexviewer;

import jadx.gui.settings.JadxSettings;
import jadx.gui.ui.hexviewer.BinEdCodeAreaAssessor;
import jadx.gui.ui.hexviewer.HexEditorHeader;
import jadx.gui.ui.hexviewer.HexInspectorPanel;
import jadx.gui.ui.hexviewer.HexSearchBar;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.array.ByteArrayEditableData;
import org.exbin.bined.CodeAreaCaretListener;
import org.exbin.bined.CodeAreaCaretPosition;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.CodeCharactersCase;
import org.exbin.bined.CodeType;
import org.exbin.bined.EditMode;
import org.exbin.bined.SelectionRange;
import org.exbin.bined.basic.BasicCodeAreaZone;
import org.exbin.bined.color.CodeAreaBasicColors;
import org.exbin.bined.color.CodeAreaColorType;
import org.exbin.bined.highlight.swing.color.CodeAreaMatchColorType;
import org.exbin.bined.swing.CodeAreaCharAssessor;
import org.exbin.bined.swing.CodeAreaColorAssessor;
import org.exbin.bined.swing.CodeAreaPainter;
import org.exbin.bined.swing.basic.DefaultCodeAreaCommandHandler;
import org.exbin.bined.swing.basic.color.CodeAreaColorsProfile;
import org.exbin.bined.swing.capability.CharAssessorPainterCapable;
import org.exbin.bined.swing.capability.ColorAssessorPainterCapable;
import org.exbin.bined.swing.section.SectCodeArea;
import org.exbin.bined.swing.section.color.SectionCodeAreaColorProfile;

public class HexPreviewPanel
extends JPanel {
    private static final long serialVersionUID = 3261685857479120073L;
    private static final int CACHE_SIZE = 250;
    private final byte[] valuesCache = new byte[250];
    private final SectCodeArea hexCodeArea;
    private final SectionCodeAreaColorProfile defaultColors;
    private final HexEditorHeader header;
    private final HexSearchBar searchBar;
    private final HexInspectorPanel inspector;
    private JPopupMenu popupMenu;
    private JMenuItem cutAction;
    private JMenuItem copyAction;
    private JMenuItem copyHexAction;
    private JMenuItem copyStringAction;
    private JMenuItem pasteAction;
    private JMenuItem deleteAction;
    private JMenuItem selectAllAction;
    private JMenuItem copyOffsetItem;
    private BasicCodeAreaZone popupMenuPositionZone = BasicCodeAreaZone.UNKNOWN;

    public HexPreviewPanel(JadxSettings settings) {
        this.hexCodeArea = new SectCodeArea();
        this.hexCodeArea.setCodeFont(settings.getFont());
        this.hexCodeArea.setEditMode(EditMode.READ_ONLY);
        this.hexCodeArea.setCharset(StandardCharsets.UTF_8);
        this.hexCodeArea.setComponentPopupMenu(new JPopupMenu(){

            @Override
            public void show(Component invoker, int x, int y) {
                HexPreviewPanel.this.popupMenuPositionZone = HexPreviewPanel.this.hexCodeArea.getPainter().getPositionZone(x, y);
                HexPreviewPanel.this.createPopupMenu();
                if (HexPreviewPanel.this.popupMenu != null && HexPreviewPanel.this.popupMenuPositionZone != BasicCodeAreaZone.HEADER && HexPreviewPanel.this.popupMenuPositionZone != BasicCodeAreaZone.ROW_POSITIONS) {
                    HexPreviewPanel.this.updatePopupActionStates();
                    HexPreviewPanel.this.popupMenu.show(invoker, x, y);
                }
            }
        });
        this.inspector = new HexInspectorPanel();
        this.searchBar = new HexSearchBar(this.hexCodeArea);
        this.header = new HexEditorHeader(this.hexCodeArea);
        this.header.setFont(settings.getFont());
        CodeAreaPainter painter = this.hexCodeArea.getPainter();
        this.defaultColors = (SectionCodeAreaColorProfile)this.hexCodeArea.getColorsProfile();
        this.hexCodeArea.setColorsProfile((CodeAreaColorsProfile)this.getColorsProfile());
        BinEdCodeAreaAssessor codeAreaAssessor = new BinEdCodeAreaAssessor(((ColorAssessorPainterCapable)painter).getColorAssessor(), ((CharAssessorPainterCapable)painter).getCharAssessor());
        ((ColorAssessorPainterCapable)painter).setColorAssessor((CodeAreaColorAssessor)codeAreaAssessor);
        ((CharAssessorPainterCapable)painter).setCharAssessor((CodeAreaCharAssessor)codeAreaAssessor);
        this.setLayout(new BorderLayout());
        this.add((Component)this.searchBar, "First");
        this.add((Component)this.hexCodeArea, "Center");
        this.add((Component)this.header, "Last");
        this.add((Component)this.inspector, "East");
        this.setFocusable(true);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                HexPreviewPanel.this.hexCodeArea.requestFocusInWindow();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.createActions();
        this.enableUpdate();
    }

    public SectionCodeAreaColorProfile getColorsProfile() {
        boolean isDarkTheme = UiUtils.isDarkTheme(Objects.requireNonNull(this.defaultColors.getColor((CodeAreaColorType)CodeAreaBasicColors.TEXT_BACKGROUND)));
        Color markAllHighlightColor = isDarkTheme ? Color.decode("#32593D") : Color.decode("#ffc800");
        Color editorSelectionBackground = Objects.requireNonNull(this.defaultColors.getColor((CodeAreaColorType)CodeAreaBasicColors.SELECTION_BACKGROUND));
        Color currentMatchColor = UiUtils.adjustBrightness(editorSelectionBackground, isDarkTheme ? 0.6f : 1.4f);
        this.defaultColors.setColor((CodeAreaColorType)CodeAreaMatchColorType.MATCH_BACKGROUND, markAllHighlightColor);
        this.defaultColors.setColor((CodeAreaColorType)CodeAreaMatchColorType.CURRENT_MATCH_BACKGROUND, currentMatchColor);
        return this.defaultColors;
    }

    public boolean isDataLoaded() {
        return !this.hexCodeArea.getContentData().isEmpty();
    }

    public void setData(byte[] data) {
        if (data != null) {
            this.hexCodeArea.setContentData((BinaryData)new ByteArrayEditableData(data));
            this.inspector.setBytes(data);
        }
    }

    public void enableUpdate() {
        CodeAreaCaretListener caretMovedListener = caretPosition -> this.updateValues();
        this.hexCodeArea.addCaretMovedListener(caretMovedListener);
    }

    private void updateValues() {
        long dataSize;
        CodeAreaCaretPosition caretPosition = this.hexCodeArea.getActiveCaretPosition();
        long dataPosition = caretPosition.getDataPosition();
        if (dataPosition < (dataSize = this.hexCodeArea.getDataSize())) {
            int availableData = dataSize - dataPosition >= 250L ? 250 : (int)(dataSize - dataPosition);
            BinaryData contentData = this.hexCodeArea.getContentData();
            contentData.copyToArray(dataPosition, this.valuesCache, 0, availableData);
            if (availableData < 250) {
                Arrays.fill(this.valuesCache, availableData, 250, (byte)0);
            }
        }
        this.inspector.setOffset((int)dataPosition);
    }

    private void createActions() {
        this.cutAction = new JMenuItem(NLS.str("popup.cut"));
        this.cutAction.addActionListener(e -> this.performCut());
        this.copyAction = new JMenuItem(NLS.str("popup.copy"));
        this.copyAction.addActionListener(e -> this.performCopy());
        this.copyHexAction = new JMenuItem(NLS.str("popup.copy_as_hex"));
        this.copyHexAction.addActionListener(e -> this.performCopyAsCode());
        this.copyStringAction = new JMenuItem(NLS.str("popup.copy_as_string"));
        this.copyStringAction.addActionListener(e -> this.performCopy());
        this.pasteAction = new JMenuItem(NLS.str("popup.paste"));
        this.pasteAction.addActionListener(e -> this.performPaste());
        this.deleteAction = new JMenuItem(NLS.str("popup.delete"));
        this.deleteAction.addActionListener(e -> {
            if (!this.isEditable()) {
                this.performDelete();
            }
        });
        this.selectAllAction = new JMenuItem(NLS.str("popup.select_all"));
        this.selectAllAction.addActionListener(e -> this.performSelectAll());
        this.copyOffsetItem = new JMenuItem(NLS.str("popup.copy_offset"));
        this.copyOffsetItem.addActionListener(e -> this.copyOffset());
    }

    private void createPopupMenu() {
        boolean isEditable = this.isEditable();
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.copyAction);
        if (isEditable) {
            this.popupMenu.add(this.cutAction);
            this.popupMenu.add(this.pasteAction);
            this.popupMenu.add(this.deleteAction);
            this.popupMenu.addSeparator();
        }
        JMenu copyMenu = new JMenu(NLS.str("popup.copy_as"));
        copyMenu.add(this.copyHexAction);
        copyMenu.add(this.copyStringAction);
        this.popupMenu.add(copyMenu);
        this.popupMenu.add(this.copyOffsetItem);
        this.popupMenu.add(this.selectAllAction);
    }

    private void updatePopupActionStates() {
        boolean selectionExists = this.isSelection();
        boolean isEditable = !this.isEditable();
        this.cutAction.setEnabled(isEditable && selectionExists);
        this.copyAction.setEnabled(selectionExists);
        this.copyHexAction.setEnabled(selectionExists);
        this.copyStringAction.setEnabled(selectionExists);
        this.deleteAction.setEnabled(isEditable && selectionExists);
        this.selectAllAction.setEnabled(this.hexCodeArea.getDataSize() > 0L);
    }

    public SectCodeArea getEditor() {
        return this.hexCodeArea;
    }

    public HexEditorHeader getHeader() {
        return this.header;
    }

    public HexInspectorPanel getInspector() {
        return this.inspector;
    }

    public HexSearchBar getSearchBar() {
        return this.searchBar;
    }

    public void showSearchBar() {
        this.searchBar.showAndFocus();
    }

    public void performCut() {
        this.hexCodeArea.cut();
    }

    public void performCopy() {
        this.hexCodeArea.copy();
    }

    public void performCopyAsCode() {
        ((DefaultCodeAreaCommandHandler)this.hexCodeArea.getCommandHandler()).copyAsCode();
    }

    public void performPaste() {
        this.hexCodeArea.paste();
    }

    public void performDelete() {
        this.hexCodeArea.delete();
    }

    public void performSelectAll() {
        this.hexCodeArea.selectAll();
    }

    public boolean isSelection() {
        return this.hexCodeArea.hasSelection();
    }

    public boolean isEditable() {
        return this.hexCodeArea.isEditable();
    }

    public boolean canPaste() {
        return this.hexCodeArea.canPaste();
    }

    public static String getSelectionData(SectCodeArea core) {
        SelectionRange selection = core.getSelection();
        if (!selection.isEmpty()) {
            long first = selection.getFirst();
            long last = selection.getLast();
            BinaryData copy = core.getContentData().copy(first, last - first + 1L);
            CodeType codeType = core.getCodeType();
            CodeCharactersCase charactersCase = core.getCodeCharactersCase();
            int charsPerByte = codeType.getMaxDigitsForByte() + 1;
            int textLength = (int)(copy.getDataSize() * (long)charsPerByte);
            if (textLength > 0) {
                --textLength;
            }
            char[] targetData = new char[textLength];
            Arrays.fill(targetData, ' ');
            for (int i = 0; i < (int)copy.getDataSize(); ++i) {
                CodeAreaUtils.byteToCharsCode((byte)copy.getByte((long)i), (CodeType)codeType, (char[])targetData, (int)(i * charsPerByte), (CodeCharactersCase)charactersCase);
            }
            return new String(targetData);
        }
        return null;
    }

    public void copyOffset() {
        String str = this.header.addressString(this.hexCodeArea.getSelection().getStart());
        UiUtils.copyToClipboard(str);
    }
}

