/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.api.ResourceFile;
import jadx.api.ResourcesLoader;
import jadx.core.utils.exceptions.JadxException;
import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.LineNumbersMode;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JResource;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.ui.codearea.AbstractCodeContentPanel;
import jadx.gui.ui.codearea.CodeArea;
import jadx.gui.ui.codearea.CodePanel;
import jadx.gui.ui.hexviewer.HexPreviewPanel;
import jadx.gui.ui.tab.TabbedPane;
import jadx.gui.utils.NLS;
import java.awt.BorderLayout;
import java.awt.Component;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryContentPanel
extends AbstractCodeContentPanel {
    private static final Logger LOG = LoggerFactory.getLogger(BinaryContentPanel.class);
    private final transient CodePanel textCodePanel;
    private final transient HexPreviewPanel hexPreviewPanel;
    private final transient JTabbedPane areaTabbedPane;

    public BinaryContentPanel(TabbedPane panel, JNode jnode) {
        this(panel, jnode, true);
    }

    public BinaryContentPanel(TabbedPane panel, JNode jnode, boolean supportsText) {
        super(panel, jnode);
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.textCodePanel = supportsText ? new CodePanel(new CodeArea(this, jnode)) : null;
        this.hexPreviewPanel = new HexPreviewPanel(this.getSettings());
        this.hexPreviewPanel.getInspector().setVisible(false);
        this.areaTabbedPane = this.buildTabbedPane();
        this.add(this.areaTabbedPane);
        SwingUtilities.invokeLater(this::loadSelectedPanel);
    }

    private void loadToHexView(JNode binaryNode) {
        if (this.hexPreviewPanel.isDataLoaded()) {
            return;
        }
        AtomicReference bytesRef = new AtomicReference();
        this.getMainWindow().getBackgroundExecutor().execute(NLS.str("progress.load"), () -> {
            byte[] bytes = null;
            if (binaryNode instanceof JResource) {
                JResource jResource = (JResource)binaryNode;
                try {
                    bytes = (byte[])ResourcesLoader.decodeStream((ResourceFile)jResource.getResFile(), (size, is) -> is.readAllBytes());
                }
                catch (JadxException e) {
                    LOG.error("Failed to directly load resource binary data {}: {}", (Object)jResource.getName(), (Object)e.getMessage());
                }
            }
            if (bytes == null) {
                bytes = binaryNode.getCodeInfo().getCodeStr().getBytes(StandardCharsets.UTF_8);
            }
            bytesRef.set(bytes);
        }, taskStatus -> {
            byte[] bytes = (byte[])bytesRef.get();
            if (bytes != null) {
                this.hexPreviewPanel.setData(bytes);
            }
        });
    }

    private JTabbedPane buildTabbedPane() {
        JTabbedPane tabbedPane = new JTabbedPane(3);
        tabbedPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        tabbedPane.setTabLayoutPolicy(1);
        if (this.textCodePanel != null) {
            tabbedPane.add((Component)this.textCodePanel, "Text");
        }
        tabbedPane.add((Component)this.hexPreviewPanel, "Hex");
        tabbedPane.addChangeListener(e -> {
            this.getMainWindow().toggleHexViewMenu();
            this.loadSelectedPanel();
        });
        return tabbedPane;
    }

    private void loadSelectedPanel() {
        Component codePanel = this.getSelectedPanel();
        if (codePanel instanceof CodeArea) {
            CodeArea codeArea = (CodeArea)((Object)codePanel);
            codeArea.load();
        } else {
            this.loadToHexView(this.getNode());
        }
    }

    @Override
    public AbstractCodeArea getCodeArea() {
        if (this.textCodePanel != null) {
            return this.textCodePanel.getCodeArea();
        }
        return null;
    }

    @Override
    public Component getChildrenComponent() {
        return this.getSelectedPanel();
    }

    @Override
    public void loadSettings() {
        if (this.textCodePanel != null) {
            this.textCodePanel.loadSettings();
        }
        this.updateUI();
    }

    @Override
    public JadxSettings getSettings() {
        JadxSettings settings = super.getSettings();
        settings.setLineNumbersMode(LineNumbersMode.NORMAL);
        return settings;
    }

    private Component getSelectedPanel() {
        Object selectedPanel;
        Component selectedComponent = this.areaTabbedPane.getSelectedComponent();
        if (selectedComponent instanceof CodePanel) {
            selectedPanel = ((CodePanel)selectedComponent).getCodeArea();
        } else if (selectedComponent instanceof JSplitPane) {
            selectedPanel = ((JSplitPane)selectedComponent).getLeftComponent();
        } else if (selectedComponent instanceof HexPreviewPanel) {
            selectedPanel = selectedComponent;
        } else {
            throw new RuntimeException("tabbedPane.getSelectedComponent returned a Component of unexpected type " + selectedComponent);
        }
        return selectedPanel;
    }
}

