/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.search.providers;

import jadx.api.JavaClass;
import jadx.core.dex.info.ClassInfo;
import jadx.gui.jobs.Cancelable;
import jadx.gui.search.SearchSettings;
import jadx.gui.search.providers.BaseSearchProvider;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class ClassSearchProvider
extends BaseSearchProvider {
    private int clsNum = 0;

    public ClassSearchProvider(MainWindow mw, SearchSettings searchSettings, List<JavaClass> classes) {
        super(mw, searchSettings, classes);
    }

    @Override
    @Nullable
    public JNode next(Cancelable cancelable) {
        JavaClass curCls;
        do {
            if (!cancelable.isCanceled() && this.clsNum < this.classes.size()) continue;
            return null;
        } while (!this.checkCls(curCls = (JavaClass)this.classes.get(this.clsNum++)));
        return this.convert(curCls);
    }

    private boolean checkCls(JavaClass cls) {
        ClassInfo clsInfo = cls.getClassNode().getClassInfo();
        return this.isMatch(clsInfo.getShortName()) || this.isMatch(clsInfo.getFullName()) || this.isMatch(clsInfo.getAliasFullName()) || this.isMatch(clsInfo.getRawName());
    }

    @Override
    public int progress() {
        return this.clsNum;
    }
}

