/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.plugins.script;

import javax.swing.Icon;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;

public class ScriptCompletionData
implements Completion {
    private final CompletionProvider provider;
    private final int relevance;
    private String input;
    private String code;
    private int replacePos;
    private Icon icon;
    private String summary;
    private String toolTip;

    public ScriptCompletionData(CompletionProvider provider, int relevance) {
        this.provider = provider;
        this.relevance = relevance;
    }

    public void setData(String input, String code, int replacePos) {
        this.input = input;
        this.code = code;
        this.replacePos = replacePos;
    }

    public String getInputText() {
        return this.input;
    }

    public CompletionProvider getProvider() {
        return this.provider;
    }

    public String getAlreadyEntered(JTextComponent comp) {
        return this.provider.getAlreadyEnteredText(comp);
    }

    public int getRelevance() {
        return this.relevance;
    }

    public String getReplacementText() {
        return this.code.substring(0, this.replacePos) + this.input;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getToolTipText() {
        return this.toolTip;
    }

    public void setToolTip(String toolTip) {
        this.toolTip = toolTip;
    }

    public int compareTo(Completion other) {
        return Integer.compare(this.relevance, other.getRelevance());
    }

    public String toString() {
        return this.input;
    }
}

