/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.plugins.quark;

import ch.qos.logback.classic.Level;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.jobs.BackgroundExecutor;
import jadx.gui.logs.LogOptions;
import jadx.gui.plugins.quark.QuarkReportNode;
import jadx.gui.treemodel.JRoot;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.SystemInfo;
import jadx.gui.utils.UiUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuarkManager {
    private static final Logger LOG = LoggerFactory.getLogger(QuarkManager.class);
    private static final Path QUARK_DIR_PATH = Paths.get(System.getProperty("user.home"), ".quark-engine");
    private static final Path VENV_PATH = QUARK_DIR_PATH.resolve("quark_venv");
    private static final int LARGE_APK_SIZE = 30;
    private final MainWindow mainWindow;
    private final Path apkPath;
    private boolean useVEnv;
    private boolean installComplete;
    private Path reportFile;

    public QuarkManager(MainWindow mainWindow, Path apkPath) {
        this.mainWindow = mainWindow;
        this.apkPath = apkPath;
    }

    public void start() {
        int result;
        if (!this.checkFileSize(30) && (result = JOptionPane.showConfirmDialog(this.mainWindow, "The selected file size is too large (over 30M) that may take a long time to analyze, do you want to continue", "Quark: Warning", 0)) == 1) {
            return;
        }
        BackgroundExecutor executor = this.mainWindow.getBackgroundExecutor();
        executor.execute("Quark install", this::checkInstall, installStatus -> executor.execute("Quark analysis", this::startAnalysis, analysisStatus -> this.loadReport()));
    }

    private void checkInstall() {
        try {
            if (this.checkCommand("quark")) {
                this.useVEnv = false;
                this.installComplete = true;
                return;
            }
            this.useVEnv = true;
            if (this.checkVEnvCommand("quark")) {
                this.installComplete = true;
                this.installQuark();
                return;
            }
            int result = JOptionPane.showConfirmDialog(this.mainWindow, "Quark is not installed, do you want to install it from PyPI?", "Warning", 0);
            if (result == 1) {
                this.installComplete = false;
                return;
            }
            this.createVirtualEnv();
            this.installQuark();
            this.installComplete = true;
        }
        catch (Exception e) {
            UiUtils.errorMessage(this.mainWindow, e.getMessage());
            LOG.error("Failed to install quark", (Throwable)e);
            this.installComplete = false;
        }
    }

    private void startAnalysis() {
        if (!this.installComplete) {
            return;
        }
        try {
            this.updateQuarkRules();
            this.reportFile = Files.createTempFile("QuarkReport-", ".json", new FileAttribute[0]).toAbsolutePath();
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(this.getCommand("quark"));
            cmd.add("-a");
            cmd.add(this.apkPath.toString());
            cmd.add("-o");
            cmd.add(this.reportFile.toString());
            this.runCommand(cmd);
        }
        catch (Exception e) {
            UiUtils.errorMessage(this.mainWindow, "Failed to execute Quark");
            LOG.error("Failed to execute Quark", (Throwable)e);
        }
    }

    private void loadReport() {
        try {
            QuarkReportNode quarkNode = new QuarkReportNode(this.reportFile);
            JRoot root = this.mainWindow.getTreeRoot();
            root.replaceCustomNode(quarkNode);
            root.update();
            this.mainWindow.reloadTree();
            this.mainWindow.getTabsController().selectTab(quarkNode);
        }
        catch (Exception e) {
            UiUtils.errorMessage(this.mainWindow, "Failed to load Quark report.");
            LOG.error("Failed to load Quark report.", (Throwable)e);
        }
    }

    private void createVirtualEnv() {
        if (Files.exists(this.getVenvPath("activate"), new LinkOption[0])) {
            return;
        }
        File directory = QUARK_DIR_PATH.toFile();
        if (!directory.isDirectory() && !directory.mkdirs()) {
            throw new JadxRuntimeException("Failed create directory: " + directory);
        }
        ArrayList<String> cmd = new ArrayList<String>();
        if (SystemInfo.IS_WINDOWS) {
            cmd.add("python");
            cmd.add("-m");
            cmd.add("venv");
        } else {
            cmd.add("virtualenv");
        }
        cmd.add(VENV_PATH.toString());
        try {
            this.runCommand(cmd);
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to create virtual environment", (Throwable)e);
        }
    }

    private void installQuark() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.getCommand("pip3"));
        cmd.add("install");
        cmd.add("setuptools");
        cmd.add("quark-engine");
        cmd.add("--upgrade");
        try {
            this.runCommand(cmd);
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to install quark-engine", (Throwable)e);
        }
    }

    private void updateQuarkRules() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.getCommand("freshquark"));
        try {
            this.runCommand(cmd);
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to update quark rules", (Throwable)e);
        }
    }

    public boolean checkFileSize(int sizeThreshold) {
        try {
            int fileSize = (int)Files.size(this.apkPath) / 1024 / 1024;
            if (fileSize > sizeThreshold) {
                return false;
            }
        }
        catch (Exception e) {
            LOG.error("Failed to calculate file: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
        return true;
    }

    private String getCommand(String cmd) {
        if (this.useVEnv) {
            return this.getVenvPath(cmd).toAbsolutePath().toString();
        }
        return cmd;
    }

    private boolean checkVEnvCommand(String cmd) {
        Path venvPath = this.getVenvPath(cmd);
        return this.checkCommand(venvPath.toAbsolutePath().toString());
    }

    private Path getVenvPath(String cmd) {
        if (SystemInfo.IS_WINDOWS) {
            return VENV_PATH.resolve("Scripts").resolve(cmd + ".exe");
        }
        return VENV_PATH.resolve("bin").resolve(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCommand(List<String> cmd) throws Exception {
        this.mainWindow.showLogViewer(LogOptions.forLevel(Level.INFO));
        LOG.info("Running command: {}", (Object)String.join((CharSequence)" ", cmd));
        ProcessBuilder builder = new ProcessBuilder(cmd);
        builder.redirectErrorStream(true);
        Process process = builder.start();
        try (BufferedReader buf = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            buf.lines().forEach(msg -> LOG.info("# {}", msg));
        }
        finally {
            process.waitFor();
        }
        if (process.exitValue() != 0) {
            throw new RuntimeException("Execution failed (exit code " + process.exitValue() + ") - command " + String.join((CharSequence)" ", cmd) + "\nPlease see command log output what was going wrong.");
        }
    }

    private boolean checkCommand(String ... cmd) {
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            process.waitFor();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

