/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.plugins.mappings;

import jadx.api.ICodeInfo;
import jadx.api.impl.SimpleCodeInfo;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.utils.files.FileUtils;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JEditableNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.CodeContentPanel;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.ui.tab.TabbedPane;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.ui.SimpleMenuItem;
import java.nio.file.Path;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JInputMapping
extends JEditableNode {
    private static final Logger LOG = LoggerFactory.getLogger(JInputMapping.class);
    private static final ImageIcon MAPPING_ICON = UiUtils.openSvgIcon("nodes/abbreviatePackageNames");
    private final Path mappingPath;
    private final String name;

    public JInputMapping(Path mappingPath) {
        this.mappingPath = mappingPath;
        this.name = mappingPath.getFileName().toString();
    }

    @Override
    public ContentPanel getContentPanel(TabbedPane tabbedPane) {
        return new CodeContentPanel(tabbedPane, this);
    }

    @Override
    @NotNull
    public ICodeInfo getCodeInfo() {
        try {
            return new SimpleCodeInfo(FileUtils.readFile((Path)this.mappingPath));
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to read mapping file: " + this.mappingPath.toAbsolutePath(), (Throwable)e);
        }
    }

    @Override
    public void save(String newContent) {
        try {
            FileUtils.writeFile((Path)this.mappingPath, (String)newContent);
            LOG.debug("Mapping saved: {}", (Object)this.mappingPath.toAbsolutePath());
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to write mapping file: " + this.mappingPath.toAbsolutePath(), (Throwable)e);
        }
    }

    @Override
    public JPopupMenu onTreePopupMenu(MainWindow mainWindow) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new SimpleMenuItem(NLS.str("popup.remove"), () -> mainWindow.getRenameMappings().closeMappingsAndRemoveFromProject()));
        return menu;
    }

    @Override
    public String getSyntaxName() {
        return "text/plain";
    }

    @Override
    public JClass getJParent() {
        return null;
    }

    public Icon getIcon() {
        return MAPPING_ICON;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String makeString() {
        return this.name;
    }

    @Override
    public String getTooltip() {
        return this.mappingPath.normalize().toAbsolutePath().toString();
    }
}

