/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.jobs;

import jadx.api.utils.tasks.ITaskExecutor;
import jadx.core.utils.tasks.TaskExecutor;
import jadx.gui.jobs.IBackgroundTask;
import jadx.gui.jobs.ITaskInfo;
import jadx.gui.jobs.TaskStatus;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class SimpleTask
implements IBackgroundTask {
    private final String title;
    private final List<Runnable> jobs;
    @Nullable
    private final Consumer<TaskStatus> onFinish;

    public SimpleTask(String title, Runnable run) {
        this(title, Collections.singletonList(run), null);
    }

    public SimpleTask(String title, Runnable run, Runnable onFinish) {
        this(title, Collections.singletonList(run), (TaskStatus s) -> onFinish.run());
    }

    public SimpleTask(String title, List<Runnable> jobs) {
        this(title, jobs, null);
    }

    public SimpleTask(String title, List<Runnable> jobs, @Nullable Consumer<TaskStatus> onFinish) {
        this.title = title;
        this.jobs = jobs;
        this.onFinish = onFinish;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public List<Runnable> getJobs() {
        return this.jobs;
    }

    @Nullable
    public Consumer<TaskStatus> getOnFinish() {
        return this.onFinish;
    }

    @Override
    public ITaskExecutor scheduleTasks() {
        TaskExecutor executor = new TaskExecutor();
        executor.addParallelTasks(this.jobs);
        return executor;
    }

    @Override
    public void onFinish(ITaskInfo taskInfo) {
        if (this.onFinish != null) {
            this.onFinish.accept(taskInfo.getStatus());
        }
    }

    @Override
    public boolean checkMemoryUsage() {
        return true;
    }

    @Override
    public boolean canBeCanceled() {
        return false;
    }

    @Override
    public boolean isCanceled() {
        return false;
    }

    @Override
    public void cancel() {
    }
}

