/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.device.debugger;

import jadx.core.dex.instructions.args.ArgType;
import jadx.gui.device.debugger.ArtAdapter;
import jadx.gui.device.debugger.DebugSettings;
import jadx.gui.device.debugger.SmaliDebugger;
import jadx.gui.device.debugger.smali.SmaliRegister;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegisterObserver {
    private Map<Long, List<Info>> infoMap;
    private final List<SmaliRegisterMapping> regList = new ArrayList<SmaliRegisterMapping>();
    private final ArtAdapter.IArtAdapter art;
    private final String mthFullID;
    private boolean hasDbgInfo = false;

    private RegisterObserver(ArtAdapter.IArtAdapter art, String mthFullID) {
        this.infoMap = Collections.emptyMap();
        this.art = art;
        this.mthFullID = mthFullID;
    }

    @NotNull
    public static RegisterObserver merge(List<SmaliDebugger.RuntimeVarInfo> rtRegs, List<SmaliRegister> smaliRegs, ArtAdapter.IArtAdapter art, String mthFullID) {
        RegisterObserver adapter = new RegisterObserver(art, mthFullID);
        boolean bl = adapter.hasDbgInfo = !rtRegs.isEmpty();
        if (adapter.hasDbgInfo) {
            adapter.infoMap = new HashMap<Long, List<Info>>();
        }
        for (SmaliRegister sr : smaliRegs) {
            adapter.regList.add(new SmaliRegisterMapping(sr));
        }
        adapter.regList.sort(Comparator.comparingInt(r -> r.getSmaliRegister().getRuntimeRegNum()));
        for (SmaliDebugger.RuntimeVarInfo rt : rtRegs) {
            ArgType at;
            SmaliRegisterMapping smaliRegMapping = adapter.getRegListEntry(rt.getRegNum());
            SmaliRegister smaliReg = smaliRegMapping.getSmaliRegister();
            smaliRegMapping.addRuntimeVarInfo(rt);
            String type = rt.getSignature();
            if (type.isEmpty()) {
                type = rt.getType();
            }
            if ((at = ArgType.parse((String)type)) != null) {
                type = at.toString();
            }
            Info load = new Info(smaliReg.getRegNum(), true, rt.getName(), type);
            Info unload = new Info(smaliReg.getRegNum(), false, null, null);
            adapter.infoMap.computeIfAbsent(Long.valueOf(rt.getStartOffset()), k -> new ArrayList()).add(load);
            adapter.infoMap.computeIfAbsent(Long.valueOf(rt.getEndOffset()), k -> new ArrayList()).add(unload);
        }
        return adapter;
    }

    @NotNull
    public List<SmaliRegister> getInitializedList(long codeOffset) {
        List<SmaliRegister> ret = Collections.emptyList();
        for (SmaliRegisterMapping smaliRegisterMapping : this.regList) {
            if (!smaliRegisterMapping.getSmaliRegister().isInitialized(codeOffset)) continue;
            if (ret.isEmpty()) {
                ret = new ArrayList<SmaliRegister>();
            }
            ret.add(smaliRegisterMapping.getSmaliRegister());
        }
        return ret;
    }

    @Nullable
    public SmaliDebugger.RuntimeVarInfo getInfo(int runtimeNum, long codeOffset) {
        SmaliRegisterMapping list = this.getRegListEntry(runtimeNum);
        for (SmaliDebugger.RuntimeVarInfo info : list.getRuntimeVarInfoList()) {
            if ((long)info.getStartOffset() > codeOffset) break;
            if (!info.isInitialized(codeOffset)) continue;
            return info;
        }
        return null;
    }

    private SmaliRegisterMapping getRegListEntry(int regNum) {
        try {
            return this.regList.get(regNum);
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeException(String.format("Register %d does not exist (size: %d).\n %s\n Method: %s", regNum, this.regList.size(), this.buildDeviceInfo(), this.mthFullID), e);
        }
    }

    private String buildDeviceInfo() {
        DebugSettings debugSettings = DebugSettings.INSTANCE;
        return "Device: " + debugSettings.getDevice().getDeviceInfo() + ", Android: " + debugSettings.getVer() + ", ArtAdapter: " + this.art.getClass().getSimpleName();
    }

    @NotNull
    public List<Info> getInfoAt(long codeOffset) {
        List<Info> list;
        if (this.hasDbgInfo && (list = this.infoMap.get(codeOffset)) != null) {
            return list;
        }
        return Collections.emptyList();
    }

    public static class Info {
        private final int smaliRegNum;
        private final boolean load;
        private final String name;
        private final String type;

        private Info(int smaliRegNum, boolean load, String name, String type) {
            this.smaliRegNum = smaliRegNum;
            this.load = load;
            this.name = name;
            this.type = type;
        }

        public int getSmaliRegNum() {
            return this.smaliRegNum;
        }

        public boolean isLoad() {
            return this.load;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }

    public static class SmaliRegisterMapping {
        private final SmaliRegister smaliRegister;
        private List<SmaliDebugger.RuntimeVarInfo> rtList = Collections.emptyList();

        public SmaliRegisterMapping(SmaliRegister smaliRegister) {
            this.smaliRegister = smaliRegister;
        }

        public SmaliRegister getSmaliRegister() {
            return this.smaliRegister;
        }

        @NotNull
        public List<SmaliDebugger.RuntimeVarInfo> getRuntimeVarInfoList() {
            return this.rtList;
        }

        public void addRuntimeVarInfo(SmaliDebugger.RuntimeVarInfo rt) {
            if (this.rtList.isEmpty()) {
                this.rtList = new ArrayList<SmaliDebugger.RuntimeVarInfo>();
            }
            this.rtList.add(rt);
        }
    }
}

