/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.cache.code.disk.adapters;

import jadx.core.dex.instructions.args.ArgType;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.cache.code.disk.adapters.DataAdapter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ArgTypeAdapter
implements DataAdapter<ArgType> {
    public static final ArgTypeAdapter INSTANCE = new ArgTypeAdapter();

    @Override
    public void write(DataOutput out, ArgType value) throws IOException {
        if (value == null) {
            this.writeType(out, Types.NULL);
            return;
        }
        if (!value.isTypeKnown()) {
            this.writeType(out, Types.UNKNOWN);
            return;
        }
        if (value.isPrimitive()) {
            this.writeType(out, Types.PRIMITIVE);
            out.writeByte(value.getPrimitiveType().getShortName().charAt(0));
            return;
        }
        if (value.getOuterType() != null) {
            this.writeType(out, Types.OUTER_GENERIC);
            this.write(out, value.getOuterType());
            this.write(out, value.getInnerType());
            return;
        }
        if (value.getWildcardType() != null) {
            this.writeType(out, Types.WILDCARD);
            ArgType.WildcardBound bound = value.getWildcardBound();
            out.writeByte(bound.getNum());
            if (bound != ArgType.WildcardBound.UNBOUND) {
                this.write(out, value.getWildcardType());
            }
            return;
        }
        if (value.isGeneric()) {
            this.writeType(out, Types.GENERIC);
            out.writeUTF(value.getObject());
            this.writeTypesList(out, value.getGenericTypes());
            return;
        }
        if (value.isGenericType()) {
            this.writeType(out, Types.TYPE_VARIABLE);
            out.writeUTF(value.getObject());
            this.writeTypesList(out, value.getExtendTypes());
            return;
        }
        if (value.isObject()) {
            this.writeType(out, Types.OBJECT);
            out.writeUTF(value.getObject());
            return;
        }
        if (value.isArray()) {
            this.writeType(out, Types.ARRAY);
            out.writeByte(value.getArrayDimension());
            this.write(out, value.getArrayRootElement());
            return;
        }
        throw new JadxRuntimeException("Cannot save type: " + value + ", cls: " + value.getClass());
    }

    private void writeType(DataOutput out, Types type) throws IOException {
        out.writeByte(type.ordinal());
    }

    @Override
    public ArgType read(DataInput in) throws IOException {
        byte typeOrdinal = in.readByte();
        Types type = Types.values()[typeOrdinal];
        switch (type) {
            case NULL: {
                return null;
            }
            case UNKNOWN: {
                return ArgType.UNKNOWN;
            }
            case PRIMITIVE: {
                char shortName = (char)in.readByte();
                return ArgType.parse((char)shortName);
            }
            case OUTER_GENERIC: {
                ArgType outerType = this.read(in);
                ArgType innerType = this.read(in);
                return ArgType.outerGeneric((ArgType)outerType, (ArgType)innerType);
            }
            case WILDCARD: {
                ArgType.WildcardBound bound = ArgType.WildcardBound.getByNum((int)in.readByte());
                if (bound == ArgType.WildcardBound.UNBOUND) {
                    return ArgType.WILDCARD;
                }
                ArgType objType = this.read(in);
                return ArgType.wildcard((ArgType)objType, (ArgType.WildcardBound)bound);
            }
            case GENERIC: {
                String clsType = in.readUTF();
                return ArgType.generic((String)clsType, this.readTypesList(in));
            }
            case TYPE_VARIABLE: {
                String typeVar = in.readUTF();
                List<ArgType> extendTypes = this.readTypesList(in);
                return ArgType.genericType((String)typeVar, extendTypes);
            }
            case OBJECT: {
                return ArgType.object((String)in.readUTF());
            }
            case ARRAY: {
                byte dim = in.readByte();
                ArgType rootType = this.read(in);
                return ArgType.array((ArgType)rootType, (int)dim);
            }
        }
        throw new RuntimeException("Unexpected arg type: " + type);
    }

    private void writeTypesList(DataOutput out, List<ArgType> types) throws IOException {
        out.writeByte(types.size());
        for (ArgType type : types) {
            this.write(out, type);
        }
    }

    private List<ArgType> readTypesList(DataInput in) throws IOException {
        int size = in.readByte();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<ArgType> list = new ArrayList<ArgType>(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.read(in));
        }
        return list;
    }

    private static enum Types {
        NULL,
        UNKNOWN,
        PRIMITIVE,
        ARRAY,
        OBJECT,
        WILDCARD,
        GENERIC,
        TYPE_VARIABLE,
        OUTER_GENERIC;

    }
}

