/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.tools;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NLSAddNewLines {
    private static final Logger LOG = LoggerFactory.getLogger(NLSAddNewLines.class);
    private static final Path I18N_PATH = Paths.get("src/main/resources/i18n/", new String[0]);
    private static final String GUI_MODULE_DIR = "jadx-gui";

    public static void main(String[] args) {
        try {
            NLSAddNewLines.process();
        }
        catch (Exception e) {
            LOG.error("Failed to add new i18n lines", (Throwable)e);
        }
    }

    private static void process() throws Exception {
        String reference = "Messages_en_US.properties";
        Path refPath = NLSAddNewLines.getRefPath(reference);
        List<String> refLines = Files.readAllLines(refPath);
        try (Stream<Path> pathStream = Files.list(refPath.toAbsolutePath().getParent());){
            pathStream.forEach(path -> {
                if (path.getFileName().equals(refPath.getFileName())) {
                    return;
                }
                try {
                    NLSAddNewLines.applyFix(refLines, path);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private static void applyFix(List<String> refLines, Path path) throws IOException {
        List<String> lines = Files.readAllLines(path);
        int linesCount = lines.size();
        boolean updated = false;
        for (int i = 0; i < linesCount; ++i) {
            String line = lines.get(i);
            String refLine = refLines.get(i);
            if (NLSAddNewLines.isSameKey(refLine, line)) {
                if (!line.startsWith("#") || !line.endsWith("=")) continue;
                lines.set(i, "#" + refLine);
                updated = true;
                continue;
            }
            if (refLine.isEmpty()) {
                lines.add(i, "");
            } else {
                lines.add(i, "#" + refLine);
            }
            updated = true;
        }
        if (updated) {
            LOG.info("Updating {}", (Object)path);
            Files.write(path, lines, StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }

    private static boolean isSameKey(String refLine, String line) {
        char ch;
        int pos;
        int refLen = refLine.length();
        int len = line.length();
        if (refLen == 0) {
            return len == 0;
        }
        if (len == 0) {
            return false;
        }
        for (pos = 0; pos < len && ((ch = line.charAt(pos)) == '#' || ch == ' '); ++pos) {
        }
        int refPos = 0;
        char refCh;
        while ((refCh = refLine.charAt(refPos)) != ' ' && refCh != '=') {
            char ch2 = line.charAt(pos);
            if (refCh != ch2) {
                return false;
            }
            ++refPos;
            ++pos;
        }
        return true;
    }

    private static Path getRefPath(String reference) {
        Path path = I18N_PATH.resolve(reference);
        if (Files.exists(path, new LinkOption[0])) {
            return path;
        }
        Path rootPath = Paths.get(GUI_MODULE_DIR, new String[0]).resolve(I18N_PATH).resolve(reference);
        if (Files.exists(rootPath, new LinkOption[0])) {
            return rootPath;
        }
        throw new RuntimeException("Can't find reference I18N: " + reference);
    }
}

