/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.update;

import com.google.gson.Gson;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import jadx.api.JadxDecompiler;
import jadx.core.Jadx;
import jadx.core.plugins.versions.VersionComparator;
import jadx.gui.settings.JadxUpdateChannel;
import jadx.gui.update.Artifact;
import jadx.gui.update.ArtifactList;
import jadx.gui.update.IUpdateCallback;
import jadx.gui.update.Release;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0002J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0002J/\u0010\u0016\u001a\u0004\u0018\u0001H\u0017\"\b\b\u0000\u0010\u0017*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00072\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001aH\u0002\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ljadx/gui/update/JadxUpdate;", "", "<init>", "()V", "log", "Lio/github/oshai/kotlinlogging/KLogger;", "JADX_ARTIFACTS_URL", "", "JADX_RELEASES_URL", "GITHUB_API_URL", "GITHUB_LATEST_ARTIFACTS_URL", "GITHUB_LATEST_RELEASE_URL", "check", "", "updateChannel", "Ljadx/gui/settings/JadxUpdateChannel;", "callback", "Ljadx/gui/update/IUpdateCallback;", "checkForNewRelease", "Ljadx/gui/update/Release;", "checkForNewStableRelease", "checkForNewUnstableRelease", "getAndParse", "T", "url", "klass", "Lkotlin/reflect/KClass;", "(Ljava/lang/String;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "jadx-gui"})
@SourceDebugExtension(value={"SMAP\nJadxUpdate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JadxUpdate.kt\njadx/gui/update/JadxUpdate\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 File.kt\norg/jetbrains/kotlin/konan/file/FileKt\n*L\n1#1,113:1\n774#2:114\n865#2,2:115\n212#3,3:117\n212#3,13:120\n223#3,2:133\n215#3,7:135\n*S KotlinDebug\n*F\n+ 1 JadxUpdate.kt\njadx/gui/update/JadxUpdate\n*L\n91#1:114\n91#1:115,2\n106#1:117,3\n107#1:120,13\n106#1:133,2\n106#1:135,7\n*E\n"})
public final class JadxUpdate {
    @NotNull
    public static final JadxUpdate INSTANCE = new JadxUpdate();
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger(JadxUpdate::log$lambda$0);
    @NotNull
    public static final String JADX_ARTIFACTS_URL = "https://nightly.link/skylot/jadx/workflows/build-artifacts/master";
    @NotNull
    public static final String JADX_RELEASES_URL = "https://github.com/skylot/jadx/releases";
    @NotNull
    private static final String GITHUB_API_URL = "https://api.github.com/repos/skylot/jadx";
    @NotNull
    private static final String GITHUB_LATEST_ARTIFACTS_URL = "https://api.github.com/repos/skylot/jadx/actions/artifacts?per_page=5&page=1";
    @NotNull
    private static final String GITHUB_LATEST_RELEASE_URL = "https://api.github.com/repos/skylot/jadx/releases/latest";

    private JadxUpdate() {
    }

    @JvmStatic
    public static final void check(@NotNull JadxUpdateChannel updateChannel, @NotNull IUpdateCallback callback) {
        Thread thread;
        Intrinsics.checkNotNullParameter((Object)((Object)updateChannel), (String)"updateChannel");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Thread $this$check_u24lambda_u243 = thread = new Thread(() -> JadxUpdate.check$lambda$2(updateChannel, callback));
        boolean bl = false;
        $this$check_u24lambda_u243.setName("Jadx update thread");
        $this$check_u24lambda_u243.setPriority(1);
        $this$check_u24lambda_u243.start();
    }

    private final Release checkForNewRelease(JadxUpdateChannel updateChannel) {
        Release release;
        if (Jadx.isDevVersion()) {
            log.debug(JadxUpdate::checkForNewRelease$lambda$4);
            return null;
        }
        log.info(() -> JadxUpdate.checkForNewRelease$lambda$5(updateChannel));
        switch (WhenMappings.$EnumSwitchMapping$0[updateChannel.ordinal()]) {
            case 1: {
                release = this.checkForNewStableRelease();
                break;
            }
            case 2: {
                release = this.checkForNewUnstableRelease();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return release;
    }

    private final Release checkForNewStableRelease() {
        String currentVersion = JadxDecompiler.getVersion();
        Intrinsics.checkNotNull((Object)currentVersion);
        if (StringsKt.startsWith$default((String)currentVersion, (String)"r", (boolean)false, (int)2, null)) {
            log.info(JadxUpdate::checkForNewStableRelease$lambda$6);
            return null;
        }
        Release release = (Release)this.getAndParse(GITHUB_LATEST_RELEASE_URL, Reflection.getOrCreateKotlinClass(Release.class));
        if (release == null) {
            return null;
        }
        Release latestRelease = release;
        if (VersionComparator.checkAndCompare((String)currentVersion, (String)latestRelease.getName()) >= 0) {
            return null;
        }
        log.info(() -> JadxUpdate.checkForNewStableRelease$lambda$7(latestRelease));
        return latestRelease;
    }

    /*
     * WARNING - void declaration
     */
    private final Release checkForNewUnstableRelease() {
        Collection destination$iv$iv;
        List<Artifact> list;
        ArtifactList artifactList = (ArtifactList)this.getAndParse(GITHUB_LATEST_ARTIFACTS_URL, Reflection.getOrCreateKotlinClass(ArtifactList.class));
        if (artifactList != null && (list = artifactList.getArtifacts()) != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = list;
            boolean $i$f$filter = false;
            void var6_5 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Artifact it = (Artifact)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getWorkflowRun().getBranch(), (Object)"master")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
        } else {
            return null;
        }
        List artifacts = (List)destination$iv$iv;
        if (artifacts.isEmpty()) {
            return null;
        }
        String latestVersion = StringsKt.substringBefore$default((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)((Artifact)artifacts.get(0)).getName(), (CharSequence)"jadx-gui-"), (CharSequence)"jadx-"), (char)'-', null, (int)2, null);
        if (VersionComparator.checkAndCompare((String)JadxDecompiler.getVersion(), (String)latestVersion) >= 0) {
            return null;
        }
        log.info(() -> JadxUpdate.checkForNewUnstableRelease$lambda$9(latestVersion));
        return new Release(latestVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T getAndParse(String url, KClass<T> klass) {
        Object stream;
        HttpURLConnection con;
        URLConnection uRLConnection = new URI(url).toURL().openConnection();
        HttpURLConnection httpURLConnection = con = uRLConnection instanceof HttpURLConnection ? (HttpURLConnection)uRLConnection : null;
        if (con == null || con.getResponseCode() != 200) {
            return null;
        }
        AutoCloseable $this$use$iv = con.getInputStream();
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            Object reader;
            stream = (InputStream)$this$use$iv;
            boolean bl = false;
            AutoCloseable $this$use$iv2 = new InputStreamReader((InputStream)stream);
            boolean $i$f$use2 = false;
            boolean closed$iv2 = false;
            try {
                reader = (InputStreamReader)$this$use$iv2;
                boolean bl2 = false;
                reader = new Gson().fromJson((Reader)reader, JvmClassMappingKt.getJavaClass(klass));
            }
            catch (Exception e$iv) {
                try {
                    closed$iv2 = true;
                    try {
                        $this$use$iv2.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw e$iv;
                }
                catch (Throwable throwable) {
                    if (!closed$iv2) {
                        $this$use$iv2.close();
                    }
                    throw throwable;
                }
            }
            $this$use$iv2.close();
            stream = reader;
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                throw throwable;
            }
        }
        AutoCloseable autoCloseable = $this$use$iv;
        if (autoCloseable != null) {
            autoCloseable.close();
        }
        return (T)stream;
    }

    private static final Unit log$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object check$lambda$2$lambda$1() {
        return "Jadx update error";
    }

    private static final void check$lambda$2(JadxUpdateChannel $updateChannel, IUpdateCallback $callback) {
        try {
            Release release = INSTANCE.checkForNewRelease($updateChannel);
            if (release != null) {
                $callback.onUpdate(release);
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e, JadxUpdate::check$lambda$2$lambda$1);
        }
    }

    private static final Object checkForNewRelease$lambda$4() {
        return "Ignore check for update: development version";
    }

    private static final Object checkForNewRelease$lambda$5(JadxUpdateChannel $updateChannel) {
        return "Checking for updates... Update channel: " + $updateChannel + ", current version: " + JadxDecompiler.getVersion();
    }

    private static final Object checkForNewStableRelease$lambda$6() {
        return "Skip update check: can't compare unstable and stable versions";
    }

    private static final Object checkForNewStableRelease$lambda$7(Release $latestRelease) {
        return "Found new jadx version: " + $latestRelease.getName();
    }

    private static final Object checkForNewUnstableRelease$lambda$9(String $latestVersion) {
        return "Found new unstable version: " + $latestVersion;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JadxUpdateChannel.values().length];
            try {
                nArray[JadxUpdateChannel.STABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JadxUpdateChannel.UNSTABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

