/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.tab.dnd;

import jadx.gui.settings.JadxSettings;
import jadx.gui.ui.tab.TabbedPane;
import jadx.gui.ui.tab.dnd.TabDndGestureListener;
import jadx.gui.ui.tab.dnd.TabDndGhostPane;
import jadx.gui.ui.tab.dnd.TabDndTargetListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.image.BufferedImage;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.metal.MetalTabbedPaneUI;

public class TabDndController {
    private final transient JTabbedPane pane;
    private static final int DROP_TARGET_MARK_SIZE = 4;
    private static final int SCROLL_AREA_SIZE = 30;
    private static final int SCROLL_AREA_EXTRA = 30;
    private static final String ACTION_SCROLL_FORWARD = "scrollTabsForwardAction";
    private static final String ACTION_SCROLL_BACKWARD = "scrollTabsBackwardAction";
    private final transient TabDndGhostPane tabDndGhostPane;
    protected int dragTabIndex = -1;
    protected boolean drawGhost = true;
    protected boolean paintScrollTriggerAreas = false;
    protected Rectangle rectBackward = new Rectangle();
    protected Rectangle rectForward = new Rectangle();
    private boolean isDragging = false;

    public TabDndController(TabbedPane pane, JadxSettings settings) {
        pane.setDnd(this);
        this.pane = pane;
        this.tabDndGhostPane = new TabDndGhostPane(this, settings);
        new DropTarget(this.tabDndGhostPane, 3, new TabDndTargetListener(this), true);
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(pane, 3, new TabDndGestureListener(this));
    }

    public static boolean isHorizontalTabPlacement(int tabPlacement) {
        return tabPlacement == 1 || tabPlacement == 3;
    }

    public void scrollIfNeeded(Point glassPt) {
        Rectangle r = this.getTabAreaBounds();
        boolean isHorizontal = TabDndController.isHorizontalTabPlacement(this.pane.getTabPlacement());
        if (isHorizontal) {
            this.rectForward.setBounds(r.x + r.width - 30 - 30, r.y, 60, r.height);
        } else {
            this.rectForward.setBounds(r.x, r.y + r.height - 30 - 30, r.width, 60);
        }
        this.rectForward = SwingUtilities.convertRectangle(this.pane.getParent(), this.rectForward, this.tabDndGhostPane);
        if (this.rectForward.contains(glassPt)) {
            this.clickScrollButton(ACTION_SCROLL_FORWARD);
        }
        if (isHorizontal) {
            this.rectBackward.setBounds(r.x, r.y, 30, r.height);
        } else {
            this.rectBackward.setBounds(r.x, r.y, r.width, 30);
        }
        this.rectBackward = SwingUtilities.convertRectangle(this.pane.getParent(), this.rectBackward, this.tabDndGhostPane);
        if (this.rectBackward.contains(glassPt)) {
            this.clickScrollButton(ACTION_SCROLL_BACKWARD);
        }
    }

    private void clickScrollButton(String actionKey) {
        Component scrollButton;
        Component forwardButton = null;
        Component backwardButton = null;
        for (Component c : this.pane.getComponents()) {
            if (!(c instanceof JButton)) continue;
            if (Objects.isNull(forwardButton)) {
                forwardButton = (JButton)c;
                continue;
            }
            backwardButton = (JButton)c;
            break;
        }
        Component component = scrollButton = ACTION_SCROLL_FORWARD.equals(actionKey) ? forwardButton : backwardButton;
        if (scrollButton != null && scrollButton.isEnabled()) {
            ((AbstractButton)scrollButton).doClick();
        }
    }

    protected int getTargetTabIndex(Point glassPt) {
        Point tabPt = SwingUtilities.convertPoint(this.tabDndGhostPane, glassPt, this.pane);
        boolean isHorizontal = TabDndController.isHorizontalTabPlacement(this.pane.getTabPlacement());
        for (int i = 0; i < this.pane.getTabCount(); ++i) {
            Rectangle r = this.pane.getBoundsAt(i);
            if (isHorizontal) {
                r.width = r.width / 2 + 1;
            } else {
                r.height = r.height / 2 + 1;
            }
            if (r.contains(tabPt)) {
                return i;
            }
            if (isHorizontal) {
                r.x += r.width;
            } else {
                r.y += r.height;
            }
            if (!r.contains(tabPt)) continue;
            return i + 1;
        }
        int count = this.pane.getTabCount();
        if (count == 0) {
            return -1;
        }
        Rectangle lastRect = this.pane.getBoundsAt(count - 1);
        Point d = isHorizontal ? new Point(1, 0) : new Point(0, 1);
        lastRect.translate(lastRect.width * d.x, lastRect.height * d.y);
        return lastRect.contains(tabPt) ? count : -1;
    }

    protected void swapTabs(int oldIdx, int newIdx) {
        if (newIdx < 0 || oldIdx == newIdx) {
            return;
        }
        Component cmp = this.pane.getComponentAt(oldIdx);
        Component tab = this.pane.getTabComponentAt(oldIdx);
        String title = this.pane.getTitleAt(oldIdx);
        Icon icon = this.pane.getIconAt(oldIdx);
        String tip = this.pane.getToolTipTextAt(oldIdx);
        boolean isEnabled = this.pane.isEnabledAt(oldIdx);
        newIdx = oldIdx > newIdx ? newIdx : newIdx - 1;
        this.pane.remove(oldIdx);
        this.pane.insertTab(title, icon, cmp, tip, newIdx);
        this.pane.setEnabledAt(newIdx, isEnabled);
        if (isEnabled) {
            this.pane.setSelectedIndex(newIdx);
        }
        this.pane.setTabComponentAt(newIdx, tab);
    }

    protected void updateTargetMark(int tabIdx) {
        boolean isSideNeighbor;
        boolean bl = isSideNeighbor = tabIdx < 0 || this.dragTabIndex == tabIdx || tabIdx == this.dragTabIndex + 1;
        if (isSideNeighbor) {
            this.tabDndGhostPane.setTargetRect(0, 0, 0, 0);
            return;
        }
        Rectangle boundsRect = this.pane.getBoundsAt(Math.max(0, tabIdx - 1));
        Rectangle r = SwingUtilities.convertRectangle(this.pane, boundsRect, this.tabDndGhostPane);
        int a = Math.min(tabIdx, 1);
        if (TabDndController.isHorizontalTabPlacement(this.pane.getTabPlacement())) {
            this.tabDndGhostPane.setTargetRect(r.x + r.width * a - 2, r.y, 4, r.height);
        } else {
            this.tabDndGhostPane.setTargetRect(r.x, r.y + r.height * a - 2, r.width, 4);
        }
    }

    protected void initGlassPane(Point tabPt) {
        this.pane.getRootPane().setGlassPane(this.tabDndGhostPane);
        if (this.drawGhost) {
            Component c = this.pane.getTabComponentAt(this.dragTabIndex);
            if (c == null) {
                return;
            }
            Dimension d = c.getPreferredSize();
            switch (this.tabDndGhostPane.getGhostType()) {
                case IMAGE: {
                    GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    GraphicsDevice device = env.getDefaultScreenDevice();
                    GraphicsConfiguration config = device.getDefaultConfiguration();
                    BufferedImage image = config.createCompatibleImage(d.width, d.height, 3);
                    Graphics2D g2 = image.createGraphics();
                    SwingUtilities.paintComponent(g2, c, this.tabDndGhostPane, 0, 0, d.width, d.height);
                    g2.dispose();
                    this.tabDndGhostPane.setGhostImage(image);
                    this.pane.setTabComponentAt(this.dragTabIndex, c);
                    break;
                }
                case OUTLINE: {
                    this.tabDndGhostPane.setGhostSize(d);
                    break;
                }
            }
        }
        Point glassPt = SwingUtilities.convertPoint(this.pane, tabPt, this.tabDndGhostPane);
        this.tabDndGhostPane.setPoint(glassPt);
        this.tabDndGhostPane.setVisible(true);
    }

    protected Rectangle getTabAreaBounds() {
        Rectangle tabbedRect = this.pane.getBounds();
        Rectangle compRect = this.pane.getSelectedComponent() != null ? this.pane.getSelectedComponent().getBounds() : new Rectangle();
        int tabPlacement = this.pane.getTabPlacement();
        if (TabDndController.isHorizontalTabPlacement(tabPlacement)) {
            tabbedRect.height -= compRect.height;
            if (tabPlacement == 3) {
                tabbedRect.y += compRect.y + compRect.height;
            }
        } else {
            tabbedRect.width -= compRect.width;
            if (tabPlacement == 4) {
                tabbedRect.x += compRect.x + compRect.width;
            }
        }
        tabbedRect.grow(2, 2);
        return tabbedRect;
    }

    public void onPaintGlassPane(Graphics2D g) {
        boolean isScrollLayout;
        boolean bl = isScrollLayout = this.pane.getTabLayoutPolicy() == 1;
        if (isScrollLayout && this.paintScrollTriggerAreas) {
            g.setPaint(this.tabDndGhostPane.getColor());
            g.fill(this.rectBackward);
            g.fill(this.rectForward);
        }
    }

    public boolean onStartDrag(Point pt) {
        this.setDragging(true);
        int idx = this.pane.indexAtLocation(pt.x, pt.y);
        int selIdx = this.pane.getSelectedIndex();
        boolean isTabRunsRotated = !(this.pane.getUI() instanceof MetalTabbedPaneUI) && this.pane.getTabLayoutPolicy() == 0 && idx != selIdx;
        int n = this.dragTabIndex = isTabRunsRotated ? selIdx : idx;
        if (this.dragTabIndex >= 0 && this.pane.isEnabledAt(this.dragTabIndex)) {
            this.initGlassPane(pt);
            return true;
        }
        return false;
    }

    public void loadSettings() {
        this.tabDndGhostPane.loadSettings();
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public void setDragging(boolean dragging) {
        this.isDragging = dragging;
    }

    public TabDndGhostPane getDndGhostPane() {
        return this.tabDndGhostPane;
    }
}

