/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.tab;

import jadx.api.JavaClass;
import jadx.api.metadata.ICodeAnnotation;
import jadx.api.metadata.ICodeNodeRef;
import jadx.api.metadata.annotations.NodeDeclareRef;
import jadx.gui.jobs.SimpleTask;
import jadx.gui.jobs.TaskStatus;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.EditorViewState;
import jadx.gui.ui.tab.ITabStatesListener;
import jadx.gui.ui.tab.TabBlueprint;
import jadx.gui.utils.JumpPosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabsController {
    private static final Logger LOG = LoggerFactory.getLogger(TabsController.class);
    private final MainWindow mainWindow;
    private final Map<JNode, TabBlueprint> tabsMap = new HashMap<JNode, TabBlueprint>();
    private final List<ITabStatesListener> listeners = new ArrayList<ITabStatesListener>();
    private boolean forceClose;
    @Nullable
    private TabBlueprint selectedTab;

    public TabsController(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }

    public MainWindow getMainWindow() {
        return this.mainWindow;
    }

    public void addListener(ITabStatesListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ITabStatesListener listener) {
        this.listeners.remove(listener);
    }

    @Nullable
    public TabBlueprint getTabByNode(JNode node) {
        return this.tabsMap.get(node);
    }

    public TabBlueprint openTab(JNode node) {
        return this.openTab(node, false);
    }

    public TabBlueprint openTab(JNode node, boolean hidden) {
        TabBlueprint blueprint = this.getTabByNode(node);
        if (blueprint == null) {
            TabBlueprint newBlueprint = new TabBlueprint(node);
            this.tabsMap.put(node, newBlueprint);
            newBlueprint.setHidden(hidden);
            this.listeners.forEach(l -> l.onTabOpen(newBlueprint));
            if (hidden) {
                this.listeners.forEach(l -> l.onTabVisibilityChange(newBlueprint));
            }
            blueprint = newBlueprint;
        }
        this.setTabHiddenInternal(blueprint, hidden);
        return blueprint;
    }

    public void selectTab(JNode node) {
        TabBlueprint blueprint;
        this.selectedTab = blueprint = this.openTab(node);
        this.listeners.forEach(l -> l.onTabSelect(blueprint));
    }

    public void codeJump(JNode node) {
        JClass parentCls = node.getJParent();
        if (parentCls != null) {
            JavaClass cls = node.getJParent().getCls();
            JavaClass origTopCls = cls.getOriginalTopParentClass();
            JavaClass codeParent = cls.getTopParentClass();
            if (!Objects.equals(codeParent, origTopCls)) {
                JClass jumpCls = this.mainWindow.getCacheObject().getNodeCache().makeFrom(codeParent);
                this.loadCodeWithUIAction(jumpCls, () -> this.jumpToInnerClass(node, codeParent, jumpCls));
                return;
            }
        }
        if (node.getPos() > 0) {
            this.codeJump(new JumpPosition(node));
            return;
        }
        if (node.getRootClass() == null) {
            this.selectTab(node);
            return;
        }
        this.loadCodeWithUIAction(node.getRootClass(), () -> this.codeJump(new JumpPosition(node)));
    }

    private void loadCodeWithUIAction(JClass cls, Runnable action) {
        SimpleTask loadTask = cls.getLoadTask();
        this.mainWindow.getBackgroundExecutor().execute(new SimpleTask(loadTask.getTitle(), loadTask.getJobs(), status -> {
            Consumer<TaskStatus> onFinish = loadTask.getOnFinish();
            if (onFinish != null) {
                onFinish.accept((TaskStatus)((Object)status));
            }
            action.run();
        }));
    }

    private void jumpToInnerClass(JNode node, JavaClass codeParent, JClass jumpCls) {
        codeParent.getCodeInfo().getCodeMetadata().searchDown(0, (pos, ann) -> {
            ICodeNodeRef declNode;
            if (ann.getAnnType() == ICodeAnnotation.AnnType.DECLARATION && (declNode = ((NodeDeclareRef)ann).getNode()).equals(node.getJavaNode().getCodeNodeRef())) {
                this.codeJump(new JumpPosition(jumpCls, (int)pos));
                return true;
            }
            return null;
        });
    }

    public void codeJump(JumpPosition pos) {
        if (this.selectedTab == null || this.selectedTab.getNode() != pos.getNode()) {
            this.selectTab(pos.getNode());
        }
        this.listeners.forEach(l -> l.onTabCodeJump(this.selectedTab, pos));
    }

    public void smaliJump(JClass cls, int pos, boolean debugMode) {
        this.selectTab(cls);
        TabBlueprint blueprint = this.getTabByNode(cls);
        this.listeners.forEach(l -> l.onTabSmaliJump(blueprint, pos, debugMode));
    }

    public void closeTab(JNode node) {
        this.closeTab(node, false);
    }

    public void closeTab(JNode node, boolean considerPins) {
        TabBlueprint blueprint = this.getTabByNode(node);
        if (blueprint != null) {
            this.closeTab(blueprint, considerPins);
        }
    }

    public void closeTab(TabBlueprint blueprint, boolean considerPins) {
        if (this.forceClose) {
            this.closeTabForce(blueprint);
            return;
        }
        if (!considerPins || !blueprint.isPinned()) {
            if (!blueprint.isReferenced()) {
                this.closeTabForce(blueprint);
            } else {
                this.closeTabSoft(blueprint);
            }
        }
    }

    private void closeTabForce(TabBlueprint blueprint) {
        this.listeners.forEach(l -> l.onTabClose(blueprint));
        this.tabsMap.remove(blueprint.getNode());
    }

    private void closeTabSoft(TabBlueprint blueprint) {
        this.setTabHidden(blueprint.getNode(), true);
    }

    public void setTabPositionFirst(JNode node) {
        TabBlueprint blueprint = this.openTab(node);
        this.listeners.forEach(l -> l.onTabPositionFirst(blueprint));
    }

    public void setTabPinned(JNode node, boolean pinned) {
        TabBlueprint blueprint = this.openTab(node);
        this.setTabPinnedInternal(blueprint, pinned);
    }

    public void setTabPinnedInternal(TabBlueprint blueprint, boolean pinned) {
        if (blueprint.isPinned() != pinned) {
            blueprint.setPinned(pinned);
            this.listeners.forEach(l -> l.onTabPinChange(blueprint));
        }
    }

    public void setTabBookmarked(JNode node, boolean bookmarked) {
        TabBlueprint blueprint = this.openTab(node);
        this.setTabBookmarkedInternal(blueprint, bookmarked);
    }

    private void setTabBookmarkedInternal(TabBlueprint blueprint, boolean bookmarked) {
        if (blueprint.isBookmarked() != bookmarked) {
            blueprint.setBookmarked(bookmarked);
            this.listeners.forEach(l -> l.onTabBookmarkChange(blueprint));
            this.removeTabIfNotReferenced(blueprint);
        }
    }

    public void setTabHidden(JNode node, boolean hidden) {
        TabBlueprint blueprint = this.getTabByNode(node);
        this.setTabHiddenInternal(blueprint, hidden);
    }

    private void setTabHiddenInternal(TabBlueprint blueprint, boolean hidden) {
        if (blueprint != null && blueprint.isHidden() != hidden) {
            blueprint.setHidden(hidden);
            this.listeners.forEach(l -> l.onTabVisibilityChange(blueprint));
        }
    }

    private void removeTabIfNotReferenced(TabBlueprint blueprint) {
        if (blueprint.isHidden() && !blueprint.isReferenced()) {
            this.tabsMap.remove(blueprint.getNode());
        }
    }

    public void closeAllTabs() {
        this.closeAllTabs(false);
    }

    public void forceCloseAllTabs() {
        this.forceClose = true;
        this.closeAllTabs();
        this.forceClose = false;
        this.selectedTab = null;
    }

    public boolean isForceClose() {
        return this.forceClose;
    }

    public void closeAllTabs(boolean considerPins) {
        List.copyOf(this.tabsMap.values()).forEach(t -> this.closeTab(t.getNode(), considerPins));
    }

    public void unpinAllTabs() {
        this.tabsMap.values().forEach(t -> this.setTabPinned(t.getNode(), false));
    }

    public void unbookmarkAllTabs() {
        this.tabsMap.values().forEach(t -> this.setTabBookmarked(t.getNode(), false));
    }

    public TabBlueprint getSelectedTab() {
        return this.selectedTab;
    }

    public List<TabBlueprint> getTabs() {
        return List.copyOf(this.tabsMap.values());
    }

    public List<TabBlueprint> getOpenTabs() {
        return List.copyOf(this.tabsMap.values());
    }

    public List<TabBlueprint> getPinnedTabs() {
        return this.tabsMap.values().stream().filter(TabBlueprint::isPinned).collect(Collectors.toUnmodifiableList());
    }

    public List<TabBlueprint> getBookmarkedTabs() {
        return this.tabsMap.values().stream().filter(TabBlueprint::isBookmarked).collect(Collectors.toUnmodifiableList());
    }

    public void restoreEditorViewState(EditorViewState viewState) {
        JNode node = viewState.getNode();
        TabBlueprint blueprint = this.openTab(node, viewState.isHidden());
        this.setTabPinnedInternal(blueprint, viewState.isPinned());
        this.setTabBookmarkedInternal(blueprint, viewState.isBookmarked());
        this.listeners.forEach(l -> l.onTabRestore(blueprint, viewState));
        if (viewState.isActive()) {
            this.selectTab(node);
        }
    }

    public void notifyRestoreEditorViewStateDone() {
        if (this.selectedTab == null && !this.tabsMap.isEmpty()) {
            JNode node = this.tabsMap.values().iterator().next().getNode();
            LOG.warn("No active tab found, select {}", (Object)node);
            this.selectTab(node);
        }
        this.listeners.forEach(ITabStatesListener::onTabsRestoreDone);
    }

    public List<EditorViewState> getEditorViewStates() {
        ArrayList<TabBlueprint> reorderedTabs = new ArrayList<TabBlueprint>(this.tabsMap.values());
        this.listeners.forEach(l -> l.onTabsReorder(reorderedTabs));
        ArrayList<EditorViewState> states = new ArrayList<EditorViewState>();
        for (TabBlueprint blueprint : reorderedTabs) {
            states.add(this.getEditorViewState(blueprint));
        }
        return states;
    }

    public EditorViewState getEditorViewState(TabBlueprint blueprint) {
        EditorViewState viewState = new EditorViewState(blueprint.getNode());
        this.listeners.forEach(l -> l.onTabSave(blueprint, viewState));
        viewState.setActive(blueprint == this.selectedTab);
        viewState.setPinned(blueprint.isPinned());
        viewState.setBookmarked(blueprint.isBookmarked());
        viewState.setHidden(blueprint.isHidden());
        return viewState;
    }
}

