/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.popupmenu;

import jadx.api.ResourceFile;
import jadx.api.ResourcesLoader;
import jadx.api.plugins.utils.CommonFileUtils;
import jadx.gui.treemodel.JResource;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.filedialog.FileDialogWrapper;
import jadx.gui.ui.filedialog.FileOpenMode;
import jadx.gui.utils.NLS;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JResourcePopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = -7781009781149260806L;
    private static final Logger LOG = LoggerFactory.getLogger(JResourcePopupMenu.class);
    private final transient MainWindow mainWindow;

    public JResourcePopupMenu(MainWindow mainWindow, JResource resource) {
        this.mainWindow = mainWindow;
        if (resource.getType() != JResource.JResType.ROOT) {
            this.add(this.makeExportMenuItem(resource));
        }
    }

    private JMenuItem makeExportMenuItem(JResource resource) {
        JMenuItem exportMenu = new JMenuItem(NLS.str("popup.export"));
        exportMenu.addActionListener(event -> {
            Path savePath = null;
            switch (resource.getType()) {
                case ROOT: 
                case DIR: {
                    savePath = this.getSaveDirPath(resource);
                    break;
                }
                case FILE: {
                    savePath = this.getSaveFilePath(resource);
                }
            }
            if (savePath == null) {
                return;
            }
            JResourcePopupMenu.saveJResource(resource, savePath, true);
            LOG.info("Done saving {}", (Object)savePath);
        });
        return exportMenu;
    }

    private Path getSaveFilePath(JResource resource) {
        List<Path> selectedPaths;
        String extension = CommonFileUtils.getFileExtension((String)resource.getName());
        FileDialogWrapper fileDialog = new FileDialogWrapper(this.mainWindow, FileOpenMode.EXPORT_NODE);
        fileDialog.setFileExtList(Collections.singletonList(extension));
        Path currentDir = fileDialog.getCurrentDir();
        if (currentDir != null) {
            fileDialog.setSelectedFile(currentDir.resolve(resource.getName()));
        }
        if ((selectedPaths = fileDialog.show()).size() != 1) {
            return null;
        }
        Path selectedPath = selectedPaths.get(0);
        Path savePath = extension != null && !selectedPath.getFileName().toString().toLowerCase(Locale.ROOT).endsWith(extension) ? selectedPath.resolveSibling(selectedPath.getFileName() + "." + extension) : selectedPath;
        return savePath;
    }

    private Path getSaveDirPath(JResource resource) {
        FileDialogWrapper fileDialog = new FileDialogWrapper(this.mainWindow, FileOpenMode.EXPORT_NODE_FOLDER);
        List<Path> selectedPaths = fileDialog.show();
        if (selectedPaths.size() != 1) {
            return null;
        }
        return selectedPaths.get(0);
    }

    private static void saveJResource(JResource resource, Path savePath, boolean comingFromDialog) {
        switch (resource.getType()) {
            case ROOT: 
            case DIR: {
                JResourcePopupMenu.saveJResourceDir(resource, savePath, comingFromDialog);
                break;
            }
            case FILE: {
                JResourcePopupMenu.saveJResourceFile(resource, savePath, comingFromDialog);
            }
        }
    }

    private static void saveJResourceDir(JResource resource, Path savePath, boolean comingFromDialog) {
        Path subSavePath = savePath.resolve(resource.getName());
        try {
            if (!Files.isDirectory(subSavePath, new LinkOption[0])) {
                Files.createDirectory(subSavePath, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (JResource subResource : resource.getSubNodes()) {
            JResourcePopupMenu.saveJResource(subResource, subSavePath, false);
        }
    }

    private static void saveJResourceFile(JResource resource, Path savePath, boolean comingFromDialog) {
        if (!comingFromDialog) {
            Path fileName = Path.of(resource.getName(), new String[0]).getFileName();
            savePath = savePath.resolve(fileName);
        }
        switch (resource.getResFile().getType()) {
            case MANIFEST: 
            case XML: {
                JResourcePopupMenu.exportString(resource, savePath);
                break;
            }
            default: {
                JResourcePopupMenu.exportBinary(resource, savePath);
            }
        }
    }

    private static void exportString(JResource resource, Path savePath) {
        try (BufferedWriter writer = Files.newBufferedWriter(savePath, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(resource.getCodeInfo().getCodeStr());
        }
        catch (Exception e) {
            throw new RuntimeException("Error saving file " + resource.getName(), e);
        }
    }

    private static void exportBinary(JResource resource, Path savePath) {
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(savePath.toFile()));){
            byte[] bytes = (byte[])ResourcesLoader.decodeStream((ResourceFile)resource.getResFile(), (size, is) -> is.readAllBytes());
            if (bytes == null) {
                bytes = new byte[]{};
            }
            os.write(bytes);
        }
        catch (Exception e) {
            throw new RuntimeException("Error saving file " + resource.getName(), e);
        }
    }
}

