/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.api.ICodeInfo;
import jadx.gui.device.debugger.BreakpointManager;
import jadx.gui.device.debugger.DbgUtils;
import jadx.gui.settings.JadxSettings;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.TextNode;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.ui.codearea.ClassCodeContentPanel;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import org.fife.ui.rsyntaxtextarea.FoldingAwareIconRowHeader;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaEditorKit;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaUI;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.GutterIconInfo;
import org.fife.ui.rtextarea.IconRowHeader;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SmaliArea
extends AbstractCodeArea {
    private static final Logger LOG = LoggerFactory.getLogger(SmaliArea.class);
    private static final long serialVersionUID = 1334485631870306494L;
    private static final Icon ICON_BREAKPOINT = UiUtils.openSvgIcon("debugger/db_set_breakpoint");
    private static final Icon ICON_BREAKPOINT_DISABLED = UiUtils.openSvgIcon("debugger/db_disabled_breakpoint");
    private static final Color BREAKPOINT_LINE_COLOR = Color.decode("#ad103c");
    private static final Color DEBUG_LINE_COLOR = Color.decode("#9c1138");
    private final JNode textNode;
    private final JCheckBoxMenuItem cbUseSmaliV2;
    private boolean curVersion = false;
    private SmaliModel model;

    SmaliArea(final ContentPanel contentPanel, JClass node) {
        super(contentPanel, node);
        this.textNode = new TextNode(node.getName());
        this.setCodeFoldingEnabled(true);
        this.cbUseSmaliV2 = new JCheckBoxMenuItem(NLS.str("popup.bytecode_col"), this.shouldUseSmaliPrinterV2());
        this.cbUseSmaliV2.setAction(new AbstractAction(NLS.str("popup.bytecode_col")){
            private static final long serialVersionUID = -1111111202103170737L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JadxSettings settings;
                settings.setSmaliAreaShowBytecode(!(settings = SmaliArea.this.getContentPanel().getMainWindow().getSettings()).getSmaliAreaShowBytecode());
                contentPanel.getTabbedPane().getTabs().forEach(v -> {
                    if (v instanceof ClassCodeContentPanel) {
                        SmaliArea.this.switchModel();
                        ((ClassCodeContentPanel)v).getSmaliCodeArea().refresh();
                    }
                });
                settings.sync();
            }
        });
        this.getPopupMenu().add(this.cbUseSmaliV2);
        this.switchModel();
    }

    @Override
    public void load() {
        if (this.getText().isEmpty() || this.curVersion != this.shouldUseSmaliPrinterV2()) {
            this.curVersion = this.shouldUseSmaliPrinterV2();
            this.model.load();
            this.setCaretPosition(0);
            this.setLoaded();
        }
    }

    @Override
    public ICodeInfo getCodeInfo() {
        return ICodeInfo.EMPTY;
    }

    @Override
    public void refresh() {
        this.load();
    }

    @Override
    public JNode getNode() {
        return this.textNode;
    }

    @Override
    public JClass getJClass() {
        return (JClass)this.node;
    }

    private void switchModel() {
        if (this.model != null) {
            this.model.unload();
        }
        this.model = this.shouldUseSmaliPrinterV2() ? new DebugModel() : new NormalModel();
    }

    public void scrollToDebugPos(int pos) {
        this.getContentPanel().getMainWindow().getSettings().setSmaliAreaShowBytecode(true);
        this.cbUseSmaliV2.setState(this.shouldUseSmaliPrinterV2());
        if (!(this.model instanceof DebugModel)) {
            this.switchModel();
            this.refresh();
        }
        this.model.togglePosHighlight(pos);
    }

    public Font getFont() {
        if (this.model == null || this.isDisposed()) {
            return super.getFont();
        }
        return this.model.getFont();
    }

    public Font getFontForTokenType(int type) {
        return this.getFont();
    }

    private boolean shouldUseSmaliPrinterV2() {
        return this.getContentPanel().getMainWindow().getSettings().getSmaliAreaShowBytecode();
    }

    protected RTextAreaUI createRTextAreaUI() {
        return new RSyntaxTextAreaUI((JComponent)((Object)this)){

            public EditorKit getEditorKit(JTextComponent tc) {
                return new RSyntaxTextAreaEditorKit(){
                    private static final long serialVersionUID = -1111111202103170740L;

                    public IconRowHeader createIconRowHeader(RTextArea textArea) {
                        return new FoldingAwareIconRowHeader((RSyntaxTextArea)textArea){
                            private static final long serialVersionUID = -1111111202103170739L;

                            public void mousePressed(MouseEvent e) {
                                int offs = this.textArea.viewToModel2D((Point2D)e.getPoint());
                                if (offs > -1) {
                                    SmaliArea.this.model.setBreakpoint(offs);
                                }
                            }
                        };
                    }
                };
            }
        };
    }

    private class DebugModel
    extends SmaliModel {
        private KeyStroke bpShortcut;
        private Gutter gutter;
        private Object runningHighlightTag;
        private final SmaliV2Style smaliV2Style;
        private final Map<Integer, BreakpointLine> bpMap;
        private final PropertyChangeListener listener;

        public DebugModel() {
            this.runningHighlightTag = null;
            this.smaliV2Style = new SmaliV2Style(SmaliArea.this);
            this.bpMap = new HashMap<Integer, BreakpointLine>();
            this.listener = evt -> {
                if (this.smaliV2Style.refreshTheme()) {
                    SmaliArea.this.setSyntaxScheme(this.smaliV2Style);
                }
            };
            this.loadV2Style();
            SmaliArea.this.setSyntaxEditingStyle("text/asm6502");
            SmaliArea.this.addPropertyChangeListener("RSTA.syntaxScheme", this.listener);
            this.regBreakpointEvents();
        }

        @Override
        public void load() {
            if (this.gutter == null) {
                this.gutter = RSyntaxUtilities.getGutter((RTextArea)SmaliArea.this);
                this.gutter.setBookmarkingEnabled(true);
                this.gutter.setIconRowHeaderInheritsGutterBackground(true);
                Font baseFont = SmaliArea.super.getFont();
                this.gutter.setLineNumberFont(baseFont.deriveFont(baseFont.getSize2D() - 1.0f));
            }
            SmaliArea.this.setText(DbgUtils.getSmaliCode(((JClass)SmaliArea.this.node).getCls().getClassNode()));
            this.loadV2Style();
            this.loadBreakpoints();
        }

        @Override
        public void unload() {
            SmaliArea.this.removePropertyChangeListener(this.listener);
            SmaliArea.this.removeLineHighlight(this.runningHighlightTag);
            UiUtils.removeKeyBinding((JComponent)((Object)SmaliArea.this), this.bpShortcut, "set a break point");
            BreakpointManager.removeListener((JClass)SmaliArea.this.node);
            this.bpMap.forEach((k, v) -> v.remove());
        }

        @Override
        public Font getFont() {
            return this.smaliV2Style.getFont();
        }

        @Override
        public Font getFontForTokenType(int type) {
            return this.smaliV2Style.getFont();
        }

        private void loadV2Style() {
            SmaliArea.this.setSyntaxScheme(this.smaliV2Style);
        }

        private void regBreakpointEvents() {
            this.bpShortcut = KeyStroke.getKeyStroke(113, 0);
            UiUtils.addKeyBinding((JComponent)((Object)SmaliArea.this), this.bpShortcut, "set break point", new AbstractAction(){
                private static final long serialVersionUID = -1111111202103170738L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    DebugModel.this.setBreakpoint(SmaliArea.this.getCaretPosition());
                }
            });
            BreakpointManager.addListener((JClass)SmaliArea.this.node, this::setBreakpointDisabled);
        }

        private void loadBreakpoints() {
            List<Integer> posList = BreakpointManager.getPositions((JClass)SmaliArea.this.node);
            for (Integer integer : posList) {
                this.setBreakpoint(integer);
            }
        }

        @Override
        public void setBreakpoint(int pos) {
            int line;
            try {
                line = SmaliArea.this.getLineOfOffset(pos);
            }
            catch (BadLocationException e) {
                LOG.error("Failed to get line by offset: {}", (Object)pos, (Object)e);
                return;
            }
            BreakpointLine bpLine = this.bpMap.remove(line);
            if (bpLine == null) {
                bpLine = new BreakpointLine(line);
                bpLine.setDisabled(false);
                this.bpMap.put(line, bpLine);
                if (!BreakpointManager.set((JClass)SmaliArea.this.node, line)) {
                    bpLine.setDisabled(true);
                }
            } else {
                BreakpointManager.remove((JClass)SmaliArea.this.node, line);
                bpLine.remove();
            }
        }

        @Override
        public void togglePosHighlight(int pos) {
            if (this.runningHighlightTag != null) {
                SmaliArea.this.removeLineHighlight(this.runningHighlightTag);
            }
            try {
                int line = SmaliArea.this.getLineOfOffset(pos);
                this.runningHighlightTag = SmaliArea.this.addLineHighlight(line, DEBUG_LINE_COLOR);
            }
            catch (BadLocationException e) {
                LOG.error("Failed to get line by offset: {}", (Object)pos, (Object)e);
            }
        }

        private void setBreakpointDisabled(int pos) {
            try {
                int line = SmaliArea.this.getLineOfOffset(pos);
                this.bpMap.computeIfAbsent(line, k -> new BreakpointLine(line)).setDisabled(true);
            }
            catch (BadLocationException e) {
                LOG.error("Failed to get line by offset: {}", (Object)pos, (Object)e);
            }
        }

        private class BreakpointLine {
            Object highlightTag;
            GutterIconInfo iconInfo;
            boolean disabled;
            final int line;

            BreakpointLine(int line) {
                this.line = line;
                this.disabled = true;
            }

            void remove() {
                DebugModel.this.gutter.removeTrackingIcon(this.iconInfo);
                if (!this.disabled) {
                    SmaliArea.this.removeLineHighlight(this.highlightTag);
                }
            }

            void setDisabled(boolean disabled) {
                if (disabled) {
                    if (!this.disabled) {
                        DebugModel.this.gutter.removeTrackingIcon(this.iconInfo);
                        SmaliArea.this.removeLineHighlight(this.highlightTag);
                        try {
                            this.iconInfo = DebugModel.this.gutter.addLineTrackingIcon(this.line, ICON_BREAKPOINT_DISABLED);
                        }
                        catch (BadLocationException e) {
                            LOG.error("Failed to add line tracking icon", (Throwable)e);
                        }
                    }
                } else if (this.disabled) {
                    DebugModel.this.gutter.removeTrackingIcon(this.iconInfo);
                    try {
                        this.iconInfo = DebugModel.this.gutter.addLineTrackingIcon(this.line, ICON_BREAKPOINT);
                        this.highlightTag = SmaliArea.this.addLineHighlight(this.line, BREAKPOINT_LINE_COLOR);
                    }
                    catch (BadLocationException e) {
                        LOG.error("Failed to remove line tracking icon", (Throwable)e);
                    }
                }
                this.disabled = disabled;
            }
        }

        private class SmaliV2Style
        extends SyntaxScheme {
            Theme curTheme;

            public SmaliV2Style(SmaliArea smaliArea) {
                super(true);
                this.curTheme = smaliArea.getContentPanel().getMainWindow().getEditorTheme();
                this.updateTheme();
            }

            public Font getFont() {
                return SmaliArea.this.getContentPanel().getMainWindow().getSettings().getSmaliFont();
            }

            public boolean refreshTheme() {
                boolean refresh;
                Theme theme = SmaliArea.this.getContentPanel().getMainWindow().getEditorTheme();
                boolean bl = refresh = theme != this.curTheme;
                if (refresh) {
                    this.curTheme = theme;
                    this.updateTheme();
                }
                return refresh;
            }

            private void updateTheme() {
                Style[] mainStyles = this.curTheme.scheme.getStyles();
                Style[] styles = new Style[mainStyles.length];
                for (int i = 0; i < mainStyles.length; ++i) {
                    Style mainStyle = mainStyles[i];
                    styles[i] = mainStyle == null ? new Style() : new Style(mainStyle.foreground, mainStyle.background, null);
                }
                this.setStyles(styles);
            }

            public void restoreDefaults(Font baseFont) {
                this.restoreDefaults(baseFont, true);
            }

            public void restoreDefaults(Font baseFont, boolean fontStyles) {
            }
        }
    }

    private class NormalModel
    extends SmaliModel {
        public NormalModel() {
            Theme theme = SmaliArea.this.getContentPanel().getMainWindow().getEditorTheme();
            SmaliArea.this.setSyntaxScheme(theme.scheme);
            SmaliArea.this.setSyntaxEditingStyle("text/smali");
        }

        @Override
        public void load() {
            SmaliArea.this.setText(SmaliArea.this.getJClass().getSmali());
        }

        @Override
        public void unload() {
        }
    }

    private abstract class SmaliModel {
        private SmaliModel() {
        }

        abstract void load();

        abstract void unload();

        Font getFont() {
            return SmaliArea.super.getFont();
        }

        Font getFontForTokenType(int type) {
            return SmaliArea.super.getFontForTokenType(type);
        }

        void setBreakpoint(int off) {
        }

        void togglePosHighlight(int pos) {
        }
    }
}

