/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.api.ICodeInfo;
import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.api.data.ICodeComment;
import jadx.api.data.IJavaCodeRef;
import jadx.api.data.IJavaNodeRef;
import jadx.api.data.impl.JadxCodeComment;
import jadx.api.data.impl.JadxCodeRef;
import jadx.api.data.impl.JadxNodeRef;
import jadx.api.metadata.ICodeAnnotation;
import jadx.api.metadata.ICodeMetadata;
import jadx.api.metadata.ICodeNodeRef;
import jadx.api.metadata.annotations.InsnCodeOffset;
import jadx.api.metadata.annotations.NodeDeclareRef;
import jadx.gui.JadxWrapper;
import jadx.gui.treemodel.JClass;
import jadx.gui.ui.action.ActionModel;
import jadx.gui.ui.action.JadxGuiAction;
import jadx.gui.ui.codearea.CodeArea;
import jadx.gui.ui.codearea.CodeAreaAction;
import jadx.gui.ui.dialog.CommentDialog;
import jadx.gui.utils.DefaultPopupMenuListener;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.awt.event.ActionEvent;
import javax.swing.event.PopupMenuEvent;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentAction
extends CodeAreaAction
implements DefaultPopupMenuListener {
    private static final long serialVersionUID = 4753838562204629112L;
    private static final Logger LOG = LoggerFactory.getLogger(CommentAction.class);
    private final boolean enabled;
    private ICodeComment actionComment;

    public CommentAction(CodeArea codeArea) {
        super(ActionModel.CODE_COMMENT, codeArea);
        this.enabled = codeArea.getNode() instanceof JClass;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        if (this.enabled) {
            ICodeComment codeComment = this.getCommentRef(UiUtils.getOffsetAtMousePosition(this.codeArea));
            this.setEnabled(codeComment != null);
            this.actionComment = codeComment;
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.enabled) {
            return;
        }
        if (JadxGuiAction.isSource(e)) {
            this.showCommentDialog(this.getCommentRef(this.codeArea.getCaretPosition()));
        } else {
            this.showCommentDialog(this.actionComment);
        }
    }

    private void showCommentDialog(ICodeComment codeComment) {
        if (codeComment == null) {
            UiUtils.showMessageBox(this.codeArea.getMainWindow(), NLS.str("msg.cant_add_comment"));
            return;
        }
        CommentDialog.show(this.codeArea, codeComment);
    }

    @Nullable
    private ICodeComment getCommentRef(int pos) {
        if (pos == -1) {
            return null;
        }
        try {
            ICodeNodeRef nodeRef;
            JavaNode node;
            JadxWrapper wrapper = this.codeArea.getJadxWrapper();
            ICodeInfo codeInfo = this.codeArea.getCodeInfo();
            ICodeMetadata metadata = codeInfo.getCodeMetadata();
            int lineStartPos = this.codeArea.getLineStartFor(pos);
            ICodeAnnotation offsetAnn = metadata.searchUp(pos, lineStartPos, ICodeAnnotation.AnnType.OFFSET);
            if (offsetAnn instanceof InsnCodeOffset && (node = wrapper.getJavaNodeByRef(metadata.getNodeAt(pos))) instanceof JavaMethod) {
                int rawOffset = ((InsnCodeOffset)offsetAnn).getOffset();
                JadxNodeRef nodeRef2 = JadxNodeRef.forMth((JavaMethod)((JavaMethod)node));
                return new JadxCodeComment((IJavaNodeRef)nodeRef2, (IJavaCodeRef)JadxCodeRef.forInsn((int)rawOffset), "");
            }
            ICodeNodeRef nodeDef = (ICodeNodeRef)metadata.searchUp(pos, (off, ann) -> {
                ICodeNodeRef defRef;
                if (lineStartPos <= off && ann.getAnnType() == ICodeAnnotation.AnnType.DECLARATION && (defRef = ((NodeDeclareRef)ann).getNode()).getAnnType() != ICodeAnnotation.AnnType.VAR) {
                    return defRef;
                }
                return null;
            });
            if (nodeDef != null) {
                JadxNodeRef nodeRef3 = JadxNodeRef.forJavaNode((JavaNode)wrapper.getJavaNodeByRef(nodeDef));
                return new JadxCodeComment((IJavaNodeRef)nodeRef3, "");
            }
            String lineStr = this.codeArea.getLineAt(pos).trim();
            if ((lineStr.startsWith("//") || lineStr.startsWith("/*")) && (nodeRef = (ICodeNodeRef)metadata.searchDown(pos, (off, ann) -> {
                if (off > pos && ann.getAnnType() == ICodeAnnotation.AnnType.DECLARATION) {
                    return ((NodeDeclareRef)ann).getNode();
                }
                return null;
            })) != null) {
                JavaNode defNode = wrapper.getJavaNodeByRef(nodeRef);
                return new JadxCodeComment((IJavaNodeRef)JadxNodeRef.forJavaNode((JavaNode)defNode), "");
            }
        }
        catch (Exception e) {
            LOG.error("Failed to add comment at: " + pos, (Throwable)e);
        }
        return null;
    }
}

