/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import ch.qos.logback.classic.Level;
import jadx.api.JadxArgs;
import jadx.api.JavaClass;
import jadx.api.JavaNode;
import jadx.api.ResourceFile;
import jadx.api.plugins.events.IJadxEvent;
import jadx.api.plugins.events.JadxEvents;
import jadx.api.plugins.events.types.ReloadProject;
import jadx.api.plugins.events.types.ReloadSettingsWindow;
import jadx.api.plugins.utils.CommonFileUtils;
import jadx.core.Jadx;
import jadx.core.export.TemplateFile;
import jadx.core.utils.ListUtils;
import jadx.core.utils.StringUtils;
import jadx.core.utils.android.AndroidManifestParser;
import jadx.core.utils.android.AppAttribute;
import jadx.core.utils.android.ApplicationParams;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.utils.files.FileUtils;
import jadx.gui.JadxWrapper;
import jadx.gui.cache.manager.CacheManager;
import jadx.gui.device.debugger.BreakpointManager;
import jadx.gui.events.services.RenameService;
import jadx.gui.events.types.JadxGuiEventsImpl;
import jadx.gui.jobs.BackgroundExecutor;
import jadx.gui.jobs.DecompileTask;
import jadx.gui.jobs.ExportTask;
import jadx.gui.jobs.TaskStatus;
import jadx.gui.logs.LogCollector;
import jadx.gui.logs.LogOptions;
import jadx.gui.logs.LogPanel;
import jadx.gui.plugins.mappings.RenameMappingsGui;
import jadx.gui.plugins.quark.QuarkDialog;
import jadx.gui.settings.JadxProject;
import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.ui.JadxSettingsWindow;
import jadx.gui.settings.ui.plugins.PluginSettings;
import jadx.gui.treemodel.ApkSignature;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JLoadableNode;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JPackage;
import jadx.gui.treemodel.JResource;
import jadx.gui.treemodel.JRoot;
import jadx.gui.ui.ExceptionDialog;
import jadx.gui.ui.HeapUsageBar;
import jadx.gui.ui.JadxEventQueue;
import jadx.gui.ui.MainDropTarget;
import jadx.gui.ui.action.ActionModel;
import jadx.gui.ui.action.JadxGuiAction;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.ui.codearea.AbstractCodeContentPanel;
import jadx.gui.ui.codearea.EditorTheme;
import jadx.gui.ui.codearea.EditorViewState;
import jadx.gui.ui.dialog.ADBDialog;
import jadx.gui.ui.dialog.AboutDialog;
import jadx.gui.ui.dialog.LogViewerDialog;
import jadx.gui.ui.dialog.SearchDialog;
import jadx.gui.ui.filedialog.FileDialogWrapper;
import jadx.gui.ui.filedialog.FileOpenMode;
import jadx.gui.ui.menu.HiddenMenuItem;
import jadx.gui.ui.menu.JadxMenu;
import jadx.gui.ui.menu.JadxMenuBar;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.ui.panel.IssuesPanel;
import jadx.gui.ui.panel.JDebuggerPanel;
import jadx.gui.ui.panel.ProgressPanel;
import jadx.gui.ui.popupmenu.RecentProjectsMenuListener;
import jadx.gui.ui.tab.EditorSyncManager;
import jadx.gui.ui.tab.NavigationController;
import jadx.gui.ui.tab.QuickTabsTree;
import jadx.gui.ui.tab.TabbedPane;
import jadx.gui.ui.tab.TabsController;
import jadx.gui.ui.tab.dnd.TabDndController;
import jadx.gui.ui.treenodes.StartPageNode;
import jadx.gui.ui.treenodes.SummaryNode;
import jadx.gui.update.JadxUpdate;
import jadx.gui.utils.CacheObject;
import jadx.gui.utils.FontUtils;
import jadx.gui.utils.ILoadListener;
import jadx.gui.utils.LafManager;
import jadx.gui.utils.Link;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.dbg.UIWatchDog;
import jadx.gui.utils.fileswatcher.LiveReloadWorker;
import jadx.gui.utils.shortcut.ShortcutsController;
import jadx.gui.utils.ui.ActionHandler;
import jadx.gui.utils.ui.NodeLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainWindow
extends JFrame {
    private static final Logger LOG = LoggerFactory.getLogger(MainWindow.class);
    private static final String DEFAULT_TITLE = "jadx-gui";
    private static final double BORDER_RATIO = 0.15;
    private static final double WINDOW_RATIO = 0.7;
    public static final double SPLIT_PANE_RESIZE_WEIGHT = 0.15;
    private static final ImageIcon ICON_ADD_FILES = UiUtils.openSvgIcon("ui/addFile");
    private static final ImageIcon ICON_RELOAD = UiUtils.openSvgIcon("ui/refresh");
    private static final ImageIcon ICON_EXPORT = UiUtils.openSvgIcon("ui/export");
    private static final ImageIcon ICON_EXIT = UiUtils.openSvgIcon("ui/exit");
    private static final ImageIcon ICON_SYNC = UiUtils.openSvgIcon("ui/pagination");
    private static final ImageIcon ICON_FLAT_PKG = UiUtils.openSvgIcon("ui/moduleGroup");
    private static final ImageIcon ICON_SEARCH = UiUtils.openSvgIcon("ui/find");
    private static final ImageIcon ICON_FIND = UiUtils.openSvgIcon("ui/ejbFinderMethod");
    private static final ImageIcon ICON_COMMENT_SEARCH = UiUtils.openSvgIcon("ui/usagesFinder");
    private static final ImageIcon ICON_MAIN_ACTIVITY = UiUtils.openSvgIcon("ui/home");
    private static final ImageIcon ICON_BACK = UiUtils.openSvgIcon("ui/left");
    private static final ImageIcon ICON_FORWARD = UiUtils.openSvgIcon("ui/right");
    private static final ImageIcon ICON_QUARK = UiUtils.openSvgIcon("ui/quark");
    private static final ImageIcon ICON_PREF = UiUtils.openSvgIcon("ui/settings");
    private static final ImageIcon ICON_DEOBF = UiUtils.openSvgIcon("ui/helmChartLock");
    private static final ImageIcon ICON_DECOMPILE_ALL = UiUtils.openSvgIcon("ui/runAll");
    private static final ImageIcon ICON_LOG = UiUtils.openSvgIcon("ui/logVerbose");
    private static final ImageIcon ICON_INFO = UiUtils.openSvgIcon("ui/showInfos");
    private static final ImageIcon ICON_DEBUGGER = UiUtils.openSvgIcon("ui/startDebugger");
    private final transient JadxWrapper wrapper;
    private final transient JadxSettings settings;
    private final transient CacheObject cacheObject;
    private final transient CacheManager cacheManager;
    private final transient BackgroundExecutor backgroundExecutor;
    private final transient JadxGuiEventsImpl events = new JadxGuiEventsImpl();
    private final TabsController tabsController;
    private final NavigationController navController;
    private final EditorSyncManager editorSyncManager;
    @NotNull
    private transient JadxProject project;
    private transient JadxGuiAction newProjectAction;
    private transient JadxGuiAction saveProjectAction;
    private transient JPanel mainPanel;
    private transient JSplitPane treeSplitPane;
    private transient JSplitPane rightSplitPane;
    private transient JSplitPane bottomSplitPane;
    private transient JSplitPane quickTabsAndCodeSplitPane;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private JRoot treeRoot;
    private TabbedPane tabbedPane;
    private HeapUsageBar heapUsageBar;
    private transient boolean treeReloading;
    private boolean isFlattenPackage;
    private JToggleButton flatPkgButton;
    private JCheckBoxMenuItem flatPkgMenuItem;
    private JToggleButton deobfToggleBtn;
    private JCheckBoxMenuItem deobfMenuItem;
    private JCheckBoxMenuItem liveReloadMenuItem;
    private final LiveReloadWorker liveReloadWorker;
    private transient Link updateLink;
    private transient ProgressPanel progressPane;
    private transient Theme editorTheme;
    private transient IssuesPanel issuesPanel;
    @Nullable
    private transient LogPanel logPanel;
    @Nullable
    private transient JDebuggerPanel debuggerPanel;
    @Nullable
    private transient QuickTabsTree quickTabsTree;
    private final List<ILoadListener> loadListeners = new ArrayList<ILoadListener>();
    private final List<Consumer<JRoot>> treeUpdateListener = new ArrayList<Consumer<JRoot>>();
    private boolean loaded;
    private boolean settingsOpen = false;
    private final ShortcutsController shortcutsController;
    private JadxMenuBar menuBar;
    private JMenu pluginsMenu;
    private final transient RenameMappingsGui renameMappings;

    public MainWindow(JadxSettings settings) {
        this.settings = settings;
        this.cacheObject = new CacheObject();
        this.project = new JadxProject(this);
        this.wrapper = new JadxWrapper(this);
        this.liveReloadWorker = new LiveReloadWorker(this);
        this.renameMappings = new RenameMappingsGui(this);
        this.cacheManager = new CacheManager(settings);
        this.shortcutsController = new ShortcutsController(settings);
        this.tabsController = new TabsController(this);
        this.navController = new NavigationController(this);
        JadxEventQueue.register();
        this.resetCache();
        FontUtils.registerBundledFonts();
        this.setEditorTheme(settings.getEditorThemePath());
        this.initUI();
        this.editorSyncManager = new EditorSyncManager(this, this.tabbedPane);
        this.backgroundExecutor = new BackgroundExecutor(settings, this.progressPane);
        this.initMenuAndToolbar();
        UiUtils.setWindowIcons(this);
        this.shortcutsController.registerMouseEventListener(this);
        this.loadSettings();
        this.initEvents();
        this.update();
        this.checkForUpdate();
    }

    public void init() {
        this.pack();
        this.setLocationAndPosition();
        this.treeSplitPane.setDividerLocation(this.settings.getTreeWidth());
        this.heapUsageBar.setVisible(this.settings.isShowHeapUsageBar());
        this.setVisible(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainWindow.this.closeWindow();
            }
        });
        this.processCommandLineArgs();
    }

    private void processCommandLineArgs() {
        if (this.settings.getFiles().isEmpty()) {
            this.tabsController.selectTab(new StartPageNode());
        } else {
            this.open(FileUtils.fileNamesToPaths((List)this.settings.getFiles()), this::handleSelectClassOption);
        }
    }

    private void handleSelectClassOption() {
        if (this.settings.getCmdSelectClass() != null) {
            JavaClass javaNode = this.wrapper.searchJavaClassByFullAlias(this.settings.getCmdSelectClass());
            if (javaNode == null) {
                javaNode = this.wrapper.searchJavaClassByOrigClassName(this.settings.getCmdSelectClass());
            }
            if (javaNode == null) {
                JOptionPane.showMessageDialog(this, NLS.str("msg.cmd_select_class_error", this.settings.getCmdSelectClass()), NLS.str("error_dialog.title"), 0);
                return;
            }
            this.tabsController.codeJump(this.cacheObject.getNodeCache().makeFrom((JavaNode)javaNode));
        }
    }

    private void checkForUpdate() {
        if (!this.settings.isCheckForUpdates()) {
            return;
        }
        JadxUpdate.check(this.settings.getJadxUpdateChannel(), release -> SwingUtilities.invokeLater(() -> {
            switch (this.settings.getJadxUpdateChannel()) {
                case STABLE: {
                    this.updateLink.setUrl("https://github.com/skylot/jadx/releases");
                    break;
                }
                case UNSTABLE: {
                    this.updateLink.setUrl("https://nightly.link/skylot/jadx/workflows/build-artifacts/master");
                }
            }
            this.updateLink.setText(NLS.str("menu.update_label", release.getName()));
            this.updateLink.setVisible(true);
        }));
    }

    public void openFileDialog() {
        this.showOpenDialog(FileOpenMode.OPEN);
    }

    public void openProjectDialog() {
        this.showOpenDialog(FileOpenMode.OPEN_PROJECT);
    }

    private void showOpenDialog(FileOpenMode mode) {
        this.saveAll();
        if (!this.ensureProjectIsSaved()) {
            return;
        }
        FileDialogWrapper fileDialog = new FileDialogWrapper(this, mode);
        List<Path> openPaths = fileDialog.show();
        if (!openPaths.isEmpty()) {
            this.settings.setLastOpenFilePath(fileDialog.getCurrentDir());
            this.open(openPaths);
        }
    }

    public void addFiles() {
        FileDialogWrapper fileDialog = new FileDialogWrapper(this, FileOpenMode.ADD);
        List<Path> addPaths = fileDialog.show();
        if (!addPaths.isEmpty()) {
            this.addFiles(addPaths);
        }
    }

    public void addFiles(List<Path> addPaths) {
        this.project.setFilePaths(ListUtils.distinctMergeSortedLists(addPaths, this.project.getFilePaths()));
        this.reopen();
    }

    private void newProject() {
        this.saveAll();
        if (!this.ensureProjectIsSaved()) {
            return;
        }
        this.closeAll();
        this.updateProject(new JadxProject(this));
    }

    private void saveProject() {
        this.saveOpenTabs();
        if (!this.project.isSaveFileSelected()) {
            this.saveProjectAs();
        } else {
            this.project.save();
            this.update();
        }
    }

    private void saveProjectAs() {
        int res;
        List<Path> saveFiles;
        FileDialogWrapper fileDialog = new FileDialogWrapper(this, FileOpenMode.SAVE_PROJECT);
        if (this.project.getFilePaths().size() == 1) {
            Path projectPath = MainWindow.getProjectPathForFile(this.project.getFilePaths().get(0));
            fileDialog.setSelectedFile(projectPath);
        }
        if ((saveFiles = fileDialog.show()).isEmpty()) {
            return;
        }
        this.settings.setLastSaveProjectPath(fileDialog.getCurrentDir());
        Path savePath = saveFiles.get(0);
        if (!savePath.getFileName().toString().toLowerCase(Locale.ROOT).endsWith("jadx")) {
            savePath = savePath.resolveSibling(savePath.getFileName() + ".jadx");
        }
        if (Files.exists(savePath, new LinkOption[0]) && (res = JOptionPane.showConfirmDialog(this, NLS.str("confirm.save_as_message", savePath.getFileName()), NLS.str("confirm.save_as_title"), 0)) == 1) {
            return;
        }
        this.project.saveAs(savePath);
        this.settings.addRecentProject(savePath);
        this.update();
    }

    public void addNewScript() {
        FileDialogWrapper fileDialog = new FileDialogWrapper(this, FileOpenMode.CUSTOM_SAVE);
        fileDialog.setTitle(NLS.str("file.save"));
        Path workingDir = this.project.getWorkingDir();
        Path baseDir = workingDir != null ? workingDir : this.settings.getLastSaveFilePath();
        fileDialog.setSelectedFile(baseDir.resolve("script.jadx.kts"));
        fileDialog.setFileExtList(Collections.singletonList("jadx.kts"));
        fileDialog.setSelectionMode(0);
        List<Path> paths = fileDialog.show();
        if (paths.size() != 1) {
            return;
        }
        Path scriptFile = paths.get(0);
        try {
            TemplateFile tmpl = TemplateFile.fromResources((String)"/files/script.jadx.kts.tmpl");
            FileUtils.writeFile((Path)scriptFile, (String)tmpl.build());
        }
        catch (Exception e) {
            LOG.error("Failed to save new script file: {}", (Object)scriptFile, (Object)e);
        }
        List<Path> inputs = this.project.getFilePaths();
        inputs.add(scriptFile);
        this.project.setFilePaths(inputs);
        this.project.save();
        this.reopen();
    }

    public void removeInput(Path file) {
        List<Path> inputs = this.project.getFilePaths();
        inputs.remove(file);
        this.project.setFilePaths(inputs);
        this.project.save();
        this.reopen();
    }

    public void open(Path path) {
        this.open(Collections.singletonList(path), UiUtils.EMPTY_RUNNABLE);
    }

    public void open(List<Path> paths) {
        this.open(paths, UiUtils.EMPTY_RUNNABLE);
    }

    private void open(List<Path> paths, Runnable onFinish) {
        this.saveAll();
        this.closeAll();
        if (paths.size() == 1 && this.openSingleFile(paths.get(0), onFinish)) {
            return;
        }
        this.project = new JadxProject(this);
        this.project.setFilePaths(paths);
        this.loadFiles(onFinish);
    }

    private boolean openSingleFile(Path singleFile, Runnable onFinish) {
        if (singleFile.getFileName() == null) {
            return false;
        }
        String fileExtension = CommonFileUtils.getFileExtension((String)singleFile.getFileName().toString());
        if (fileExtension != null && fileExtension.equalsIgnoreCase("jadx")) {
            this.openProject(singleFile, onFinish);
            return true;
        }
        Path projectPath = MainWindow.getProjectPathForFile(singleFile);
        if (Files.exists(projectPath, new LinkOption[0])) {
            this.openProject(projectPath, onFinish);
            return true;
        }
        return false;
    }

    private static Path getProjectPathForFile(Path loadedFile) {
        String fileName = loadedFile.getFileName() + ".jadx";
        return loadedFile.resolveSibling(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reopen() {
        ReloadProject reloadProject = ReloadProject.EVENT;
        synchronized (reloadProject) {
            this.saveAll();
            this.closeAll();
            this.loadFiles(() -> {
                this.menuBar.reloadShortcuts();
                this.events().send((IJadxEvent)ReloadSettingsWindow.INSTANCE);
            });
        }
    }

    private void openProject(Path path, Runnable onFinish) {
        LOG.debug("Loading project: {}", (Object)path);
        JadxProject jadxProject = JadxProject.load(this, path);
        if (jadxProject == null) {
            JOptionPane.showMessageDialog(this, NLS.str("msg.project_error"), NLS.str("msg.project_error_title"), 1);
            jadxProject = new JadxProject(this);
        }
        this.settings.addRecentProject(path);
        this.project = jadxProject;
        this.loadFiles(onFinish);
    }

    private void loadFiles(Runnable onFinish) {
        if (this.project.getFilePaths().isEmpty()) {
            this.tabsController.selectTab(new StartPageNode());
            onFinish.run();
            return;
        }
        AtomicReference wrapperException = new AtomicReference();
        this.backgroundExecutor.execute(NLS.str("progress.load"), () -> {
            try {
                this.wrapper.open();
            }
            catch (Exception e) {
                wrapperException.set(e);
            }
        }, status -> {
            if (wrapperException.get() != null) {
                this.closeAll();
                Exception e = (Exception)wrapperException.get();
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new JadxRuntimeException("Project load error", (Throwable)e);
            }
            if (status == TaskStatus.CANCEL_BY_MEMORY) {
                this.showHeapUsageBar();
                UiUtils.errorMessage(this, NLS.str("message.memoryLow"));
                return;
            }
            if (status != TaskStatus.COMPLETE) {
                LOG.warn("Loading task incomplete, status: {}", (Object)status);
                return;
            }
            this.checkLoadedStatus();
            this.onOpen();
            onFinish.run();
        });
    }

    private void saveAll() {
        this.saveOpenTabs();
        BreakpointManager.saveAndExit();
    }

    private void closeAll() {
        this.notifyLoadListeners(false);
        this.cancelBackgroundJobs();
        this.navController.reset();
        this.tabbedPane.reset();
        this.clearTree();
        this.resetCache();
        LogCollector.getInstance().reset();
        this.wrapper.close();
        this.tabsController.forceCloseAllTabs();
        this.shortcutsController.reset();
        UiUtils.resetClipboardOwner();
        System.gc();
        this.update();
    }

    private void checkLoadedStatus() {
        if (!this.wrapper.getClasses().isEmpty()) {
            return;
        }
        int errors = this.issuesPanel.getErrorsCount();
        if (errors > 0) {
            int result = JOptionPane.showConfirmDialog(this, NLS.str("message.load_errors", errors), NLS.str("message.errorTitle"), 2, 0);
            if (result == 0) {
                this.showLogViewer(LogOptions.allWithLevel(Level.ERROR));
            }
        } else {
            UiUtils.showMessageBox(this, NLS.str("message.no_classes"));
        }
    }

    private void onOpen() {
        this.initTree();
        this.updateLiveReload(this.project.isEnableLiveReload());
        BreakpointManager.init(this.project.getFilePaths().get(0).toAbsolutePath().getParent());
        List<EditorViewState> openTabs = this.project.getOpenTabs(this);
        this.backgroundExecutor.execute(NLS.str("progress.load"), () -> this.preLoadOpenTabs(openTabs), status -> {
            this.restoreOpenTabs(openTabs);
            this.runInitialBackgroundJobs();
            this.notifyLoadListeners(true);
            this.update();
        });
    }

    public void passesReloaded() {
        this.tabbedPane.reloadInactiveTabs();
        this.reloadTree();
    }

    private void initEvents() {
        this.events().global().addListener(JadxEvents.RELOAD_PROJECT, ev -> UiUtils.uiRun(this::reopen));
        RenameService.init(this);
    }

    public void updateLiveReload(boolean state) {
        if (this.liveReloadWorker.isStarted() == state) {
            return;
        }
        this.project.setEnableLiveReload(state);
        this.liveReloadMenuItem.setEnabled(false);
        this.backgroundExecutor.execute((state ? "Starting" : "Stopping") + " live reload", () -> this.liveReloadWorker.updateState(state), s -> {
            this.liveReloadMenuItem.setState(state);
            this.liveReloadMenuItem.setEnabled(true);
        });
    }

    private void addTreeCustomNodes() {
        this.treeRoot.replaceCustomNode(ApkSignature.getApkSignature(this.wrapper));
        this.treeRoot.replaceCustomNode(new SummaryNode(this));
    }

    private boolean ensureProjectIsSaved() {
        if (!this.project.isSaved() && !this.project.isInitial()) {
            if (this.settings.getSaveOption() == JadxSettings.SAVEOPTION.NEVER) {
                return true;
            }
            if (this.settings.getSaveOption() == JadxSettings.SAVEOPTION.ALWAYS) {
                this.saveProject();
                return true;
            }
            JCheckBox remember = new JCheckBox(NLS.str("confirm.remember"));
            JLabel message = new JLabel(NLS.str("confirm.not_saved_message"));
            JPanel inner = new JPanel(new BorderLayout());
            inner.add((Component)remember, "South");
            inner.add((Component)message, "North");
            int res = JOptionPane.showConfirmDialog(this, inner, NLS.str("confirm.not_saved_title"), 1);
            if (res == 2) {
                return false;
            }
            if (res == 0) {
                if (remember.isSelected()) {
                    this.settings.setSaveOption(JadxSettings.SAVEOPTION.ALWAYS);
                    this.settings.sync();
                }
                this.saveProject();
            } else if (res == 1 && remember.isSelected()) {
                this.settings.setSaveOption(JadxSettings.SAVEOPTION.NEVER);
                this.settings.sync();
            }
        }
        return true;
    }

    public void updateProject(@NotNull JadxProject jadxProject) {
        this.project = jadxProject;
        UiUtils.uiRun(this::update);
    }

    public void update() {
        UiUtils.uiThreadGuard();
        this.newProjectAction.setEnabled(!this.project.isInitial());
        this.saveProjectAction.setEnabled(this.loaded && !this.project.isSaved());
        this.deobfToggleBtn.setSelected(this.settings.isDeobfuscationOn());
        this.renameMappings.onUpdate(this.loaded);
        Path projectPath = this.project.getProjectPath();
        Object pathString = projectPath == null ? "" : " [" + projectPath.toAbsolutePath().getParent() + "]";
        this.setTitle((Serializable)(this.project.isSaved() ? "" : Character.valueOf('*')) + this.project.getName() + (String)pathString + " - jadx-gui");
    }

    protected void resetCache() {
        this.cacheObject.reset();
    }

    synchronized void runInitialBackgroundJobs() {
        if (this.settings.isAutoStartJobs()) {
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    MainWindow.this.requestFullDecompilation();
                }
            }, 1000L);
        }
    }

    public void requestFullDecompilation() {
        if (this.cacheObject.isFullDecompilationFinished()) {
            return;
        }
        this.backgroundExecutor.execute(new DecompileTask(this));
    }

    public void resetCodeCache() {
        this.backgroundExecutor.execute(NLS.str("preferences.cache.task.delete"), () -> {
            try {
                this.getWrapper().getCurrentDecompiler().ifPresent(jadx -> {
                    try {
                        jadx.getArgs().getCodeCache().close();
                    }
                    catch (Exception e) {
                        LOG.error("Failed to close code cache", (Throwable)e);
                    }
                });
                Path cacheDir = this.project.getCacheDir();
                this.project.resetCacheDir();
                FileUtils.deleteDirIfExists((Path)cacheDir);
            }
            catch (Exception e) {
                LOG.error("Error during code cache reset", (Throwable)e);
            }
        }, status -> this.events().send((IJadxEvent)ReloadProject.EVENT));
    }

    public void cancelBackgroundJobs() {
        this.backgroundExecutor.cancelAll();
    }

    private void saveAll(boolean export) {
        FileDialogWrapper fileDialog = new FileDialogWrapper(this, FileOpenMode.EXPORT);
        List<Path> saveDirs = fileDialog.show();
        if (saveDirs.isEmpty()) {
            return;
        }
        JadxArgs decompilerArgs = this.wrapper.getArgs();
        decompilerArgs.setExportAsGradleProject(export);
        if (export) {
            decompilerArgs.setSkipSources(false);
            decompilerArgs.setSkipResources(false);
        } else {
            decompilerArgs.setSkipSources(this.settings.isSkipSources());
            decompilerArgs.setSkipResources(this.settings.isSkipResources());
        }
        this.settings.setLastSaveFilePath(fileDialog.getCurrentDir());
        this.backgroundExecutor.execute(new ExportTask(this, this.wrapper, saveDirs.get(0).toFile()));
    }

    public void initTree() {
        this.treeRoot = new JRoot(this.wrapper);
        this.treeRoot.setFlatPackages(this.isFlattenPackage);
        this.treeModel.setRoot(this.treeRoot);
        this.addTreeCustomNodes();
        this.treeRoot.update();
        this.reloadTree();
    }

    private void clearTree() {
        this.treeRoot = null;
        this.treeModel.setRoot(null);
        this.treeModel.reload();
    }

    public void reloadTree() {
        this.treeReloading = true;
        this.treeUpdateListener.forEach(listener -> listener.accept(this.treeRoot));
        this.treeModel.reload();
        List<String[]> treeExpansions = this.project.getTreeExpansions();
        if (!treeExpansions.isEmpty()) {
            this.expand(this.treeRoot, treeExpansions);
        } else {
            this.tree.expandRow(1);
        }
        this.treeReloading = false;
    }

    public void rebuildPackagesTree() {
        this.cacheObject.setPackageHelper(null);
        this.treeRoot.update();
    }

    private void expand(TreeNode node, List<String[]> treeExpansions) {
        Object[] pathNodes = this.treeModel.getPathToRoot(node);
        if (pathNodes == null) {
            return;
        }
        TreePath path = new TreePath(pathNodes);
        for (Object[] objectArray : treeExpansions) {
            if (!Arrays.equals(objectArray, MainWindow.getPathExpansion(path))) continue;
            this.tree.expandPath(path);
            break;
        }
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            this.expand(node.getChildAt(i), treeExpansions);
        }
    }

    private void toggleFlattenPackage() {
        this.setFlattenPackage(!this.isFlattenPackage);
    }

    private void setFlattenPackage(boolean value) {
        this.isFlattenPackage = value;
        this.settings.setFlattenPackage(this.isFlattenPackage);
        this.flatPkgButton.setSelected(this.isFlattenPackage);
        this.flatPkgMenuItem.setState(this.isFlattenPackage);
        Object root = this.treeModel.getRoot();
        if (root instanceof JRoot) {
            JRoot treeRoot = (JRoot)root;
            treeRoot.setFlatPackages(this.isFlattenPackage);
            this.reloadTree();
        }
    }

    private void toggleDeobfuscation() {
        boolean deobfOn = !this.settings.isDeobfuscationOn();
        this.settings.setDeobfuscationOn(deobfOn);
        this.settings.sync();
        this.deobfToggleBtn.setSelected(deobfOn);
        this.deobfMenuItem.setState(deobfOn);
        this.reopen();
    }

    private boolean nodeClickAction(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            if (obj instanceof JResource) {
                JResource res = (JResource)obj;
                ResourceFile resFile = res.getResFile();
                if (resFile != null && JResource.isSupportedForView(resFile.getType())) {
                    this.tabsController.selectTab(res);
                    return true;
                }
            } else if (obj instanceof JNode) {
                this.tabsController.codeJump((JNode)obj);
                return true;
            }
        }
        catch (Exception e) {
            LOG.error("Content loading error", (Throwable)e);
        }
        return false;
    }

    private void treeRightClickAction(MouseEvent e) {
        JNode node = this.getJNodeUnderMouse(e);
        if (node == null) {
            return;
        }
        JPopupMenu menu = node.onTreePopupMenu(this);
        if (menu != null) {
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Nullable
    private JNode getJNodeUnderMouse(MouseEvent mouseEvent) {
        TreeNode treeNode = UiUtils.getTreeNodeUnderMouse(this.tree, mouseEvent);
        if (treeNode instanceof JNode) {
            return (JNode)treeNode;
        }
        return null;
    }

    public void selectNodeInTree(JNode node) {
        if (node.getParent() == null && this.treeRoot != null && (node = this.treeRoot.searchNode(node)) == null) {
            LOG.error("Class not found in tree");
            return;
        }
        Object[] pathNodes = this.treeModel.getPathToRoot(node);
        if (pathNodes == null) {
            return;
        }
        TreePath path = new TreePath(pathNodes);
        this.tree.setSelectionPath(path);
        this.tree.makeVisible(path);
        this.tree.scrollPathToVisible(path);
        this.tree.requestFocus();
    }

    public void textSearch() {
        ContentPanel panel = this.tabbedPane.getSelectedContentPanel();
        if (panel instanceof AbstractCodeContentPanel) {
            AbstractCodeArea codeArea = ((AbstractCodeContentPanel)panel).getCodeArea();
            String preferText = codeArea.getSelectedText();
            if (StringUtils.isEmpty((String)preferText)) {
                preferText = codeArea.getWordUnderCaret();
            }
            if (!StringUtils.isEmpty((String)preferText)) {
                SearchDialog.searchText(this, preferText);
                return;
            }
        }
        SearchDialog.search(this, SearchDialog.SearchPreset.TEXT);
    }

    public void goToMainActivity() {
        AndroidManifestParser parser = new AndroidManifestParser(AndroidManifestParser.getAndroidManifest(this.getWrapper().getResources()), EnumSet.of(AppAttribute.MAIN_ACTIVITY), this.getWrapper().getArgs().getSecurity());
        if (!parser.isManifestFound()) {
            JOptionPane.showMessageDialog(this, NLS.str("error_dialog.not_found", "AndroidManifest.xml"), NLS.str("error_dialog.title"), 0);
            return;
        }
        try {
            ApplicationParams results = parser.parse();
            if (results.getMainActivity() == null) {
                throw new JadxRuntimeException("Failed to get main activity name from manifest");
            }
            JavaClass mainActivityClass = results.getMainActivityJavaClass(this.getWrapper().getDecompiler());
            if (mainActivityClass == null) {
                throw new JadxRuntimeException("Failed to find main activity class: " + results.getMainActivity());
            }
            this.tabsController.codeJump(this.getCacheObject().getNodeCache().makeFrom(mainActivityClass));
        }
        catch (Exception e) {
            LOG.error("Main activity not found", (Throwable)e);
            JOptionPane.showMessageDialog(this, NLS.str("error_dialog.not_found", "Main Activity"), NLS.str("error_dialog.title"), 0);
        }
    }

    public void goToApplication() {
        AndroidManifestParser parser = new AndroidManifestParser(AndroidManifestParser.getAndroidManifest(this.getWrapper().getResources()), EnumSet.of(AppAttribute.APPLICATION), this.getWrapper().getArgs().getSecurity());
        if (!parser.isManifestFound()) {
            JOptionPane.showMessageDialog(this, NLS.str("error_dialog.not_found", "AndroidManifest.xml"), NLS.str("error_dialog.title"), 0);
            return;
        }
        try {
            ApplicationParams results = parser.parse();
            if (results.getApplication() == null) {
                throw new JadxRuntimeException("Failed to get application from manifest");
            }
            JavaClass applicationClass = results.getApplicationJavaClass(this.getWrapper().getDecompiler());
            if (applicationClass == null) {
                throw new JadxRuntimeException("Failed to find application class: " + results.getApplication());
            }
            this.tabsController.codeJump(this.getCacheObject().getNodeCache().makeFrom(applicationClass));
        }
        catch (Exception e) {
            LOG.error("Application not found", (Throwable)e);
            JOptionPane.showMessageDialog(this, NLS.str("error_dialog.not_found", "Application"), NLS.str("error_dialog.title"), 0);
        }
    }

    public void goToAndroidManifest() {
        ResourceFile androidManifest = AndroidManifestParser.getAndroidManifest(this.getWrapper().getResources());
        if (androidManifest == null) {
            JOptionPane.showMessageDialog(this, NLS.str("error_dialog.not_found", "AndroidManifest.xml"), NLS.str("error_dialog.title"), 0);
            return;
        }
        JResource res = new JResource(androidManifest, androidManifest.getDeobfName(), JResource.JResType.FILE);
        this.tabsController.codeJump(res);
    }

    private void initMenuAndToolbar() {
        JadxGuiAction openAction = new JadxGuiAction(ActionModel.OPEN, this::openFileDialog);
        JadxGuiAction openProject = new JadxGuiAction(ActionModel.OPEN_PROJECT, this::openProjectDialog);
        JadxGuiAction addFilesAction = new JadxGuiAction(ActionModel.ADD_FILES, () -> this.addFiles());
        this.newProjectAction = new JadxGuiAction(ActionModel.NEW_PROJECT, this::newProject);
        this.saveProjectAction = new JadxGuiAction(ActionModel.SAVE_PROJECT, this::saveProject);
        JadxGuiAction saveProjectAsAction = new JadxGuiAction(ActionModel.SAVE_PROJECT_AS, this::saveProjectAs);
        JadxGuiAction reloadAction = new JadxGuiAction(ActionModel.RELOAD, () -> UiUtils.uiRun(this::reopen));
        JadxGuiAction liveReloadAction = new JadxGuiAction(ActionModel.LIVE_RELOAD, () -> this.updateLiveReload(!this.project.isEnableLiveReload()));
        this.liveReloadMenuItem = new JCheckBoxMenuItem(liveReloadAction);
        this.liveReloadMenuItem.setState(this.project.isEnableLiveReload());
        JadxGuiAction saveAllAction = new JadxGuiAction(ActionModel.SAVE_ALL, () -> this.saveAll(false));
        JadxGuiAction exportAction = new JadxGuiAction(ActionModel.EXPORT, () -> this.saveAll(true));
        JadxMenu recentProjects = new JadxMenu(NLS.str("menu.recent_projects"), this.shortcutsController);
        recentProjects.addMenuListener(new RecentProjectsMenuListener(this, recentProjects));
        JadxGuiAction prefsAction = new JadxGuiAction(ActionModel.PREFS, this::openSettings);
        JadxGuiAction exitAction = new JadxGuiAction(ActionModel.EXIT, this::closeWindow);
        this.isFlattenPackage = this.settings.isFlattenPackage();
        this.flatPkgMenuItem = new JCheckBoxMenuItem(NLS.str("menu.flatten"), ICON_FLAT_PKG);
        this.flatPkgMenuItem.setState(this.isFlattenPackage);
        JCheckBoxMenuItem heapUsageBarMenuItem = new JCheckBoxMenuItem(NLS.str("menu.heapUsageBar"));
        heapUsageBarMenuItem.setState(this.settings.isShowHeapUsageBar());
        heapUsageBarMenuItem.addActionListener(event -> {
            this.settings.setShowHeapUsageBar(!this.settings.isShowHeapUsageBar());
            this.heapUsageBar.setVisible(this.settings.isShowHeapUsageBar());
        });
        JCheckBoxMenuItem alwaysSelectOpened = new JCheckBoxMenuItem(NLS.str("menu.alwaysSelectOpened"));
        alwaysSelectOpened.setState(this.settings.isAlwaysSelectOpened());
        alwaysSelectOpened.addActionListener(event -> {
            this.settings.setAlwaysSelectOpened(!this.settings.isAlwaysSelectOpened());
            if (this.settings.isAlwaysSelectOpened()) {
                this.editorSyncManager.sync();
            }
        });
        JCheckBoxMenuItem dockLog = new JCheckBoxMenuItem(NLS.str("menu.dock_log"));
        dockLog.setState(this.settings.isDockLogViewer());
        dockLog.addActionListener(event -> this.settings.setDockLogViewer(!this.settings.isDockLogViewer()));
        JCheckBoxMenuItem dockQuickTabs = new JCheckBoxMenuItem(NLS.str("menu.dock_quick_tabs"));
        dockQuickTabs.setState(this.settings.isDockQuickTabs());
        dockQuickTabs.addActionListener(event -> {
            boolean visible = this.quickTabsTree == null;
            this.setQuickTabsVisibility(visible);
            this.settings.setDockQuickTabs(visible);
        });
        if (dockQuickTabs.getState()) {
            this.setQuickTabsVisibility(true);
        }
        JadxGuiAction syncAction = new JadxGuiAction(ActionModel.SYNC, this.editorSyncManager::sync);
        JadxGuiAction textSearchAction = new JadxGuiAction(ActionModel.TEXT_SEARCH, this::textSearch);
        JadxGuiAction clsSearchAction = new JadxGuiAction(ActionModel.CLASS_SEARCH, () -> SearchDialog.search(this, SearchDialog.SearchPreset.CLASS));
        JadxGuiAction commentSearchAction = new JadxGuiAction(ActionModel.COMMENT_SEARCH, () -> SearchDialog.search(this, SearchDialog.SearchPreset.COMMENT));
        JadxGuiAction goToMainActivityAction = new JadxGuiAction(ActionModel.GO_TO_MAIN_ACTIVITY, this::goToMainActivity);
        JadxGuiAction goToApplicationAction = new JadxGuiAction(ActionModel.GO_TO_APPLICATION, this::goToApplication);
        JadxGuiAction goToAndroidManifestAction = new JadxGuiAction(ActionModel.GO_TO_ANDROID_MANIFEST, this::goToAndroidManifest);
        JadxGuiAction decompileAllAction = new JadxGuiAction(ActionModel.DECOMPILE_ALL, this::requestFullDecompilation);
        JadxGuiAction resetCacheAction = new JadxGuiAction(ActionModel.RESET_CACHE, this::resetCodeCache);
        JadxGuiAction deobfAction = new JadxGuiAction(ActionModel.DEOBF, this::toggleDeobfuscation);
        this.deobfToggleBtn = new JToggleButton(deobfAction);
        this.deobfToggleBtn.setSelected(this.settings.isDeobfuscationOn());
        this.deobfToggleBtn.setText("");
        this.deobfMenuItem = new JCheckBoxMenuItem(deobfAction);
        this.deobfMenuItem.setState(this.settings.isDeobfuscationOn());
        JadxGuiAction showLogAction = new JadxGuiAction(ActionModel.SHOW_LOG, () -> this.showLogViewer(LogOptions.current()));
        JadxGuiAction aboutAction = new JadxGuiAction(ActionModel.ABOUT, () -> new AboutDialog().setVisible(true));
        JadxGuiAction backAction = new JadxGuiAction(ActionModel.BACK, this.navController::navBack);
        JadxGuiAction backVariantAction = new JadxGuiAction(ActionModel.BACK_V, this.navController::navBack);
        JadxGuiAction forwardAction = new JadxGuiAction(ActionModel.FORWARD, this.navController::navForward);
        JadxGuiAction forwardVariantAction = new JadxGuiAction(ActionModel.FORWARD_V, this.navController::navForward);
        JadxGuiAction quarkAction = new JadxGuiAction(ActionModel.QUARK, () -> new QuarkDialog(this).setVisible(true));
        JadxGuiAction openDeviceAction = new JadxGuiAction(ActionModel.OPEN_DEVICE, () -> new ADBDialog(this).setVisible(true));
        JadxMenu file = new JadxMenu(NLS.str("menu.file"), this.shortcutsController);
        file.setMnemonic(70);
        ((JMenu)file).add(openAction);
        ((JMenu)file).add(openProject);
        ((JMenu)file).add(addFilesAction);
        file.addSeparator();
        ((JMenu)file).add(this.newProjectAction);
        ((JMenu)file).add(this.saveProjectAction);
        ((JMenu)file).add(saveProjectAsAction);
        file.addSeparator();
        ((JMenu)file).add(reloadAction);
        ((JMenu)file).add(this.liveReloadMenuItem);
        this.renameMappings.addMenuActions(file);
        file.addSeparator();
        ((JMenu)file).add(saveAllAction);
        ((JMenu)file).add(exportAction);
        file.addSeparator();
        ((JMenu)file).add(recentProjects);
        file.addSeparator();
        ((JMenu)file).add(prefsAction);
        file.addSeparator();
        ((JMenu)file).add(exitAction);
        JadxMenu view = new JadxMenu(NLS.str("menu.view"), this.shortcutsController);
        view.setMnemonic(86);
        ((JMenu)view).add(this.flatPkgMenuItem);
        ((JMenu)view).add(syncAction);
        ((JMenu)view).add(heapUsageBarMenuItem);
        ((JMenu)view).add(alwaysSelectOpened);
        ((JMenu)view).add(dockLog);
        ((JMenu)view).add(dockQuickTabs);
        JadxMenu nav = new JadxMenu(NLS.str("menu.navigation"), this.shortcutsController);
        nav.setMnemonic(78);
        ((JMenu)nav).add(textSearchAction);
        ((JMenu)nav).add(clsSearchAction);
        ((JMenu)nav).add(commentSearchAction);
        ((JMenu)nav).add(goToMainActivityAction);
        ((JMenu)nav).add(goToApplicationAction);
        ((JMenu)nav).add(goToAndroidManifestAction);
        nav.addSeparator();
        ((JMenu)nav).add(backAction);
        ((JMenu)nav).add(forwardAction);
        this.pluginsMenu = new JadxMenu(NLS.str("menu.plugins"), this.shortcutsController);
        this.pluginsMenu.setMnemonic(80);
        this.resetPluginsMenu();
        JadxMenu tools = new JadxMenu(NLS.str("menu.tools"), this.shortcutsController);
        tools.setMnemonic(84);
        ((JMenu)tools).add(decompileAllAction);
        ((JMenu)tools).add(resetCacheAction);
        ((JMenu)tools).add(this.deobfMenuItem);
        ((JMenu)tools).add(quarkAction);
        ((JMenu)tools).add(openDeviceAction);
        JadxMenu help = new JadxMenu(NLS.str("menu.help"), this.shortcutsController);
        help.setMnemonic(72);
        ((JMenu)help).add(showLogAction);
        if (Jadx.isDevVersion()) {
            ((JMenu)help).add(new AbstractAction("Show sample error report"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExceptionDialog.throwTestException();
                }
            });
            JCheckBoxMenuItem uiWatchDog = new JCheckBoxMenuItem(new ActionHandler("UI WatchDog", UIWatchDog::toggle));
            uiWatchDog.setState(UIWatchDog.onStart());
            ((JMenu)help).add(uiWatchDog);
        }
        ((JMenu)help).add(aboutAction);
        this.menuBar = new JadxMenuBar();
        this.menuBar.add(file);
        this.menuBar.add(view);
        this.menuBar.add(nav);
        this.menuBar.add(tools);
        this.menuBar.add(this.pluginsMenu);
        this.menuBar.add(help);
        this.setJMenuBar(this.menuBar);
        this.flatPkgButton = new JToggleButton(ICON_FLAT_PKG);
        this.flatPkgButton.setSelected(this.isFlattenPackage);
        ActionListener flatPkgAction = e -> this.toggleFlattenPackage();
        this.flatPkgMenuItem.addActionListener(flatPkgAction);
        this.flatPkgButton.addActionListener(flatPkgAction);
        this.flatPkgButton.setToolTipText(NLS.str("menu.flatten"));
        this.updateLink = new Link();
        this.updateLink.setVisible(false);
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add(openAction);
        toolbar.add(addFilesAction);
        toolbar.addSeparator();
        toolbar.add(reloadAction);
        toolbar.addSeparator();
        toolbar.add(saveAllAction);
        toolbar.add(exportAction);
        toolbar.addSeparator();
        toolbar.add(syncAction);
        toolbar.add(this.flatPkgButton);
        toolbar.addSeparator();
        toolbar.add(textSearchAction);
        toolbar.add(clsSearchAction);
        toolbar.add(commentSearchAction);
        toolbar.add(goToMainActivityAction);
        toolbar.add(goToApplicationAction);
        toolbar.add(goToAndroidManifestAction);
        toolbar.addSeparator();
        toolbar.add(backAction);
        toolbar.add(forwardAction);
        toolbar.addSeparator();
        toolbar.add(this.deobfToggleBtn);
        toolbar.add(quarkAction);
        toolbar.add(openDeviceAction);
        toolbar.addSeparator();
        toolbar.add(showLogAction);
        toolbar.addSeparator();
        toolbar.add(prefsAction);
        toolbar.addSeparator();
        toolbar.add(Box.createHorizontalGlue());
        toolbar.add(this.updateLink);
        this.mainPanel.add((Component)toolbar, "North");
        ((JMenu)nav).add(new HiddenMenuItem(backVariantAction));
        ((JMenu)nav).add(new HiddenMenuItem(forwardVariantAction));
        this.shortcutsController.bind(backVariantAction);
        this.shortcutsController.bind(forwardVariantAction);
        this.addLoadListener(loaded -> {
            textSearchAction.setEnabled(loaded);
            clsSearchAction.setEnabled(loaded);
            commentSearchAction.setEnabled(loaded);
            goToMainActivityAction.setEnabled(loaded);
            goToApplicationAction.setEnabled(loaded);
            goToAndroidManifestAction.setEnabled(loaded);
            backAction.setEnabled(loaded);
            backVariantAction.setEnabled(loaded);
            forwardAction.setEnabled(loaded);
            forwardVariantAction.setEnabled(loaded);
            syncAction.setEnabled(loaded);
            saveAllAction.setEnabled(loaded);
            exportAction.setEnabled(loaded);
            saveProjectAsAction.setEnabled(loaded);
            reloadAction.setEnabled(loaded);
            decompileAllAction.setEnabled(loaded);
            deobfAction.setEnabled(loaded);
            quarkAction.setEnabled(loaded);
            resetCacheAction.setEnabled(loaded);
            return false;
        });
    }

    private void initUI() {
        this.setMinimumSize(new Dimension(200, 150));
        this.mainPanel = new JPanel(new BorderLayout());
        this.treeSplitPane = new JSplitPane();
        this.treeSplitPane.setResizeWeight(0.15);
        this.mainPanel.add(this.treeSplitPane);
        DefaultMutableTreeNode treeRootNode = new DefaultMutableTreeNode(NLS.str("msg.open_file"));
        this.treeModel = new DefaultTreeModel(treeRootNode);
        this.tree = new JTree(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setFocusable(false);
        this.tree.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                MainWindow.this.tree.setFocusable(false);
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (!MainWindow.this.nodeClickAction(MainWindow.this.getJNodeUnderMouse(e))) {
                        MainWindow.this.tree.setFocusable(true);
                        MainWindow.this.tree.requestFocus();
                    }
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    MainWindow.this.treeRightClickAction(e);
                }
            }
        });
        this.tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    MainWindow.this.nodeClickAction(MainWindow.this.tree.getLastSelectedPathComponent());
                }
            }
        });
        this.tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean isLeaf, int row, boolean focused) {
                Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, isLeaf, row, focused);
                if (value instanceof JNode) {
                    JNode jNode = (JNode)value;
                    NodeLabel.disableHtml(this, jNode.disableHtml());
                    this.setText(jNode.makeStringHtml());
                    this.setIcon(jNode.getIcon());
                    this.setToolTipText(jNode.getTooltip());
                } else {
                    this.setToolTipText(null);
                }
                if (value instanceof JPackage) {
                    this.setEnabled(((JPackage)value).isEnabled());
                }
                return c;
            }
        });
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                Object node = path.getLastPathComponent();
                if (node instanceof JLoadableNode) {
                    JLoadableNode treeNode = (JLoadableNode)node;
                    MainWindow.this.backgroundExecutor.execute(treeNode.getLoadTask());
                    MainWindow.this.backgroundExecutor.execute(NLS.str("progress.load"), UiUtils.EMPTY_RUNNABLE, status -> {
                        if (!MainWindow.this.treeReloading) {
                            MainWindow.this.treeModel.nodeStructureChanged(treeNode);
                            MainWindow.this.project.addTreeExpansion(MainWindow.getPathExpansion(event.getPath()));
                        }
                    });
                } else if (!MainWindow.this.treeReloading) {
                    MainWindow.this.project.addTreeExpansion(MainWindow.getPathExpansion(event.getPath()));
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) {
                if (!MainWindow.this.treeReloading) {
                    MainWindow.this.project.removeTreeExpansion(MainWindow.getPathExpansion(event.getPath()));
                    MainWindow.this.update();
                }
            }
        });
        this.progressPane = new ProgressPanel(this, true);
        this.issuesPanel = new IssuesPanel(this);
        JPanel leftPane = new JPanel(new BorderLayout());
        JScrollPane treeScrollPane = new JScrollPane(this.tree);
        treeScrollPane.setMinimumSize(new Dimension(100, 150));
        JPanel bottomPane = new JPanel(new BorderLayout());
        bottomPane.add((Component)this.issuesPanel, "First");
        bottomPane.add((Component)this.progressPane, "Last");
        leftPane.add((Component)treeScrollPane, "Center");
        leftPane.add((Component)bottomPane, "Last");
        this.treeSplitPane.setLeftComponent(leftPane);
        this.tabbedPane = new TabbedPane(this, this.tabsController);
        this.tabbedPane.setMinimumSize(new Dimension(150, 150));
        new TabDndController(this.tabbedPane, this.settings);
        this.quickTabsAndCodeSplitPane = new JSplitPane(1);
        this.quickTabsAndCodeSplitPane.setResizeWeight(0.15);
        this.quickTabsAndCodeSplitPane.setDividerSize(0);
        this.quickTabsAndCodeSplitPane.setRightComponent(this.tabbedPane);
        this.rightSplitPane = new JSplitPane(0);
        this.rightSplitPane.setTopComponent(this.quickTabsAndCodeSplitPane);
        this.rightSplitPane.setResizeWeight(0.15);
        this.treeSplitPane.setRightComponent(this.rightSplitPane);
        new DropTarget(this, 1, new MainDropTarget(this));
        this.heapUsageBar = new HeapUsageBar();
        this.mainPanel.add((Component)this.heapUsageBar, "South");
        this.bottomSplitPane = new JSplitPane(0);
        this.bottomSplitPane.setTopComponent(this.treeSplitPane);
        this.bottomSplitPane.setResizeWeight(0.15);
        this.mainPanel.add((Component)this.bottomSplitPane, "Center");
        this.setContentPane(this.mainPanel);
        this.setTitle(DEFAULT_TITLE);
    }

    private static String[] getPathExpansion(TreePath path) {
        ArrayList<String> pathList = new ArrayList<String>();
        while (path != null) {
            Object node = path.getLastPathComponent();
            String name = node instanceof JClass ? ((JClass)node).getCls().getClassNode().getClassInfo().getFullName() : node.toString();
            pathList.add(name);
            path = path.getParentPath();
        }
        return pathList.toArray(new String[0]);
    }

    public static void getExpandedPaths(JTree tree, TreePath path, List<TreePath> list) {
        if (tree.isExpanded(path)) {
            list.add(path);
            TreeNode node = (TreeNode)path.getLastPathComponent();
            for (int i = node.getChildCount() - 1; i >= 0; --i) {
                TreeNode n = node.getChildAt(i);
                TreePath child = path.pathByAddingChild(n);
                MainWindow.getExpandedPaths(tree, child, list);
            }
        }
    }

    public void setLocationAndPosition() {
        if (this.settings.loadWindowPos(this)) {
            return;
        }
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        DisplayMode mode = gd.getDisplayMode();
        AffineTransform trans = gd.getDefaultConfiguration().getDefaultTransform();
        int w = (int)((double)mode.getWidth() / trans.getScaleX());
        int h = (int)((double)mode.getHeight() / trans.getScaleY());
        this.setBounds((int)((double)w * 0.15), (int)((double)h * 0.15), (int)((double)w * 0.7), (int)((double)h * 0.7));
        this.setLocationRelativeTo(null);
    }

    private void setEditorTheme(String editorThemePath) {
        try {
            URL themeUrl = this.getClass().getResource(editorThemePath);
            if (themeUrl != null) {
                try (InputStream is = themeUrl.openStream();){
                    this.editorTheme = Theme.load((InputStream)is);
                    return;
                }
            }
            Path themePath = Paths.get(editorThemePath, new String[0]);
            if (Files.isRegularFile(themePath, new LinkOption[0])) {
                try (InputStream is = Files.newInputStream(themePath, new OpenOption[0]);){
                    this.editorTheme = Theme.load((InputStream)is);
                    return;
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to load editor theme: {}", (Object)editorThemePath, (Object)e);
        }
        LOG.warn("Falling back to default editor theme: {}", (Object)editorThemePath);
        editorThemePath = EditorTheme.getDefaultTheme().getPath();
        try (InputStream is = this.getClass().getResourceAsStream(editorThemePath);){
            this.editorTheme = Theme.load((InputStream)is);
            return;
        }
        catch (Exception e) {
            LOG.error("Failed to load default editor theme: {}", (Object)editorThemePath, (Object)e);
            this.editorTheme = new Theme(new RSyntaxTextArea());
            return;
        }
    }

    public Theme getEditorTheme() {
        return this.editorTheme;
    }

    private void openSettings() {
        this.settingsOpen = true;
        JadxSettingsWindow settingsWindow = new JadxSettingsWindow(this, this.settings);
        settingsWindow.setVisible(true);
        settingsWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                MainWindow.this.settingsOpen = false;
            }
        });
    }

    public boolean isSettingsOpen() {
        return this.settingsOpen;
    }

    public void loadSettings() {
        UiUtils.uiRun(this::updateUiSettings);
    }

    private void updateUiSettings() {
        LafManager.updateLaf(this.settings);
        Font font = this.settings.getFont();
        Font largerFont = font.deriveFont((float)font.getSize() + 2.0f);
        this.setFont(largerFont);
        this.setEditorTheme(this.settings.getEditorThemePath());
        this.tree.setFont(largerFont);
        this.tree.setRowHeight(-1);
        this.tabbedPane.loadSettings();
        if (this.logPanel != null) {
            this.logPanel.loadSettings();
        }
        if (this.quickTabsTree != null) {
            this.quickTabsTree.loadSettings();
        }
        this.shortcutsController.loadSettings();
    }

    private void closeWindow() {
        this.saveAll();
        if (!this.ensureProjectIsSaved()) {
            return;
        }
        this.settings.setTreeWidth(this.treeSplitPane.getDividerLocation());
        this.settings.saveWindowPos(this);
        this.settings.setMainWindowExtendedState(this.getExtendedState());
        if (this.debuggerPanel != null) {
            this.saveSplittersInfo();
        }
        this.heapUsageBar.reset();
        this.closeAll();
        this.dispose();
        System.exit(0);
    }

    private void saveOpenTabs() {
        this.project.saveOpenTabs(this.tabsController.getEditorViewStates());
    }

    private void restoreOpenTabs(List<EditorViewState> openTabs) {
        UiUtils.uiThreadGuard();
        if (openTabs.isEmpty()) {
            return;
        }
        for (EditorViewState viewState : openTabs) {
            this.tabsController.restoreEditorViewState(viewState);
        }
        this.tabsController.notifyRestoreEditorViewStateDone();
    }

    private void preLoadOpenTabs(List<EditorViewState> openTabs) {
        UiUtils.notUiThreadGuard();
        for (EditorViewState tabState : openTabs) {
            if (tabState.isHidden()) continue;
            JNode node = tabState.getNode();
            try {
                node.getCodeInfo();
            }
            catch (Exception e) {
                LOG.warn("Failed to preload code for node: {}", (Object)node, (Object)e);
            }
        }
    }

    private void saveSplittersInfo() {
        this.settings.setMainWindowVerticalSplitterLoc(this.bottomSplitPane.getDividerLocation());
        if (this.debuggerPanel != null) {
            this.settings.setDebuggerStackFrameSplitterLoc(this.debuggerPanel.getLeftSplitterLocation());
            this.settings.setDebuggerVarTreeSplitterLoc(this.debuggerPanel.getRightSplitterLocation());
        }
    }

    public void addLoadListener(ILoadListener loadListener) {
        this.loadListeners.add(loadListener);
        loadListener.update(this.loaded);
    }

    public void notifyLoadListeners(boolean loaded) {
        this.loaded = loaded;
        this.loadListeners.removeIf(listener -> listener.update(loaded));
    }

    public void addTreeUpdateListener(Consumer<JRoot> listener) {
        this.treeUpdateListener.add(listener);
    }

    public JadxWrapper getWrapper() {
        return this.wrapper;
    }

    public JadxProject getProject() {
        return this.project;
    }

    public TabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public TabsController getTabsController() {
        return this.tabsController;
    }

    public NavigationController getNavController() {
        return this.navController;
    }

    public JadxSettings getSettings() {
        return this.settings;
    }

    public CacheObject getCacheObject() {
        return this.cacheObject;
    }

    public BackgroundExecutor getBackgroundExecutor() {
        return this.backgroundExecutor;
    }

    public JRoot getTreeRoot() {
        return this.treeRoot;
    }

    public JDebuggerPanel getDebuggerPanel() {
        this.initDebuggerPanel();
        return this.debuggerPanel;
    }

    public ShortcutsController getShortcutsController() {
        return this.shortcutsController;
    }

    public void showDebuggerPanel() {
        this.initDebuggerPanel();
    }

    public void destroyDebuggerPanel() {
        this.saveSplittersInfo();
        if (this.debuggerPanel != null) {
            this.debuggerPanel.setVisible(false);
            this.debuggerPanel = null;
        }
    }

    public void showHeapUsageBar() {
        this.settings.setShowHeapUsageBar(true);
        this.heapUsageBar.setVisible(true);
    }

    private void initDebuggerPanel() {
        if (this.debuggerPanel == null) {
            this.debuggerPanel = new JDebuggerPanel(this);
            this.debuggerPanel.loadSettings();
            this.bottomSplitPane.setBottomComponent(this.debuggerPanel);
            int loc = this.settings.getMainWindowVerticalSplitterLoc();
            if (loc == 0) {
                loc = 300;
            }
            this.bottomSplitPane.setDividerLocation(loc);
        }
    }

    public void showLogViewer(LogOptions logOptions) {
        UiUtils.uiRun(() -> {
            if (this.settings.isDockLogViewer()) {
                this.showDockedLog(logOptions);
            } else {
                LogViewerDialog.open(this, logOptions);
            }
        });
    }

    private void showDockedLog(LogOptions logOptions) {
        if (this.logPanel != null) {
            this.logPanel.applyLogOptions(logOptions);
            return;
        }
        Runnable undock = () -> {
            this.hideDockedLog();
            this.settings.setDockLogViewer(false);
            LogViewerDialog.open(this, logOptions);
        };
        this.logPanel = new LogPanel(this, logOptions, undock, this::hideDockedLog);
        this.rightSplitPane.setBottomComponent(this.logPanel);
    }

    private void hideDockedLog() {
        if (this.logPanel == null) {
            return;
        }
        this.logPanel.dispose();
        this.logPanel = null;
        this.rightSplitPane.setBottomComponent(null);
    }

    private void setQuickTabsVisibility(boolean visible) {
        if (visible) {
            if (this.quickTabsTree == null) {
                this.quickTabsTree = new QuickTabsTree(this);
            }
            this.quickTabsAndCodeSplitPane.setLeftComponent(this.quickTabsTree);
            this.quickTabsAndCodeSplitPane.setDividerSize(5);
        } else {
            this.quickTabsAndCodeSplitPane.setLeftComponent(null);
            this.quickTabsAndCodeSplitPane.setDividerSize(0);
            if (this.quickTabsTree != null) {
                this.quickTabsTree.dispose();
                this.quickTabsTree = null;
            }
        }
    }

    public JMenu getPluginsMenu() {
        return this.pluginsMenu;
    }

    public void resetPluginsMenu() {
        this.pluginsMenu.removeAll();
        this.pluginsMenu.add(new ActionHandler(() -> new PluginSettings(this, this.settings).addPlugin()).withNameAndDesc(NLS.str("preferences.plugins.install")));
    }

    public void addToPluginsMenu(Action item) {
        if (this.pluginsMenu.getMenuComponentCount() == 1) {
            this.pluginsMenu.addSeparator();
        }
        this.pluginsMenu.add(item);
    }

    public RenameMappingsGui getRenameMappings() {
        return this.renameMappings;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public JadxGuiEventsImpl events() {
        return this.events;
    }
}

