/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.core.utils.files.FileUtils;
import jadx.gui.JadxWrapper;
import jadx.gui.settings.JadxProject;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JInputFiles;
import jadx.gui.treemodel.JInputScripts;
import jadx.gui.treemodel.JNode;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class JInputs
extends JNode {
    private static final ImageIcon INPUTS_ICON = UiUtils.openSvgIcon("nodes/projectStructure");

    public JInputs(JadxWrapper wrapper) {
        JadxProject project = wrapper.getProject();
        List<Path> inputs = project.getFilePaths();
        List files = FileUtils.expandDirs(inputs);
        ArrayList<Path> scripts = new ArrayList<Path>();
        Iterator it = files.iterator();
        while (it.hasNext()) {
            Path file = (Path)it.next();
            if (!file.getFileName().toString().endsWith(".jadx.kts")) continue;
            scripts.add(file);
            it.remove();
        }
        this.add(new JInputFiles(files));
        this.add(new JInputScripts(scripts));
    }

    @Override
    public JClass getJParent() {
        return null;
    }

    @Override
    public Icon getIcon() {
        return INPUTS_ICON;
    }

    @Override
    public String makeString() {
        return NLS.str("tree.inputs_title");
    }
}

