/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui;

import jadx.cli.JadxCLIArgs;
import jadx.cli.LogHelper;
import jadx.core.utils.files.FileUtils;
import jadx.gui.logs.LogCollector;
import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.JadxSettingsAdapter;
import jadx.gui.ui.ExceptionDialog;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.LafManager;
import jadx.gui.utils.NLS;
import jadx.gui.utils.SystemInfo;
import java.awt.Desktop;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxGUI {
    private static final Logger LOG = LoggerFactory.getLogger(JadxGUI.class);

    public static void main(String[] args) {
        try {
            LogCollector.register();
            JadxSettings settings = JadxSettingsAdapter.load();
            settings.setLogLevel(LogHelper.LogLevelEnum.INFO);
            if (!settings.overrideProvided(args)) {
                return;
            }
            LogHelper.initLogLevel((JadxCLIArgs)settings);
            LogHelper.setLogLevelsForDecompileStage();
            JadxGUI.printSystemInfo();
            LafManager.init(settings);
            NLS.setLocale(settings.getLangLocale());
            ExceptionDialog.registerUncaughtExceptionHandler();
            SwingUtilities.invokeLater(() -> {
                MainWindow mw = new MainWindow(settings);
                mw.init();
                JadxGUI.registerOpenFileHandler(mw);
            });
        }
        catch (Exception e) {
            LOG.error("Error: {}", (Object)e.getMessage(), (Object)e);
            System.exit(1);
        }
    }

    private static void registerOpenFileHandler(MainWindow mw) {
        try {
            Desktop desktop;
            if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.APP_OPEN_FILE)) {
                desktop.setOpenFileHandler(e -> mw.open(FileUtils.toPaths(e.getFiles())));
            }
        }
        catch (Throwable e2) {
            LOG.error("Failed to register open file handler", e2);
        }
    }

    private static void printSystemInfo() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting jadx-gui. Version: '{}'. JVM: {} {}. OS: {} {}", new Object[]{SystemInfo.JADX_VERSION, SystemInfo.JAVA_VM, SystemInfo.JAVA_VER, SystemInfo.OS_NAME, SystemInfo.OS_VERSION});
        }
    }
}

