/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex.smali;

import jadx.api.plugins.input.insns.InsnData;
import jadx.plugins.input.dex.smali.InsnFormatter;
import jadx.plugins.input.dex.smali.InsnFormatterInfo;
import jadx.plugins.input.dex.smali.SmaliCodeWriter;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SmaliInsnFormat {
    private static SmaliInsnFormat instance;
    private final Map<Integer, InsnFormatter> formatters = this.registerFormatters();

    public static synchronized SmaliInsnFormat getInstance() {
        SmaliInsnFormat instance = SmaliInsnFormat.instance;
        if (instance == null) {
            SmaliInsnFormat.instance = instance = new SmaliInsnFormat();
        }
        return instance;
    }

    private Map<Integer, InsnFormatter> registerFormatters() {
        HashMap<Integer, InsnFormatter> map = new HashMap<Integer, InsnFormatter>();
        map.put(0, fi -> fi.getCodeWriter().add("nop"));
        map.put(98, this.staticFieldInsn("sget-object"));
        map.put(106, this.staticFieldInsn("sput-boolean"));
        map.put(20, this.constInsn("const"));
        map.put(21, this.constInsn("const/high16"));
        map.put(26, this.stringInsn("const-string"));
        map.put(110, this.invokeInsn("invoke-virtual"));
        map.put(112, this.invokeInsn("invoke-direct"));
        map.put(111, this.invokeInsn("invoke-super"));
        map.put(113, this.invokeInsn("invoke-static"));
        map.put(10, this.oneArgsInsn("move-result"));
        map.put(14, this.noArgsInsn("return-void"));
        map.put(40, this.gotoInsn("goto"));
        map.put(41, this.gotoInsn("goto-16"));
        map.put(1, this.simpleInsn("move"));
        return map;
    }

    private InsnFormatter simpleInsn(String name) {
        return fi -> {
            SmaliCodeWriter code = fi.getCodeWriter();
            code.add(name);
            InsnData insn = fi.getInsn();
            int regsCount = insn.getRegsCount();
            for (int i = 0; i < regsCount; ++i) {
                if (i == 0) {
                    code.add(' ');
                } else {
                    code.add(", ");
                }
                code.add(this.regAt(fi, i));
            }
        };
    }

    private InsnFormatter gotoInsn(String name) {
        return fi -> fi.getCodeWriter().add(name).add(" :goto").add(Integer.toHexString(fi.getInsn().getTarget()));
    }

    @NotNull
    private InsnFormatter staticFieldInsn(String name) {
        return fi -> fi.getCodeWriter().add(name).add(' ').add(this.regAt(fi, 0)).add(", ").add(this.field(fi));
    }

    @NotNull
    private InsnFormatter constInsn(String name) {
        return fi -> fi.getCodeWriter().add(name).add(' ').add(this.regAt(fi, 0)).add(", ").add(this.literal(fi));
    }

    @NotNull
    private InsnFormatter stringInsn(String name) {
        return fi -> fi.getCodeWriter().add(name).add(' ').add(this.regAt(fi, 0)).add(", ").add(this.str(fi));
    }

    @NotNull
    private InsnFormatter invokeInsn(String name) {
        return fi -> {
            SmaliCodeWriter code = fi.getCodeWriter();
            code.add(name).add(' ');
            this.regsList(code, fi.getInsn());
            code.add(", ").add(this.method(fi));
        };
    }

    private InsnFormatter oneArgsInsn(String name) {
        return fi -> fi.getCodeWriter().add(name).add(' ').add(this.regAt(fi, 0));
    }

    private InsnFormatter noArgsInsn(String name) {
        return fi -> fi.getCodeWriter().add(name);
    }

    private String literal(InsnFormatterInfo fi) {
        return "0x" + Long.toHexString(fi.getInsn().getLiteral());
    }

    private String str(InsnFormatterInfo fi) {
        return "\"" + fi.getInsn().getIndexAsString() + "\"";
    }

    private String field(InsnFormatterInfo fi) {
        return fi.getInsn().getIndexAsField().toString();
    }

    private String method(InsnFormatterInfo fi) {
        return fi.getInsn().getIndexAsMethod().toString();
    }

    private void regsList(SmaliCodeWriter code, InsnData insn) {
        int argsCount = insn.getRegsCount();
        code.add('{');
        for (int i = 0; i < argsCount; ++i) {
            if (i != 0) {
                code.add(", ");
            }
            code.add("v").add(insn.getReg(i));
        }
        code.add('}');
    }

    private String regAt(InsnFormatterInfo fi, int argNum) {
        return "v" + fi.getInsn().getReg(argNum);
    }

    public void format(InsnFormatterInfo formatInfo) {
        InsnData insn = formatInfo.getInsn();
        insn.decode();
        int rawOpcodeUnit = insn.getRawOpcodeUnit();
        int opcode = rawOpcodeUnit & 0xFF;
        InsnFormatter insnFormatter = this.formatters.get(opcode);
        if (insnFormatter != null) {
            insnFormatter.format(formatInfo);
        } else {
            formatInfo.getCodeWriter().add("# ").add(insn.getOpcode()).add(" (?0x").add(Integer.toHexString(rawOpcodeUnit)).add(')');
        }
    }

    public String format(InsnData insn) {
        InsnFormatterInfo formatInfo = new InsnFormatterInfo(new SmaliCodeWriter(), insn);
        this.format(formatInfo);
        return formatInfo.getCodeWriter().getCode();
    }
}

