/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex.sections;

import jadx.api.plugins.input.data.ICallSite;
import jadx.api.plugins.input.data.IFieldRef;
import jadx.api.plugins.input.data.IMethodHandle;
import jadx.api.plugins.input.data.IMethodRef;
import jadx.api.plugins.input.data.MethodHandleType;
import jadx.api.plugins.input.data.impl.CallSite;
import jadx.api.plugins.input.data.impl.FieldRefHandle;
import jadx.api.plugins.input.data.impl.MethodRefHandle;
import jadx.plugins.input.dex.DexReader;
import jadx.plugins.input.dex.sections.DexFieldData;
import jadx.plugins.input.dex.sections.DexHeader;
import jadx.plugins.input.dex.sections.DexMethodProto;
import jadx.plugins.input.dex.sections.DexMethodRef;
import jadx.plugins.input.dex.sections.annotations.EncodedValueParser;
import jadx.plugins.input.dex.utils.Leb128;
import jadx.plugins.input.dex.utils.MUtf8;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class SectionReader {
    private final ByteBuffer buf;
    private final DexReader dexReader;
    private int offset;

    public SectionReader(DexReader dexReader, int off) {
        this.dexReader = dexReader;
        this.offset = off;
        this.buf = SectionReader.duplicate(dexReader.getBuf(), off);
    }

    private SectionReader(SectionReader sectionReader, int off) {
        this(sectionReader.dexReader, off);
    }

    public SectionReader copy() {
        return new SectionReader(this, this.offset);
    }

    public SectionReader copy(int off) {
        return new SectionReader(this, off);
    }

    public byte[] getByteCode(int start, int len) {
        int pos = this.buf.position();
        this.buf.position(start);
        byte[] bytes = this.readByteArray(len);
        this.buf.position(pos);
        return bytes;
    }

    private static ByteBuffer duplicate(ByteBuffer baseBuffer, int off) {
        ByteBuffer dupBuf = baseBuffer.duplicate();
        dupBuf.order(ByteOrder.LITTLE_ENDIAN);
        dupBuf.position(off);
        return dupBuf;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public void shiftOffset(int shift) {
        this.offset += shift;
    }

    public SectionReader pos(int pos) {
        this.buf.position(this.offset + pos);
        return this;
    }

    public SectionReader absPos(int pos) {
        this.buf.position(pos);
        return this;
    }

    public int getAbsPos() {
        return this.buf.position();
    }

    public void skip(int skip) {
        int pos = this.buf.position();
        this.buf.position(pos + skip);
    }

    public int readInt() {
        return this.buf.getInt();
    }

    public long readLong() {
        return this.buf.getLong();
    }

    public byte readByte() {
        return this.buf.get();
    }

    public int readUByte() {
        return this.buf.get() & 0xFF;
    }

    public int readUShort() {
        return this.buf.getShort() & 0xFFFF;
    }

    public int readShort() {
        return this.buf.getShort();
    }

    public byte[] readByteArray(int len) {
        byte[] arr = new byte[len];
        this.buf.get(arr);
        return arr;
    }

    public int[] readUShortArray(int size) {
        int[] arr = new int[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = this.readUShort();
        }
        return arr;
    }

    public String readString(int len) {
        return new String(this.readByteArray(len), StandardCharsets.US_ASCII);
    }

    private List<String> readTypeListAt(int paramsOff) {
        if (paramsOff == 0) {
            return Collections.emptyList();
        }
        return this.absPos(paramsOff).readTypeList();
    }

    public List<String> readTypeList() {
        int size = this.readInt();
        if (size == 0) {
            return Collections.emptyList();
        }
        int[] typeIds = this.readUShortArray(size);
        ArrayList<String> types = new ArrayList<String>(size);
        for (int typeId : typeIds) {
            types.add(this.getType(typeId));
        }
        return types;
    }

    @Nullable
    public String getType(int idx) {
        if (idx == -1) {
            return null;
        }
        int typeIdsOff = this.dexReader.getHeader().getTypeIdsOff();
        this.absPos(typeIdsOff + idx * 4);
        int strIdx = this.readInt();
        return this.getString(strIdx);
    }

    @Nullable
    public String getString(int idx) {
        if (idx == -1) {
            return null;
        }
        int stringIdsOff = this.dexReader.getHeader().getStringIdsOff();
        this.absPos(stringIdsOff + idx * 4);
        int strOff = this.readInt();
        this.absPos(strOff);
        return MUtf8.decode(this);
    }

    public IFieldRef getFieldRef(int idx) {
        DexFieldData fieldData = new DexFieldData(null);
        int clsTypeIdx = this.fillFieldData(fieldData, idx);
        fieldData.setParentClassType(this.getType(clsTypeIdx));
        return fieldData;
    }

    public int fillFieldData(DexFieldData fieldData, int idx) {
        int fieldIdsOff = this.dexReader.getHeader().getFieldIdsOff();
        this.absPos(fieldIdsOff + idx * 8);
        int classTypeIdx = this.readUShort();
        int typeIdx = this.readUShort();
        int nameIdx = this.readInt();
        fieldData.setType(this.getType(typeIdx));
        fieldData.setName(this.getString(nameIdx));
        return classTypeIdx;
    }

    public DexMethodRef getMethodRef(int idx) {
        DexMethodRef methodRef = new DexMethodRef();
        this.initMethodRef(idx, methodRef);
        return methodRef;
    }

    public ICallSite getCallSite(int idx, SectionReader ext) {
        int callSiteOff = this.dexReader.getHeader().getCallSiteOff();
        this.absPos(callSiteOff + idx * 4);
        this.absPos(this.readInt());
        return new CallSite(EncodedValueParser.parseEncodedArray(this, ext));
    }

    public IMethodHandle getMethodHandle(int idx) {
        int methodHandleOff = this.dexReader.getHeader().getMethodHandleOff();
        this.absPos(methodHandleOff + idx * 8);
        MethodHandleType handleType = this.getMethodHandleType(this.readUShort());
        this.skip(2);
        int refId = this.readUShort();
        if (handleType.isField()) {
            return new FieldRefHandle(handleType, this.getFieldRef(refId));
        }
        return new MethodRefHandle(handleType, (IMethodRef)this.getMethodRef(refId));
    }

    private MethodHandleType getMethodHandleType(int type) {
        switch (type) {
            case 0: {
                return MethodHandleType.STATIC_PUT;
            }
            case 1: {
                return MethodHandleType.STATIC_GET;
            }
            case 2: {
                return MethodHandleType.INSTANCE_PUT;
            }
            case 3: {
                return MethodHandleType.INSTANCE_GET;
            }
            case 4: {
                return MethodHandleType.INVOKE_STATIC;
            }
            case 5: {
                return MethodHandleType.INVOKE_INSTANCE;
            }
            case 6: {
                return MethodHandleType.INVOKE_CONSTRUCTOR;
            }
            case 7: {
                return MethodHandleType.INVOKE_DIRECT;
            }
            case 8: {
                return MethodHandleType.INVOKE_INTERFACE;
            }
        }
        throw new IllegalArgumentException("Unknown method handle type: 0x" + Integer.toHexString(type));
    }

    public void initMethodRef(int idx, DexMethodRef methodRef) {
        methodRef.initUniqId(this.dexReader, idx);
        methodRef.setDexIdx(idx);
        methodRef.setSectionReader(this);
    }

    public void loadMethodRef(DexMethodRef methodRef, int idx) {
        DexHeader header = this.dexReader.getHeader();
        int methodIdsOff = header.getMethodIdsOff();
        this.absPos(methodIdsOff + idx * 8);
        int classTypeIdx = this.readUShort();
        int protoIdx = this.readUShort();
        int nameIdx = this.readInt();
        int protoIdsOff = header.getProtoIdsOff();
        this.absPos(protoIdsOff + protoIdx * 12);
        this.skip(4);
        int returnTypeIdx = this.readInt();
        int paramsOff = this.readInt();
        List<String> argTypes = this.readTypeListAt(paramsOff);
        methodRef.setParentClassType(this.getType(classTypeIdx));
        methodRef.setName(this.getString(nameIdx));
        methodRef.setReturnType(this.getType(returnTypeIdx));
        methodRef.setArgTypes(argTypes);
    }

    public DexMethodProto getMethodProto(int idx) {
        int protoIdsOff = this.dexReader.getHeader().getProtoIdsOff();
        this.absPos(protoIdsOff + idx * 12);
        this.skip(4);
        int returnTypeIdx = this.readInt();
        int paramsOff = this.readInt();
        return new DexMethodProto(this.readTypeListAt(paramsOff), this.getType(returnTypeIdx));
    }

    public List<String> getMethodParamTypes(int idx) {
        DexHeader header = this.dexReader.getHeader();
        int methodIdsOff = header.getMethodIdsOff();
        this.absPos(methodIdsOff + idx * 8 + 2);
        int protoIdx = this.readUShort();
        int protoIdsOff = header.getProtoIdsOff();
        this.absPos(protoIdsOff + protoIdx * 12 + 8);
        int paramsOff = this.readInt();
        if (paramsOff == 0) {
            return Collections.emptyList();
        }
        return this.absPos(paramsOff).readTypeList();
    }

    public DexReader getDexReader() {
        return this.dexReader;
    }

    public int readUleb128() {
        return Leb128.readUnsignedLeb128(this);
    }

    public int readUleb128p1() {
        return Leb128.readUnsignedLeb128(this) - 1;
    }

    public int readSleb128() {
        return Leb128.readSignedLeb128(this);
    }

    public String toString() {
        return "SectionReader{buf=" + this.buf + ", offset=" + this.offset + "}";
    }
}

