/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex.sections;

import jadx.api.plugins.input.data.IMethodRef;
import jadx.api.plugins.utils.Utils;
import jadx.plugins.input.dex.DexReader;
import jadx.plugins.input.dex.sections.SectionReader;
import java.util.List;

public class DexMethodRef
implements IMethodRef {
    private int uniqId;
    private String name;
    private String parentClassType;
    private String returnType;
    private List<String> argTypes;
    private int dexIdx;
    private SectionReader sectionReader;

    public void initUniqId(DexReader dexReader, int idx) {
        this.uniqId = (dexReader.getUniqId() & 0xFFFF) << 16 | idx & 0xFFFF;
    }

    public void load() {
        if (this.sectionReader != null) {
            this.sectionReader.loadMethodRef(this, this.dexIdx);
            this.sectionReader = null;
        }
    }

    public void setDexIdx(int dexIdx) {
        this.dexIdx = dexIdx;
    }

    public void setSectionReader(SectionReader sectionReader) {
        this.sectionReader = sectionReader;
    }

    public int getUniqId() {
        return this.uniqId;
    }

    public void reset() {
        this.name = null;
        this.parentClassType = null;
        this.returnType = null;
        this.argTypes = null;
    }

    public String getParentClassType() {
        return this.parentClassType;
    }

    public void setParentClassType(String parentClassType) {
        this.parentClassType = parentClassType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public List<String> getArgTypes() {
        return this.argTypes;
    }

    public void setArgTypes(List<String> argTypes) {
        this.argTypes = argTypes;
    }

    public String toString() {
        if (this.name == null) {
            return Integer.toHexString(this.uniqId);
        }
        return this.getParentClassType() + "->" + this.getName() + '(' + Utils.listToStr(this.getArgTypes()) + ")" + this.getReturnType();
    }
}

