/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex;

import jadx.api.plugins.JadxPluginInfo;
import jadx.api.plugins.input.JadxInputPlugin;
import jadx.api.plugins.input.data.ILoadResult;
import jadx.api.plugins.input.data.impl.EmptyLoadResult;
import jadx.api.plugins.options.JadxPluginOptions;
import jadx.api.plugins.options.OptionDescription;
import jadx.plugins.input.dex.DexFileLoader;
import jadx.plugins.input.dex.DexInputOptions;
import jadx.plugins.input.dex.DexLoadResult;
import jadx.plugins.input.dex.DexReader;
import java.io.Closeable;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class DexInputPlugin
implements JadxInputPlugin,
JadxPluginOptions {
    public static final String PLUGIN_ID = "dex-input";
    private final DexInputOptions options = new DexInputOptions();
    private final DexFileLoader loader = new DexFileLoader(this.options);

    public JadxPluginInfo getPluginInfo() {
        return new JadxPluginInfo(PLUGIN_ID, "DexInput", "Load .dex and .apk files");
    }

    public ILoadResult loadFiles(List<Path> input) {
        return this.loadFiles(input, null);
    }

    public ILoadResult loadFiles(List<Path> inputFiles, @Nullable Closeable closeable) {
        List<DexReader> dexReaders = this.loader.collectDexFiles(inputFiles);
        if (dexReaders.isEmpty()) {
            return EmptyLoadResult.INSTANCE;
        }
        return new DexLoadResult(dexReaders, closeable);
    }

    public void setOptions(Map<String, String> options) {
        this.options.apply(options);
    }

    public List<OptionDescription> getOptionsDescriptions() {
        return this.options.buildOptionsDescriptions();
    }
}

