/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen.entry;

import jadx.core.xmlgen.entry.ProtoValue;
import jadx.core.xmlgen.entry.RawNamedValue;
import jadx.core.xmlgen.entry.RawValue;
import java.util.List;

public final class ResourceEntry {
    private final int id;
    private final String pkgName;
    private final String typeName;
    private final String keyName;
    private final String config;
    private int parentRef;
    private ProtoValue protoValue;
    private RawValue simpleValue;
    private List<RawNamedValue> namedValues;

    public ResourceEntry(int id, String pkgName, String typeName, String keyName, String config) {
        this.id = id;
        this.pkgName = pkgName;
        this.typeName = typeName;
        this.keyName = keyName;
        this.config = config;
    }

    public ResourceEntry copy(String newKeyName) {
        ResourceEntry copy = new ResourceEntry(this.id, this.pkgName, this.typeName, newKeyName, this.config);
        copy.parentRef = this.parentRef;
        copy.protoValue = this.protoValue;
        copy.simpleValue = this.simpleValue;
        copy.namedValues = this.namedValues;
        return copy;
    }

    public ResourceEntry copyWithId(String resName) {
        return this.copy(String.format("%s_res_0x%08x", resName, this.id));
    }

    public int getId() {
        return this.id;
    }

    public String getPkgName() {
        return this.pkgName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getConfig() {
        return this.config;
    }

    public void setParentRef(int parentRef) {
        this.parentRef = parentRef;
    }

    public int getParentRef() {
        return this.parentRef;
    }

    public ProtoValue getProtoValue() {
        return this.protoValue;
    }

    public void setProtoValue(ProtoValue protoValue) {
        this.protoValue = protoValue;
    }

    public RawValue getSimpleValue() {
        return this.simpleValue;
    }

    public void setSimpleValue(RawValue simpleValue) {
        this.simpleValue = simpleValue;
    }

    public void setNamedValues(List<RawNamedValue> namedValues) {
        this.namedValues = namedValues;
    }

    public List<RawNamedValue> getNamedValues() {
        return this.namedValues;
    }

    public String toString() {
        return "  0x" + Integer.toHexString(this.id) + " (" + this.id + ")" + this.config + " = " + this.typeName + "." + this.keyName;
    }
}

