/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils.tasks;

import jadx.api.JadxArgs;
import jadx.api.utils.tasks.ITaskExecutor;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutor
implements ITaskExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(TaskExecutor.class);
    private final List<ExecStage> stages = new ArrayList<ExecStage>();
    private final AtomicInteger threadsCount = new AtomicInteger(JadxArgs.DEFAULT_THREADS_COUNT);
    private final AtomicInteger progress = new AtomicInteger(0);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AtomicBoolean terminating = new AtomicBoolean(false);
    private final Object executorSync = new Object();
    @Nullable
    private ExecutorService executor;
    private int tasksCount = 0;
    @Nullable
    private Error terminateError;

    @Override
    public void addParallelTasks(List<? extends Runnable> parallelTasks) {
        if (parallelTasks.isEmpty()) {
            return;
        }
        this.tasksCount += parallelTasks.size();
        this.stages.add(new ExecStage(ExecType.PARALLEL, parallelTasks));
    }

    @Override
    public void addSequentialTasks(List<? extends Runnable> seqTasks) {
        if (seqTasks.isEmpty()) {
            return;
        }
        this.tasksCount += seqTasks.size();
        this.stages.add(new ExecStage(ExecType.SEQUENTIAL, seqTasks));
    }

    @Override
    public void addSequentialTask(Runnable seqTask) {
        this.addSequentialTasks(Collections.singletonList(seqTask));
    }

    @Override
    public int getThreadsCount() {
        return this.threadsCount.get();
    }

    @Override
    public void setThreadsCount(int count) {
        this.threadsCount.set(count);
    }

    @Override
    public int getTasksCount() {
        return this.tasksCount;
    }

    @Override
    public int getProgress() {
        return this.progress.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        Object object = this.executorSync;
        synchronized (object) {
            if (this.running.get() || this.executor != null) {
                throw new IllegalStateException("Already executing");
            }
            this.executor = Executors.newFixedThreadPool(1, Utils.simpleThreadFactory("task-s"));
            this.running.set(true);
            this.terminating.set(false);
            this.progress.set(0);
            this.executor.execute(this::runStages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopExecution() {
        Object object = this.executorSync;
        synchronized (object) {
            this.running.set(false);
            this.terminating.set(true);
            if (this.executor != null) {
                this.executor.shutdown();
                this.executor = null;
            }
        }
    }

    @Override
    public void awaitTermination() {
        Error error;
        ExecutorService activeExecutor = this.executor;
        if (activeExecutor != null && this.running.get()) {
            TaskExecutor.awaitExecutorTermination(activeExecutor);
        }
        if ((error = this.terminateError) != null) {
            throw error;
        }
    }

    @Override
    public void terminate() {
        this.terminating.set(true);
    }

    private void terminateWithError(Error error) {
        if (this.terminating.get()) {
            return;
        }
        this.terminateError = error;
        this.terminate();
        this.executor.shutdownNow();
    }

    @Override
    public boolean isTerminating() {
        return this.terminating.get();
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    @Nullable
    public ExecutorService getInternalExecutor() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runStages() {
        try {
            for (ExecStage stage : this.stages) {
                int threads = Math.min(stage.getTasks().size(), this.threadsCount.get());
                if (stage.getType() == ExecType.SEQUENTIAL || threads == 1) {
                    for (Runnable runnable : stage.getTasks()) {
                        this.wrapTask(runnable);
                    }
                } else {
                    ExecutorService parallelExecutor = Executors.newFixedThreadPool(threads, Utils.simpleThreadFactory("task-p"));
                    for (Runnable runnable : stage.getTasks()) {
                        parallelExecutor.execute(() -> this.wrapTask(task));
                    }
                    parallelExecutor.shutdown();
                    TaskExecutor.awaitExecutorTermination(parallelExecutor);
                }
                if (!this.terminating.get()) continue;
                break;
            }
        }
        finally {
            this.stopExecution();
        }
    }

    private void wrapTask(Runnable task) {
        if (this.terminating.get()) {
            return;
        }
        try {
            task.run();
            this.progress.incrementAndGet();
        }
        catch (Error e) {
            this.terminateWithError(e);
        }
        catch (Exception e) {
            LOG.error("Unhandled task exception:", (Throwable)e);
        }
    }

    public static void awaitExecutorTermination(ExecutorService executor) {
        try {
            boolean complete = executor.awaitTermination(10L, TimeUnit.DAYS);
            if (!complete) {
                throw new JadxRuntimeException("Executor timeout");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static final class ExecStage {
        private final ExecType type;
        private final List<? extends Runnable> tasks;

        private ExecStage(ExecType type, List<? extends Runnable> tasks) {
            this.type = type;
            this.tasks = tasks;
        }

        public ExecType getType() {
            return this.type;
        }

        public List<? extends Runnable> getTasks() {
            return this.tasks;
        }
    }

    private static enum ExecType {
        PARALLEL,
        SEQUENTIAL;

    }
}

