/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils.blocks;

import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.EmptyBitSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockSet
implements Iterable<BlockNode> {
    private final MethodNode mth;
    private final BitSet bs;

    public static BlockSet empty(MethodNode mth) {
        return new BlockSet(mth);
    }

    public static BlockSet from(MethodNode mth, Collection<BlockNode> blocks) {
        BlockSet newBS = new BlockSet(mth);
        newBS.addAll(blocks);
        return newBS;
    }

    public BlockSet(MethodNode mth) {
        this.mth = mth;
        this.bs = new BitSet(mth.getBasicBlocks().size());
    }

    public boolean contains(BlockNode block) {
        return this.bs.get(block.getPos());
    }

    public void add(BlockNode block) {
        this.bs.set(block.getPos());
    }

    public void addAll(Collection<BlockNode> blocks) {
        blocks.forEach(this::add);
    }

    public void addAll(BlockSet otherBlockSet) {
        this.bs.or(otherBlockSet.bs);
    }

    public void remove(BlockNode block) {
        this.bs.clear(block.getPos());
    }

    public void remove(Collection<BlockNode> blocks) {
        blocks.forEach(this::remove);
    }

    public boolean addChecked(BlockNode block) {
        int id = block.getPos();
        boolean state = this.bs.get(id);
        this.bs.set(id);
        return state;
    }

    public boolean containsAll(List<BlockNode> blocks) {
        for (BlockNode block : blocks) {
            if (this.contains(block)) continue;
            return false;
        }
        return true;
    }

    public boolean intersects(List<BlockNode> blocks) {
        for (BlockNode block : blocks) {
            if (!this.contains(block)) continue;
            return true;
        }
        return false;
    }

    public BlockSet intersect(List<BlockNode> blocks) {
        BlockSet input = BlockSet.from(this.mth, blocks);
        BlockSet result = new BlockSet(this.mth);
        BitSet resultBS = result.bs;
        resultBS.or(this.bs);
        resultBS.and(input.bs);
        return result;
    }

    public boolean isEmpty() {
        return this.bs.isEmpty();
    }

    public int size() {
        return this.bs.cardinality();
    }

    public void remove() {
        this.bs.clear();
    }

    @Nullable
    public BlockNode getOne() {
        if (this.bs.cardinality() == 1) {
            return this.mth.getBasicBlocks().get(this.bs.nextSetBit(0));
        }
        return null;
    }

    public BlockNode getFirst() {
        return this.mth.getBasicBlocks().get(this.bs.nextSetBit(0));
    }

    @Override
    public void forEach(Consumer<? super BlockNode> consumer) {
        if (this.bs.isEmpty()) {
            return;
        }
        List<BlockNode> blocks = this.mth.getBasicBlocks();
        int i = this.bs.nextSetBit(0);
        while (i >= 0) {
            consumer.accept(blocks.get(i));
            i = this.bs.nextSetBit(i + 1);
        }
    }

    @Override
    @NotNull
    public Iterator<BlockNode> iterator() {
        return new BlockSetIterator(this.bs, this.size(), this.mth.getBasicBlocks());
    }

    @Override
    public Spliterator<BlockNode> spliterator() {
        int size = this.size();
        BlockSetIterator iterator = new BlockSetIterator(this.bs, size, this.mth.getBasicBlocks());
        return Spliterators.spliterator(iterator, (long)size, 17);
    }

    public List<BlockNode> toList() {
        if (this.bs == null || this.bs == EmptyBitSet.EMPTY) {
            return Collections.emptyList();
        }
        int size = this.bs.cardinality();
        if (size == 0) {
            return Collections.emptyList();
        }
        List<BlockNode> mthBlocks = this.mth.getBasicBlocks();
        ArrayList<BlockNode> blocks = new ArrayList<BlockNode>(size);
        int i = this.bs.nextSetBit(0);
        while (i >= 0) {
            blocks.add(mthBlocks.get(i));
            i = this.bs.nextSetBit(i + 1);
        }
        return blocks;
    }

    public String toString() {
        return this.toList().toString();
    }

    private static final class BlockSetIterator
    implements Iterator<BlockNode> {
        private final BitSet bs;
        private final int size;
        private final List<BlockNode> blocks;
        private int cursor;
        private int start;

        public BlockSetIterator(BitSet bs, int size, List<BlockNode> blocks) {
            this.bs = bs;
            this.size = size;
            this.blocks = blocks;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.size;
        }

        @Override
        public BlockNode next() {
            int pos = this.bs.nextSetBit(this.start);
            if (pos == -1) {
                throw new NoSuchElementException();
            }
            this.start = pos + 1;
            ++this.cursor;
            return this.blocks.get(pos);
        }
    }
}

