/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils.android;

import jadx.core.utils.android.TextResMapFile;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.io.InputStream;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class AndroidResourcesMap {
    private static final Map<Integer, String> RES_MAP = AndroidResourcesMap.loadBundled();

    @Nullable
    public static String getResName(int resId) {
        return RES_MAP.get(resId);
    }

    public static Map<Integer, String> getMap() {
        return RES_MAP;
    }

    private static Map<Integer, String> loadBundled() {
        Map<Integer, String> map;
        block8: {
            InputStream is = AndroidResourcesMap.class.getResourceAsStream("/android/res-map.txt");
            try {
                map = TextResMapFile.read(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new JadxRuntimeException("Failed to load android resource file (res-map.txt)", e);
                }
            }
            is.close();
        }
        return map;
    }
}

