/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.api.JadxArgs;
import jadx.api.args.IntegerFormat;
import jadx.core.deobf.NameMapper;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.IntConsumer;
import org.jetbrains.annotations.Nullable;

public class StringUtils {
    private static final StringUtils DEFAULT_INSTANCE = new StringUtils(new JadxArgs());
    private static final String WHITES = " \t\r\n\f\b";
    private static final String WORD_SEPARATORS = " \t\r\n\f\b(\")<,>{}=+-*/|[]\\:;'.`~!#^&";
    private final boolean escapeUnicode;
    private final IntegerFormat integerFormat;

    public static StringUtils getInstance() {
        return DEFAULT_INSTANCE;
    }

    public StringUtils(JadxArgs args) {
        this.escapeUnicode = args.isEscapeUnicode();
        this.integerFormat = args.getIntegerFormat();
    }

    public IntegerFormat getIntegerFormat() {
        return this.integerFormat;
    }

    public static void visitCodePoints(String str, IntConsumer visitor) {
        int codePoint;
        int len = str.length();
        for (int offset = 0; offset < len; offset += Character.charCount(codePoint)) {
            codePoint = str.codePointAt(offset);
            visitor.accept(codePoint);
        }
    }

    public String unescapeString(String str) {
        int len = str.length();
        if (len == 0) {
            return "\"\"";
        }
        StringBuilder res = new StringBuilder();
        res.append('\"');
        StringUtils.visitCodePoints(str, codePoint -> this.processCodePoint(codePoint, res));
        res.append('\"');
        return res.toString();
    }

    private void processCodePoint(int codePoint, StringBuilder res) {
        String str = this.getSpecialStringForCodePoint(codePoint);
        if (str != null) {
            res.append(str);
            return;
        }
        if (this.isEscapeNeededForCodePoint(codePoint)) {
            res.append("\\u").append(String.format("%04x", codePoint));
        } else {
            res.appendCodePoint(codePoint);
        }
    }

    private boolean isEscapeNeededForCodePoint(int codePoint) {
        if (codePoint < 32) {
            return true;
        }
        if (codePoint < 127) {
            return false;
        }
        if (this.escapeUnicode) {
            return true;
        }
        return !NameMapper.isPrintableCodePoint(codePoint);
    }

    public String unescapeChar(char c, boolean explicitCast) {
        if (c == '\'') {
            return "'\\''";
        }
        String str = this.getSpecialStringForCodePoint(c);
        if (str != null) {
            return "'" + str + "'";
        }
        if (c >= '\u007f' && this.escapeUnicode) {
            return String.format("'\\u%04x'", c);
        }
        if (NameMapper.isPrintableChar(c)) {
            return "'" + c + "'";
        }
        String intStr = Integer.toString(c);
        return explicitCast ? "(char) " + intStr : intStr;
    }

    public String unescapeChar(char ch) {
        return this.unescapeChar(ch, false);
    }

    @Nullable
    private String getSpecialStringForCodePoint(int c) {
        switch (c) {
            case 10: {
                return "\\n";
            }
            case 13: {
                return "\\r";
            }
            case 9: {
                return "\\t";
            }
            case 8: {
                return "\\b";
            }
            case 12: {
                return "\\f";
            }
            case 39: {
                return "'";
            }
            case 34: {
                return "\\\"";
            }
            case 92: {
                return "\\\\";
            }
        }
        return null;
    }

    public static String escape(String str) {
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        block5: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case ' ': 
                case '$': 
                case ',': 
                case '.': 
                case '/': 
                case ';': 
                case '<': {
                    sb.append('_');
                    continue block5;
                }
                case '[': {
                    sb.append('A');
                    continue block5;
                }
                case '*': 
                case '>': 
                case '?': 
                case ']': {
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String escapeXML(String str) {
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            String replace = StringUtils.escapeXmlChar(c);
            if (replace != null) {
                sb.append(replace);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String escapeResValue(String str) {
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            StringUtils.commonEscapeAndAppend(sb, c);
        }
        return sb.toString();
    }

    public static String escapeResStrValue(String str) {
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        block4: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block4;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block4;
                }
                default: {
                    StringUtils.commonEscapeAndAppend(sb, c);
                }
            }
        }
        return sb.toString();
    }

    private static String escapeXmlChar(char c) {
        if (c <= '\u001f') {
            return "\\" + c;
        }
        switch (c) {
            case '&': {
                return "&amp;";
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&apos;";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return null;
    }

    private static String escapeWhiteSpaceChar(char c) {
        switch (c) {
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
            case '\b': {
                return "\\b";
            }
            case '\f': {
                return "\\f";
            }
        }
        return null;
    }

    private static void commonEscapeAndAppend(StringBuilder sb, char c) {
        String replace = StringUtils.escapeWhiteSpaceChar(c);
        if (replace == null) {
            replace = StringUtils.escapeXmlChar(c);
        }
        if (replace != null) {
            sb.append(replace);
        } else {
            sb.append(c);
        }
    }

    public static boolean notEmpty(String str) {
        return str != null && !str.isEmpty();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean notBlank(String str) {
        return StringUtils.notEmpty(str) && !str.trim().isEmpty();
    }

    public static int countMatches(String str, String subStr) {
        if (str == null || str.isEmpty() || subStr == null || subStr.isEmpty()) {
            return 0;
        }
        int subStrLen = subStr.length();
        int count = 0;
        int idx = 0;
        while ((idx = str.indexOf(subStr, idx)) != -1) {
            ++count;
            idx += subStrLen;
        }
        return count;
    }

    public static boolean containsChar(String str, char ch) {
        return str.indexOf(ch) != -1;
    }

    public static String removeChar(String str, char ch) {
        int pos = str.indexOf(ch);
        if (pos == -1) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str.length());
        int cur = 0;
        int next = pos;
        do {
            sb.append(str, cur, next);
        } while ((next = str.indexOf(ch, cur = next + 1)) != -1);
        sb.append(str, cur, str.length());
        return sb.toString();
    }

    public static int countLinesByPos(String content, int pos, int start) {
        if (start >= pos) {
            return 0;
        }
        int count = 0;
        int tempPos = start;
        while ((tempPos = content.indexOf("\n", tempPos)) != -1 && tempPos < pos) {
            ++count;
            if (++tempPos < content.length()) continue;
        }
        return count;
    }

    public static String getLine(String content, int pos, int end) {
        int endPos;
        int headPos;
        if (pos >= content.length()) {
            return "";
        }
        if (end != -1) {
            if (end > content.length()) {
                end = content.length() - 1;
            }
        } else {
            end = pos + 1;
        }
        if ((headPos = content.lastIndexOf("\n", pos)) == -1) {
            headPos = 0;
        }
        if ((endPos = content.indexOf("\n", end)) == -1) {
            endPos = content.length();
        }
        return content.substring(headPos, endPos);
    }

    public static boolean isWhite(char chr) {
        return WHITES.indexOf(chr) != -1;
    }

    public static boolean isWordSeparator(char chr) {
        return WORD_SEPARATORS.indexOf(chr) != -1;
    }

    public static String removeSuffix(String str, String suffix) {
        if (str.endsWith(suffix)) {
            return str.substring(0, str.length() - suffix.length());
        }
        return str;
    }

    @Nullable
    public static String getPrefix(String str, String delim) {
        int idx = str.indexOf(delim);
        if (idx != -1) {
            return str.substring(0, idx);
        }
        return null;
    }

    public static String getDateText() {
        return new SimpleDateFormat("HH:mm:ss").format(new Date());
    }

    private String formatNumber(long number, int bytesLen, boolean cast) {
        Object numStr;
        if (this.integerFormat.isHexadecimal()) {
            String hexStr = Long.toHexString(number);
            if (number < 0L) {
                int len = hexStr.length();
                numStr = "0x" + hexStr.substring(len - bytesLen * 2, len);
                cast = true;
            } else {
                numStr = "0x" + hexStr;
            }
        } else {
            numStr = Long.toString(number);
        }
        if (bytesLen == 8 && (number == Long.MIN_VALUE || Math.abs(number) >= Integer.MAX_VALUE)) {
            cast = true;
        }
        if (cast) {
            if (bytesLen == 8) {
                return (String)numStr + "L";
            }
            return StringUtils.getCastStr(bytesLen) + (String)numStr;
        }
        return numStr;
    }

    private static String getCastStr(int bytesLen) {
        switch (bytesLen) {
            case 1: {
                return "(byte) ";
            }
            case 2: {
                return "(short) ";
            }
            case 4: {
                return "(int) ";
            }
            case 8: {
                return "(long) ";
            }
        }
        throw new JadxRuntimeException("Unexpected number type length: " + bytesLen);
    }

    public String formatByte(long l, boolean cast) {
        return this.formatNumber(l, 1, cast);
    }

    public String formatShort(long l, boolean cast) {
        if (this.integerFormat == IntegerFormat.AUTO) {
            switch ((short)l) {
                case 32767: {
                    return "Short.MAX_VALUE";
                }
                case -32768: {
                    return "Short.MIN_VALUE";
                }
            }
        }
        return this.formatNumber(l, 2, cast);
    }

    public String formatInteger(long l, boolean cast) {
        if (this.integerFormat == IntegerFormat.AUTO) {
            switch ((int)l) {
                case 0x7FFFFFFF: {
                    return "Integer.MAX_VALUE";
                }
                case -2147483648: {
                    return "Integer.MIN_VALUE";
                }
            }
        }
        return this.formatNumber(l, 4, cast);
    }

    public String formatLong(long l, boolean cast) {
        if (this.integerFormat == IntegerFormat.AUTO) {
            if (l == Long.MAX_VALUE) {
                return "Long.MAX_VALUE";
            }
            if (l == Long.MIN_VALUE) {
                return "Long.MIN_VALUE";
            }
        }
        return this.formatNumber(l, 8, cast);
    }

    public static String formatDouble(double d) {
        if (Double.isNaN(d)) {
            return "Double.NaN";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "Double.NEGATIVE_INFINITY";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "Double.POSITIVE_INFINITY";
        }
        if (d == Double.MIN_VALUE) {
            return "Double.MIN_VALUE";
        }
        if (d == Double.MAX_VALUE) {
            return "Double.MAX_VALUE";
        }
        if (d == Double.MIN_NORMAL) {
            return "Double.MIN_NORMAL";
        }
        return Double.toString(d) + "d";
    }

    public static String formatFloat(float f) {
        if (Float.isNaN(f)) {
            return "Float.NaN";
        }
        if (f == Float.NEGATIVE_INFINITY) {
            return "Float.NEGATIVE_INFINITY";
        }
        if (f == Float.POSITIVE_INFINITY) {
            return "Float.POSITIVE_INFINITY";
        }
        if (f == Float.MIN_VALUE) {
            return "Float.MIN_VALUE";
        }
        if (f == Float.MAX_VALUE) {
            return "Float.MAX_VALUE";
        }
        if (f == Float.MIN_NORMAL) {
            return "Float.MIN_NORMAL";
        }
        return Float.toString(f) + "f";
    }

    public static String capitalizeFirstChar(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }
}

