/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.dex.attributes.AType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.IDexTreeVisitor;

public class DepthTraversal {
    public static void visit(IDexTreeVisitor visitor, ClassNode cls) {
        try {
            if (visitor.visit(cls)) {
                cls.getInnerClasses().forEach(inCls -> DepthTraversal.visit(visitor, inCls));
                cls.getMethods().forEach(mth -> DepthTraversal.visit(visitor, mth));
            }
        }
        catch (BootstrapMethodError | Exception | StackOverflowError e) {
            cls.addError(e.getClass().getSimpleName() + " in pass: " + visitor.getClass().getSimpleName(), e);
        }
    }

    public static void visit(IDexTreeVisitor visitor, MethodNode mth) {
        try {
            if (mth.contains(AType.JADX_ERROR)) {
                return;
            }
            visitor.visit(mth);
        }
        catch (BootstrapMethodError | Exception | StackOverflowError e) {
            mth.addError(e.getClass().getSimpleName() + " in pass: " + visitor.getClass().getSimpleName(), e);
        }
    }

    private DepthTraversal() {
    }
}

